/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.checkmarx.sdk.config.ScaProperties;
import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.sca.SCAParams;
import com.checkmarx.sdk.exception.SCARuntimeException;
import com.checkmarx.sdk.service.ScaClient;
import com.cx.restclient.CxShragaClient;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.DependencyScanResults;
import com.cx.restclient.dto.DependencyScannerType;
import com.cx.restclient.sca.dto.RemoteRepositoryInfo;
import com.cx.restclient.sca.dto.SCAConfig;
import com.cx.restclient.sca.dto.SCAResults;
import com.cx.restclient.sca.dto.SourceLocationType;
import com.cx.restclient.sca.dto.report.SCASummaryResults;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScaClientImpl
implements ScaClient {
    private static final Logger log = LoggerFactory.getLogger(ScaClientImpl.class);
    private static final String ERROR_PREFIX = "SCA scan cannot be initiated.";
    private static final int SCA_SCAN_INTERVAL_IN_SECONDS = 5;
    private final ScaProperties scaProperties;

    @Override
    public com.checkmarx.sdk.dto.sca.SCAResults scanRemoteRepo(SCAParams scaParams) throws IOException {
        this.validate(scaParams);
        CxScanConfig scanConfig = this.getScanConfig(scaParams);
        scanConfig.setOsaProgressInterval(Integer.valueOf(5));
        DependencyScanResults scanResults = this.executeScan(scanConfig);
        com.checkmarx.sdk.dto.sca.SCAResults scaResults = this.toScaResults(scanResults.getScaResults());
        this.applyScaResultsFilters(scaResults);
        return scaResults;
    }

    private void applyScaResultsFilters(com.checkmarx.sdk.dto.sca.SCAResults scaResults) {
        Double filterScore;
        if (this.scaProperties.getFilterSeverity() != null && !Objects.requireNonNull(this.scaProperties.getFilterSeverity()).isEmpty()) {
            this.filterResultsBySeverity(scaResults, this.scaProperties.getFilterSeverity());
        }
        if ((filterScore = this.scaProperties.getFilterScore()) != null && filterScore >= 0.0) {
            this.filterResultsByScore(scaResults, filterScore);
        } else {
            log.info("Cx-SCA filter score is not defined", (Object)filterScore);
        }
    }

    private void filterResultsBySeverity(com.checkmarx.sdk.dto.sca.SCAResults scaResults, List<String> filerSeverity) {
        List<String> validateFilterSeverity = this.validateFilterSeverity(filerSeverity);
        log.info("Applying Cx-SCA results filter severities: [{}]", (Object)validateFilterSeverity.toString());
        scaResults.getFindings().removeIf(finding -> !StringUtils.containsIgnoreCase((CharSequence)validateFilterSeverity.toString(), (CharSequence)finding.getSeverity().name()));
    }

    private void filterResultsByScore(com.checkmarx.sdk.dto.sca.SCAResults scaResults, double score) {
        log.info("Applying Cx-SCA results filter score: [{}]", (Object)score);
        scaResults.getFindings().removeIf(finding -> finding.getScore() < score);
    }

    private List<String> validateFilterSeverity(List<String> filerSeverity) {
        Iterator<String> iterator = filerSeverity.iterator();
        while (iterator.hasNext()) {
            String nextFilter = iterator.next();
            if (StringUtils.containsIgnoreCase((CharSequence)EnumSet.range(Filter.Severity.HIGH, Filter.Severity.LOW).toString(), (CharSequence)nextFilter)) continue;
            log.warn("Severity: [{}] is not a supported filter", (Object)nextFilter);
            iterator.remove();
        }
        return filerSeverity;
    }

    private com.checkmarx.sdk.dto.sca.SCAResults toScaResults(SCAResults scaResultsFromCommonClient) {
        this.validateNotNull(scaResultsFromCommonClient);
        SCASummaryResults summary = scaResultsFromCommonClient.getSummary();
        Map<Filter.Severity, Integer> findingCountsPerSeverity = this.getFindingCountMap(summary);
        ModelMapper mapper = new ModelMapper();
        com.checkmarx.sdk.dto.sca.SCAResults result = (com.checkmarx.sdk.dto.sca.SCAResults)mapper.map((Object)scaResultsFromCommonClient, com.checkmarx.sdk.dto.sca.SCAResults.class);
        result.getSummary().setFindingCounts(findingCountsPerSeverity);
        return result;
    }

    private Map<Filter.Severity, Integer> getFindingCountMap(SCASummaryResults summary) {
        EnumMap<Filter.Severity, Integer> result = new EnumMap<Filter.Severity, Integer>(Filter.Severity.class);
        result.put(Filter.Severity.HIGH, summary.getHighVulnerabilityCount());
        result.put(Filter.Severity.MEDIUM, summary.getMediumVulnerabilityCount());
        result.put(Filter.Severity.LOW, summary.getLowVulnerabilityCount());
        return result;
    }

    private CxScanConfig getScanConfig(SCAParams scaParams) {
        CxScanConfig cxScanConfig = new CxScanConfig();
        cxScanConfig.setDependencyScannerType(DependencyScannerType.SCA);
        cxScanConfig.setSastEnabled(Boolean.valueOf(false));
        cxScanConfig.setProjectName(scaParams.getProjectName());
        cxScanConfig.setScaConfig(this.getSCAConfig(scaParams));
        return cxScanConfig;
    }

    private SCAConfig getSCAConfig(SCAParams scaParams) {
        SCAConfig scaConfig = new SCAConfig();
        scaConfig.setWebAppUrl(this.scaProperties.getAppUrl());
        scaConfig.setApiUrl(this.scaProperties.getApiUrl());
        scaConfig.setAccessControlUrl(this.scaProperties.getAccessControlUrl());
        scaConfig.setTenant(this.scaProperties.getTenant());
        scaConfig.setUsername(this.scaProperties.getUsername());
        scaConfig.setPassword(this.scaProperties.getPassword());
        scaConfig.setSourceLocationType(SourceLocationType.REMOTE_REPOSITORY);
        RemoteRepositoryInfo remoteRepoInfo = new RemoteRepositoryInfo();
        remoteRepoInfo.setUrl(scaParams.getRemoteRepoUrl());
        scaConfig.setRemoteRepositoryInfo(remoteRepoInfo);
        return scaConfig;
    }

    private DependencyScanResults executeScan(CxScanConfig cxScanConfig) throws IOException {
        CxShragaClient client = new CxShragaClient(cxScanConfig, log);
        client.init();
        client.createDependencyScan();
        return client.waitForDependencyScanResults();
    }

    private void validate(SCAParams scaParams) {
        this.validateNotNull(scaParams);
        this.validateNotEmpty(this.scaProperties.getAppUrl(), "SCA application URL");
        this.validateNotEmpty(this.scaProperties.getApiUrl(), "SCA API URL");
        this.validateNotEmpty(this.scaProperties.getAccessControlUrl(), "SCA Access Control URL");
        this.validateNotEmpty(scaParams.getProjectName(), "Project name");
        this.validateNotEmpty(this.scaProperties.getTenant(), "SCA tenant");
        this.validateNotEmpty(this.scaProperties.getUsername(), "Username");
        this.validateNotEmpty(this.scaProperties.getPassword(), "Password");
    }

    private void validateNotNull(SCAParams scaParams) {
        if (scaParams == null) {
            throw new SCARuntimeException(String.format("%s SCA parameters weren't provided.", ERROR_PREFIX));
        }
        if (scaParams.getRemoteRepoUrl() == null) {
            throw new SCARuntimeException(String.format("%s Repository URL wasn't provided.", ERROR_PREFIX));
        }
    }

    private void validateNotNull(SCAResults scaResults) {
        if (scaResults == null) {
            throw new SCARuntimeException("SCA results are missing.");
        }
        SCASummaryResults summary = scaResults.getSummary();
        if (summary == null) {
            throw new SCARuntimeException("SCA results don't contain a summary.");
        }
    }

    private void validateNotEmpty(String parameter, String parameterDescr) {
        if (StringUtils.isEmpty((CharSequence)parameter)) {
            String message = String.format("%s %s wasn't provided", ERROR_PREFIX, parameterDescr);
            throw new SCARuntimeException(message);
        }
    }

    public ScaClientImpl(ScaProperties scaProperties) {
        this.scaProperties = scaProperties;
    }
}

