/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.cx.xml.QueryType;
import com.checkmarx.sdk.dto.cx.xml.ResultType;
import com.checkmarx.sdk.dto.filtering.FilterConfiguration;
import com.checkmarx.sdk.dto.filtering.ScriptInput;
import com.checkmarx.sdk.dto.filtering.ScriptedFilter;
import com.checkmarx.sdk.exception.CheckmarxRuntimeException;
import com.checkmarx.sdk.service.FilterValidator;
import com.google.common.collect.ImmutableMap;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Script;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FilterValidatorImpl
implements FilterValidator {
    private static final Logger log = LoggerFactory.getLogger(FilterValidatorImpl.class);
    private static final Map<String, String> STATE_MAP = ImmutableMap.of((Object)"TO VERIFY", (Object)"0", (Object)"CONFIRMED", (Object)"2", (Object)"URGENT", (Object)"3", (Object)"PROPOSED NOT EXPLOITABLE", (Object)"4");
    private static final Map<String, String> STATE_ID_TO_NAME = FilterValidatorImpl.getInvertedStateMap();
    private static final String INPUT_VARIABLE_NAME = "finding";

    @Override
    public boolean passesFilter(@NotNull QueryType findingGroup, @NotNull ResultType finding, FilterConfiguration filterConfiguration) {
        boolean hasSimpleFilters = FilterValidatorImpl.hasSimpleFilters(filterConfiguration);
        boolean hasScriptedFilter = FilterValidatorImpl.hasScriptedFilter(filterConfiguration);
        if (hasScriptedFilter && hasSimpleFilters) {
            throw new CheckmarxRuntimeException("Simple filters and scripted filter cannot be used together. Please either specify one of them or don't use filters.");
        }
        boolean result = !hasSimpleFilters && !hasScriptedFilter ? true : (hasScriptedFilter ? FilterValidatorImpl.passesScriptedFilter(findingGroup, finding, filterConfiguration) : FilterValidatorImpl.passesSimpleFilter(findingGroup, finding, filterConfiguration));
        log.debug("Finding {} {} the filter.", (Object)finding.getNodeId(), (Object)(result ? "passes" : "does not pass"));
        return result;
    }

    private static boolean passesScriptedFilter(QueryType findingGroup, ResultType finding, FilterConfiguration filterConfiguration) {
        ScriptedFilter filter = filterConfiguration.getScriptedFilter();
        ScriptInput input = FilterValidatorImpl.getScriptInput(findingGroup, finding);
        return FilterValidatorImpl.evaluateFilterScript(filter.getScript(), input);
    }

    private static boolean passesSimpleFilter(QueryType findingGroup, ResultType finding, FilterConfiguration filterConfiguration) {
        List<Filter> filters = filterConfiguration.getSimpleFilters();
        return CollectionUtils.isEmpty(filters) || FilterValidatorImpl.findingGroupPassesFilter(findingGroup, filters) && FilterValidatorImpl.findingPassesFilter(finding, filters);
    }

    private static boolean hasScriptedFilter(FilterConfiguration filterConfiguration) {
        return filterConfiguration != null && filterConfiguration.getScriptedFilter() != null && filterConfiguration.getScriptedFilter().getScript() != null;
    }

    private static boolean hasSimpleFilters(FilterConfiguration filterConfiguration) {
        return filterConfiguration != null && CollectionUtils.isNotEmpty(filterConfiguration.getSimpleFilters());
    }

    private static boolean findingGroupPassesFilter(QueryType findingGroup, List<Filter> filters) {
        ArrayList<String> severity = new ArrayList<String>();
        ArrayList<String> cwe = new ArrayList<String>();
        ArrayList<String> category = new ArrayList<String>();
        for (Filter filter : filters) {
            Filter.Type type = filter.getType();
            String value = filter.getValue();
            ArrayList<String> targetList = null;
            if (type.equals((Object)Filter.Type.SEVERITY)) {
                targetList = severity;
            } else if (type.equals((Object)Filter.Type.TYPE)) {
                targetList = category;
            } else if (type.equals((Object)Filter.Type.CWE)) {
                targetList = cwe;
            }
            if (targetList == null) continue;
            targetList.add(value.toUpperCase(Locale.ROOT));
        }
        return FilterValidatorImpl.fieldMatches(findingGroup.getSeverity(), severity) && FilterValidatorImpl.fieldMatches(findingGroup.getCweId(), cwe) && FilterValidatorImpl.fieldMatches(findingGroup.getName(), category);
    }

    private static boolean findingPassesFilter(ResultType finding, List<Filter> filters) {
        ArrayList<String> statuses = new ArrayList<String>();
        ArrayList<String> states = new ArrayList<String>();
        for (Filter filter : filters) {
            if (filter.getType().equals((Object)Filter.Type.STATUS)) {
                statuses.add(filter.getValue().toUpperCase(Locale.ROOT));
                continue;
            }
            if (!filter.getType().equals((Object)Filter.Type.STATE)) continue;
            String stateName = filter.getValue().toUpperCase(Locale.ROOT);
            String stateId = STATE_MAP.get(stateName);
            if (stateId == null) {
                log.warn("Unknown status is specified in filter: '{}'. This filter value will be ignored.", (Object)filter.getValue());
                continue;
            }
            states.add(stateId);
        }
        return FilterValidatorImpl.fieldMatches(finding.getStatus(), statuses) && FilterValidatorImpl.fieldMatches(finding.getState(), states);
    }

    private static ScriptInput getScriptInput(QueryType findingGroup, ResultType finding) {
        String stateName = STATE_ID_TO_NAME.get(finding.getState());
        return ScriptInput.builder().category(findingGroup.getName().toUpperCase(Locale.ROOT)).cwe(findingGroup.getCweId()).severity(findingGroup.getSeverity().toUpperCase(Locale.ROOT)).status(finding.getStatus().toUpperCase(Locale.ROOT)).state(stateName).build();
    }

    private static boolean evaluateFilterScript(Script script, ScriptInput input) {
        Binding binding = new Binding();
        binding.setVariable(INPUT_VARIABLE_NAME, (Object)input);
        script.setBinding(binding);
        Object rawResult = null;
        try {
            rawResult = script.run();
        }
        catch (GroovyRuntimeException e) {
            FilterValidatorImpl.rethrowWithDetailedMessage(e);
        }
        catch (Exception e) {
            throw new CheckmarxRuntimeException("An unexpected error has occurred while executing the filter script.", e);
        }
        if (rawResult instanceof Boolean) {
            return (Boolean)rawResult;
        }
        throw new CheckmarxRuntimeException("Filtering script must return a boolean value.");
    }

    private static void rethrowWithDetailedMessage(GroovyRuntimeException cause) {
        List existingFields = Arrays.stream(ScriptInput.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        String message = String.format("A runtime error has occurred while executing the filter script. Please use %s.<property> in your expressions, where <property> is one of %s.", INPUT_VARIABLE_NAME, existingFields);
        throw new CheckmarxRuntimeException(message, cause);
    }

    private static boolean fieldMatches(String fieldValue, List<String> allowedValues) {
        return allowedValues.isEmpty() || allowedValues.contains(fieldValue.toUpperCase(Locale.ROOT));
    }

    private static Map<String, String> getInvertedStateMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : STATE_MAP.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return ImmutableMap.copyOf(result);
    }
}

