/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.checkmarx.sdk.config.ScaConfig;
import com.checkmarx.sdk.config.ScaProperties;
import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.ast.ASTResultsWrapper;
import com.checkmarx.sdk.dto.ast.SCAResults;
import com.checkmarx.sdk.dto.ast.ScanParams;
import com.checkmarx.sdk.exception.ASTRuntimeException;
import com.cx.restclient.AbstractAstClient;
import com.cx.restclient.CxClientDelegator;
import com.cx.restclient.ast.dto.common.ASTConfig;
import com.cx.restclient.ast.dto.common.SummaryResults;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.ast.dto.sca.report.AstScaSummaryResults;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ScanResults;
import com.cx.restclient.dto.ScannerType;
import java.io.File;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScaClientImpl
extends AbstractAstClient {
    private static final Logger log = LoggerFactory.getLogger(ScaClientImpl.class);
    private final ScaProperties scaProperties;

    @Override
    protected void applyScaResultsFilters(ASTResultsWrapper combinedResults, ScanParams scanParams) {
        Double appliedFilterScore;
        List<String> appliedFilterSeverity;
        SCAResults scaResults = combinedResults.getScaResults();
        List<String> filterSeverityFromRequest = null;
        Double filterScoreFromRequest = null;
        if (Optional.ofNullable(scanParams.getScaConfig()).isPresent()) {
            filterSeverityFromRequest = scanParams.getScaConfig().getFilterSeverity();
            filterScoreFromRequest = scanParams.getScaConfig().getFilterScore();
        }
        if ((appliedFilterSeverity = this.getFilterSeverity(filterSeverityFromRequest)) != null && !Objects.requireNonNull(appliedFilterSeverity).isEmpty()) {
            this.filterResultsBySeverity(scaResults, appliedFilterSeverity);
        }
        if (this.isNotEmptyDouble(appliedFilterScore = this.getFilterScore(filterScoreFromRequest))) {
            this.filterResultsByScore(scaResults, appliedFilterScore);
        } else {
            log.info("CxSCA filter score is not defined");
        }
    }

    private Double getFilterScore(Double filterScoreFromRequest) {
        Double appliedFilterScore = this.isNotEmptyDouble(filterScoreFromRequest) ? filterScoreFromRequest : this.scaProperties.getFilterScore();
        return appliedFilterScore;
    }

    private List<String> getFilterSeverity(List<String> filterSeverityFromRequest) {
        List<String> appliedFilterSeverity = CollectionUtils.isNotEmpty(filterSeverityFromRequest) ? filterSeverityFromRequest : this.scaProperties.getFilterSeverity();
        return appliedFilterSeverity;
    }

    private void filterResultsBySeverity(SCAResults scaResults, List<String> filerSeverity) {
        List<String> validateFilterSeverity = this.validateFilterSeverity(filerSeverity);
        log.info("Applying Cx-SCA results filter severities: [{}]", (Object)validateFilterSeverity.toString());
        scaResults.getFindings().removeIf(finding -> !StringUtils.containsIgnoreCase((CharSequence)validateFilterSeverity.toString(), (CharSequence)finding.getSeverity().name()));
    }

    private void filterResultsByScore(SCAResults scaResults, double score) {
        log.info("Applying Cx-SCA results filter score: [{}]", (Object)score);
        scaResults.getFindings().removeIf(finding -> finding.getScore() < score);
    }

    private List<String> validateFilterSeverity(List<String> filerSeverity) {
        Iterator<String> iterator = filerSeverity.iterator();
        while (iterator.hasNext()) {
            String nextFilter = iterator.next();
            if (StringUtils.containsIgnoreCase((CharSequence)EnumSet.range(Filter.Severity.HIGH, Filter.Severity.LOW).toString(), (CharSequence)nextFilter)) continue;
            log.warn("Severity: [{}] is not a supported filter", (Object)nextFilter);
            iterator.remove();
        }
        return filerSeverity;
    }

    @Override
    protected ASTResultsWrapper toResults(ScanResults scaResultsFromCommonClient) {
        this.validateNotNull(scaResultsFromCommonClient.getScaResults());
        AstScaSummaryResults summary = scaResultsFromCommonClient.getScaResults().getSummary();
        Map<Filter.Severity, Integer> findingCountsPerSeverity = this.getFindingCountMap((SummaryResults)summary);
        ModelMapper mapper = new ModelMapper();
        SCAResults result = (SCAResults)mapper.map((Object)scaResultsFromCommonClient.getScaResults(), SCAResults.class);
        result.getSummary().setFindingCounts(findingCountsPerSeverity);
        ASTResultsWrapper results = new ASTResultsWrapper();
        results.setScaResults(result);
        return results;
    }

    @Override
    public ASTResultsWrapper getLatestScanResults(ScanParams scanParams) {
        CxScanConfig commonClientScanConfig = this.getScanConfig(scanParams);
        try {
            ASTResultsWrapper result;
            CxClientDelegator client = new CxClientDelegator(commonClientScanConfig, log);
            client.init();
            ScanResults commonClientResults = client.getLatestScanResults();
            if (commonClientResults.getScaResults() != null) {
                result = this.toResults(commonClientResults);
                this.applyScaResultsFilters(result, scanParams);
            } else {
                result = new ASTResultsWrapper();
            }
            return result;
        }
        catch (Exception e) {
            throw new ASTRuntimeException("Error getting latest scan results.", e);
        }
    }

    @Override
    protected CxScanConfig getScanConfig(ScanParams scanParams) {
        CxScanConfig cxScanConfig = new CxScanConfig();
        cxScanConfig.addScannerType(ScannerType.AST_SCA);
        cxScanConfig.setSastEnabled(false);
        cxScanConfig.setProjectName(scanParams.getProjectName());
        AstScaConfig scaConfig = this.getScaSpecificConfig(scanParams);
        ScaClientImpl.setSourceLocation(scanParams, cxScanConfig, (ASTConfig)scaConfig);
        cxScanConfig.setAstScaConfig(scaConfig);
        return cxScanConfig;
    }

    private AstScaConfig getScaSpecificConfig(ScanParams scanParams) {
        AstScaConfig scaConfig = new AstScaConfig();
        String appUrlFromRequest = null;
        String apiUrlFromRequest = null;
        String accessControlUrlFromRequest = null;
        String tenantFromRequest = null;
        if (Optional.ofNullable(scanParams.getScaConfig()).isPresent()) {
            appUrlFromRequest = scanParams.getScaConfig().getAppUrl();
            apiUrlFromRequest = scanParams.getScaConfig().getApiUrl();
            accessControlUrlFromRequest = scanParams.getScaConfig().getAccessControlUrl();
            tenantFromRequest = scanParams.getScaConfig().getTenant();
        }
        scaConfig.setWebAppUrl((String)Optional.ofNullable(appUrlFromRequest).orElse(this.scaProperties.getAppUrl()));
        scaConfig.setApiUrl(Optional.ofNullable(apiUrlFromRequest).orElse(this.scaProperties.getApiUrl()));
        scaConfig.setAccessControlUrl(Optional.ofNullable(accessControlUrlFromRequest).orElse(this.scaProperties.getAccessControlUrl()));
        scaConfig.setTenant(Optional.ofNullable(tenantFromRequest).orElse(this.scaProperties.getTenant()));
        scaConfig.setUsername(this.scaProperties.getUsername());
        scaConfig.setPassword(this.scaProperties.getPassword());
        return scaConfig;
    }

    @Override
    protected void validate(ScanParams scaParams) {
        ScaClientImpl.validateNotNull(scaParams);
        ScaConfig scaConfig = scaParams.getScaConfig();
        if (Optional.ofNullable(scaConfig).isPresent()) {
            this.validateNotEmpty(scaConfig.getAppUrl(), "SCA application URL");
            this.validateNotEmpty(scaConfig.getApiUrl(), "SCA API URL");
            this.validateNotEmpty(scaConfig.getAccessControlUrl(), "SCA Access Control URL");
            this.validateNotEmpty(scaConfig.getTenant(), "SCA tenant");
        } else {
            this.validateNotEmpty(this.scaProperties.getAppUrl(), "SCA application URL");
            this.validateNotEmpty(this.scaProperties.getApiUrl(), "SCA API URL");
            this.validateNotEmpty(this.scaProperties.getAccessControlUrl(), "SCA Access Control URL");
            this.validateNotEmpty(scaParams.getProjectName(), "Project name");
            this.validateNotEmpty(this.scaProperties.getTenant(), "SCA tenant");
            this.validateNotEmpty(this.scaProperties.getUsername(), "Username");
            this.validateNotEmpty(this.scaProperties.getPassword(), "Password");
        }
    }

    private static void validateNotNull(ScanParams scanParams) {
        if (scanParams == null) {
            throw new ASTRuntimeException(String.format("%s SCA parameters weren't provided.", "Scan cannot be initiated."));
        }
        if (scanParams.getRemoteRepoUrl() == null && !ScaClientImpl.localSourcesAreSpecified(scanParams)) {
            String message = String.format("%s Source location is not specified. Please specify either repository URL, zip file path or source directory path.", "Scan cannot be initiated.");
            throw new ASTRuntimeException(message);
        }
        ScaClientImpl.validateSpecifiedPathExists(scanParams.getZipPath());
        ScaClientImpl.validateSpecifiedPathExists(scanParams.getSourceDir());
    }

    private static void validateSpecifiedPathExists(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && !new File(path).exists()) {
            throw new ASTRuntimeException(String.format("%s Source location (%s) does not exist.", "Scan cannot be initiated.", path));
        }
    }

    private void validateNotNull(AstScaResults scaResults) {
        if (scaResults == null) {
            throw new ASTRuntimeException("SCA results are missing.");
        }
        AstScaSummaryResults summary = scaResults.getSummary();
        if (summary == null) {
            throw new ASTRuntimeException("SCA results don't contain a summary.");
        }
    }

    private boolean isNotEmptyDouble(Double d) {
        return d != null && d >= 0.0;
    }

    public ScaClientImpl(ScaProperties scaProperties) {
        this.scaProperties = scaProperties;
    }
}

