/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.config;

import com.checkmarx.sdk.config.CxProperties;
import java.nio.charset.Charset;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class CxConfig {
    private final CxProperties properties;

    public CxConfig(CxProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"cxRestTemplate"})
    public RestTemplate getRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)HttpClientBuilder.create().useSystemProperties().build());
        requestFactory.setConnectTimeout(this.properties.getHttpConnectionTimeout().intValue());
        requestFactory.setReadTimeout(this.properties.getHttpReadTimeout().intValue());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        return restTemplate;
    }
}

