/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.ScanResults;
import com.checkmarx.sdk.dto.cx.CxProject;
import com.checkmarx.sdk.dto.cx.CxRole;
import com.checkmarx.sdk.dto.cx.CxRoleLdap;
import com.checkmarx.sdk.dto.cx.CxScanParams;
import com.checkmarx.sdk.dto.cx.CxScanSummary;
import com.checkmarx.sdk.dto.cx.CxTeam;
import com.checkmarx.sdk.dto.cx.CxTeamLdap;
import com.checkmarx.sdk.dto.od.OdApplicationCreate;
import com.checkmarx.sdk.dto.od.OdBusinessUnitCreate;
import com.checkmarx.sdk.dto.od.OdFileUpload;
import com.checkmarx.sdk.dto.od.OdNavigationTree;
import com.checkmarx.sdk.dto.od.OdProjectCreate;
import com.checkmarx.sdk.dto.od.OdProjectList;
import com.checkmarx.sdk.dto.od.OdProjectListDataItem;
import com.checkmarx.sdk.dto.od.OdScan;
import com.checkmarx.sdk.dto.od.OdScanCreate;
import com.checkmarx.sdk.dto.od.OdScanFileResult;
import com.checkmarx.sdk.dto.od.OdScanFileUpload;
import com.checkmarx.sdk.dto.od.OdScanFileUploadData;
import com.checkmarx.sdk.dto.od.OdScanFileUploadFields;
import com.checkmarx.sdk.dto.od.OdScanList;
import com.checkmarx.sdk.dto.od.OdScanListDataItem;
import com.checkmarx.sdk.dto.od.OdScanNodeItem;
import com.checkmarx.sdk.dto.od.OdScanNodes;
import com.checkmarx.sdk.dto.od.OdScanQueries;
import com.checkmarx.sdk.dto.od.OdScanQueryCategory;
import com.checkmarx.sdk.dto.od.OdScanQueryItem;
import com.checkmarx.sdk.dto.od.OdScanQuerySeverity;
import com.checkmarx.sdk.dto.od.OdScanResultItem;
import com.checkmarx.sdk.dto.od.OdScanResults;
import com.checkmarx.sdk.dto.od.OdScanTrigger;
import com.checkmarx.sdk.dto.od.OdScanTriggerResult;
import com.checkmarx.sdk.exception.CheckmarxException;
import com.checkmarx.sdk.service.CxAuthClient;
import com.checkmarx.sdk.service.CxClient;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class CxService
implements CxClient {
    private static final String UNKNOWN = "-1";
    private static final Integer SCAN_STATUS_FINISHED = 7;
    private static final Integer SCAN_STATUS_CANCELED = 8;
    private static final Integer SCAN_STATUS_FAILED = 9;
    public static final Integer CXOD_MOBILE_NATIVE = 1;
    public static final Integer CXOD_MOBILE_WEB_BASED = 2;
    public static final Integer CXOD_DESKTOP_NATIVE = 3;
    public static final Integer CXOD_DESKTOP_WEB = 4;
    public static final Integer CXOD_API = 5;
    public static final Integer CXOD_FRONTEND = 6;
    public static final Integer CXOD_BACKEND = 7;
    public static final Integer CXOD_LAMBDA = 8;
    public static final Integer CXOD_CLI = 9;
    public static final Integer CXOD_SERVICE = 10;
    public static final Integer CXOD_SMART_DEVICE = 11;
    public static final Integer CXOD_OTHER = 12;
    public static final Integer REPORT_STATUS_CREATED = 2;
    private static final Map<String, Integer> STATUS_MAP = ImmutableMap.of((Object)"TO VERIFY", (Object)0, (Object)"CONFIRMED", (Object)2, (Object)"URGENT", (Object)3, (Object)"PROPOSED NOT EXPLOITABLE", (Object)4);
    private static final Logger log = LoggerFactory.getLogger(CxService.class);
    private static final String TEAMS = "/business-units/business-units";
    private static final String CREATE_SCAN = "/scans/scans";
    private static final String UPLOADS_SCAN_FILE = "/files/files/upload-zip";
    private static final String TRIGGER_SCAN = "/scans/scan";
    private static final String SCAN_QUERIES = "/projects/projects/{project_id}/scans/{scan_id}/queries";
    private static final String SCAN_RESULTS_ENCODED = "/results/results?criteria=%7B%22filters%22%3A%5B%5D%2C%22criteria%22%3A%5B%7B%22key%22%3A%22projectId%22%2C%22value%22%3A%22{project_id}%22%7D%2C%7B%22key%22%3A%22scanId%22%2C%22value%22%3A%22{scan_id}%22%7D%2C%7B%22key%22%3A%22queryId%22%2C%22value%22%3A%22{query_id}%22%7D%5D%2C%22sorting%22%3A%5B%5D%2C%22pagination%22%3A%7B%22currentPage%22%3A0%2C%22pageSize%22%3A50%7D%7D";
    private static final String SCAN_RESULT_NODES_ENCODED = "/nodes/nodes?criteria=%7B%22criteria%22%3A%5B%7B%22key%22%3A%22projectId%22%2C%22value%22%3A%22{project_id}%22%7D%2C%7B%22key%22%3A%22scanId%22%2C%22value%22%3A%22{scan_id}%22%7D%2C%7B%22key%22%3A%22resultId%22%2C%22value%22%3A%22{result_id}%22%7D%5D%2C%22sorting%22%3A%5B%5D%7D";
    private static final String SCAN_FILE = "/projects/projects/{project_id}/scans/{scan_id}/files?filePath={file_path};";
    private static final String CREATE_APPLICATION = "/applications/applications";
    private static final String CREATE_PROJECT = "/projects/projects";
    private static final String GET_PROJECTS = "/projects/projects?criteria=%7B%22criteria%22%3A%5B%7B%22key%22%3A%22applicationId%22%2C%22value%22%3A%22{app_id}%22%7D%5D%2C%22pagination%22%3A%7B%22currentPage%22%3A0%2C%22pageSize%22%3A50%7D%2C%22sorting%22%3A%5B%5D%7D";
    private static final String GET_SCAN_STATUS = "/scans/scans?criteria=%7B%22criteria%22%3A%5B%7B%22key%22%3A%22projectId%22%2C%22value%22%3A%22{project_id}%22%7D%5D%2C%22pagination%22%3A%7B%22currentPage%22%3A0%2C%22pageSize%22%3A50%7D%2C%22sorting%22%3A%5B%5D%7D";
    private static Map<String, Integer> scanIdMap = new HashMap<String, Integer>();
    private final CxProperties cxProperties;
    private final CxAuthClient authClient;
    private final RestTemplate restTemplate;
    private Map<String, Object> codeCache = new HashMap<String, Object>();

    public CxService(CxAuthClient authClient, CxProperties cxProperties, @Qualifier(value="cxRestTemplate") RestTemplate restTemplate) {
        this.authClient = authClient;
        this.cxProperties = cxProperties;
        this.restTemplate = restTemplate;
    }

    private String createApplication(String appName, String appDesc, String baBuId) {
        log.info("Creating new CxOD application {}.", (Object)appName);
        HttpEntity httpEntity = new HttpEntity((Object)this.getJSONCreateAppReq(appName, appDesc, baBuId), (MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity createResp = this.restTemplate.exchange(this.cxProperties.getUrl().concat(CREATE_APPLICATION), HttpMethod.PUT, httpEntity, OdApplicationCreate.class, new Object[0]);
        OdApplicationCreate appCreate = (OdApplicationCreate)createResp.getBody();
        return appCreate.getData().getBaId();
    }

    private String getJSONCreateAppReq(String appName, String appDesc, String baBuId) {
        JSONObject requestBody = new JSONObject();
        JSONObject createBody = new JSONObject();
        try {
            createBody.put("baName", (Object)appName);
            createBody.put("description", (Object)appDesc);
            createBody.put("criticality", 5);
            createBody.put("baBuId", (Object)baBuId);
            requestBody.put("businessApplication", (Object)createBody);
        }
        catch (JSONException e) {
            log.error("Error generating JSON App create Request object - JSON object will be empty");
        }
        return requestBody.toString();
    }

    private String createCxODProject(String appId, String projectName) {
        log.info("Creating new CxOD project.");
        HttpEntity httpEntity = new HttpEntity((Object)this.getJSONCreateProjectReq(appId, projectName), (MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity createResp = this.restTemplate.exchange(this.cxProperties.getUrl().concat(CREATE_PROJECT), HttpMethod.PUT, httpEntity, OdProjectCreate.class, new Object[0]);
        OdProjectCreate appCreate = (OdProjectCreate)createResp.getBody();
        return appCreate.getData().getId();
    }

    private String getJSONCreateProjectReq(String appId, String projectName) {
        JSONObject requestBody = new JSONObject();
        JSONObject createBody = new JSONObject();
        try {
            createBody.put("businessApplicationId", (Object)appId);
            createBody.put("name", (Object)projectName);
            createBody.put("description", (Object)"");
            String preset = this.cxProperties.getScanPreset();
            String[] jd = preset.split(",");
            int[] typeList = new int[]{1, 2};
            createBody.put("typeIds", (Object)jd);
            createBody.put("criticality", 5);
            requestBody.put("project", (Object)createBody);
        }
        catch (JSONException e) {
            log.error("Error generating JSON Project create Request object - JSON object will be empty");
        }
        return requestBody.toString();
    }

    @Override
    public Integer createScan(CxScanParams params, String comment) throws CheckmarxException {
        String appID = params.getTeamId();
        Integer projectID = this.getProjectId(appID, params.getProjectName());
        if (projectID == -1) {
            projectID = Integer.parseInt(this.createCxODProject(appID, params.getProjectName()));
        }
        params.setProjectId(projectID);
        OdScan scan = OdScan.builder().projectId(params.getProjectId()).build();
        log.info("Sending scan to CxOD for projectID {}.", (Object)params.getProjectId());
        HttpHeaders headers = this.authClient.createAuthHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)scan, (MultiValueMap)headers);
        ResponseEntity createResp = this.restTemplate.exchange(this.cxProperties.getUrl().concat(CREATE_SCAN), HttpMethod.PUT, httpEntity, OdScanCreate.class, new Object[0]);
        OdScanCreate scanCreate = (OdScanCreate)createResp.getBody();
        String scanId = scanCreate.getData().getId();
        log.info("CxOD started scan with scanId {}.", (Object)scanId);
        log.info("CxOD Uploading Scan file {}.", (Object)scanId);
        OdFileUpload fileUpload = OdFileUpload.builder().projectId(params.getProjectId().toString(), scanId, "junkstuff").build();
        httpEntity = new HttpEntity((Object)fileUpload, (MultiValueMap)headers);
        ResponseEntity uploadResp = this.restTemplate.exchange(this.cxProperties.getUrl().concat(UPLOADS_SCAN_FILE), HttpMethod.POST, httpEntity, OdScanFileUpload.class, new Object[0]);
        OdScanFileUpload scanUpload = (OdScanFileUpload)uploadResp.getBody();
        OdScanFileUploadData data = scanUpload.getData();
        OdScanFileUploadFields s3Fields = data.getFields();
        String bucketURL = data.getUrl();
        File test = new File("C:\\Users\\JeffA\\Downloads\\dvna-master.zip");
        String s3FilePath = this.postS3File(bucketURL, "testProj.zip", test, s3Fields);
        log.info("CxOD Triggering the scan {}.", (Object)scanId);
        LinkedList<String> typeIds = new LinkedList<String>();
        int[] typeList = new int[]{1, 2};
        OdScanTrigger scanTrigger = OdScanTrigger.builder().projectId(params.getProjectId().toString(), scanId, s3FilePath, typeIds).build();
        httpEntity = new HttpEntity((Object)scanTrigger, (MultiValueMap)headers);
        ResponseEntity triggerResp = this.restTemplate.exchange(this.cxProperties.getUrl().concat(TRIGGER_SCAN), HttpMethod.POST, httpEntity, OdScanTriggerResult.class, new Object[0]);
        OdScanTriggerResult triggerResult = (OdScanTriggerResult)triggerResp.getBody();
        scanIdMap.put(scanId, projectID);
        return Integer.parseInt(scanId);
    }

    private String postS3File(String targetURL, String filename, File file, OdScanFileUploadFields s3Fields) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"key", (Object)s3Fields.getKey());
            body.add((Object)"bucket", (Object)s3Fields.getBucket());
            body.add((Object)"X-Amz-Algorithm", (Object)s3Fields.getX_Amz_Algorithm());
            body.add((Object)"X-Amz-Credential", (Object)s3Fields.getX_Amz_Credential());
            body.add((Object)"X-Amz-Date", (Object)s3Fields.getX_Amz_Date());
            body.add((Object)"X-Amz-Security-Token", (Object)s3Fields.getX_Amz_Security_Token());
            body.add((Object)"Policy", (Object)s3Fields.getPolicy());
            body.add((Object)"X-Amz-Signature", (Object)s3Fields.getX_Amz_Signature());
            LinkedMultiValueMap fileMap = new LinkedMultiValueMap();
            ContentDisposition contentDisposition = ContentDisposition.builder((String)"form-data").name("file").filename(filename).build();
            FileSystemResource fsr = new FileSystemResource(file);
            body.add((Object)"file", (Object)fsr);
            HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity s3Resp = this.restTemplate.exchange(targetURL, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            URI s3FilePath = s3Resp.getHeaders().getLocation();
            return URLDecoder.decode(s3FilePath.toString(), StandardCharsets.UTF_8.name());
        }
        catch (HttpClientErrorException e) {
            log.info("CxOD error uploading file.");
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            log.info("CxOD code not decode S3 file path.");
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getTeamId(String teamPath) throws CheckmarxException {
        String[] buTokens = teamPath.split(Pattern.quote("\\"));
        OdNavigationTree navTree = this.getNavigationTree();
        LinkedHashMap navTreeData = (LinkedHashMap)navTree.getAdditionalProperties().get("data");
        ArrayList tree = (ArrayList)navTreeData.get("tree");
        int i = 1;
        String token = buTokens[i++];
        for (LinkedHashMap item : tree) {
            Object o = item.get("id");
            Integer id = (Integer)o;
            o = item.get("title");
            String title = (String)o;
            title = title.trim();
            o = item.get("children");
            ArrayList children = (ArrayList)o;
            if (!title.equals(token)) continue;
            if (i == buTokens.length) {
                return id.toString();
            }
            return this.searchTreeChildren(buTokens, i, children);
        }
        return UNKNOWN;
    }

    private String searchTreeChildren(String[] buTokens, int i, ArrayList<Object> children) {
        String token = buTokens[i++];
        for (Object item : children) {
            LinkedHashMap node = (LinkedHashMap)item;
            Object o = node.get("id");
            Integer id = (Integer)o;
            o = node.get("title");
            String title = (String)o;
            title = title.trim();
            o = node.get("children");
            ArrayList nodeChildren = (ArrayList)o;
            if (!title.equals(token)) continue;
            if (i == buTokens.length) {
                return id.toString();
            }
            return this.searchTreeChildren(buTokens, i, nodeChildren);
        }
        return UNKNOWN;
    }

    private OdNavigationTree getNavigationTree() throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.info("Retrieving OD Navigation Tree");
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat("/navigation-tree/navigation-tree"), HttpMethod.GET, httpEntity, OdNavigationTree.class, new Object[0]);
            OdNavigationTree tree = (OdNavigationTree)response.getBody();
            return tree;
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving the navigation tree.");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error retrieving Business Units.");
        }
    }

    @Override
    public String createTeam(String parentID, String teamName) throws CheckmarxException {
        return this.createApplication(teamName, "Generated by CxFlow", parentID);
    }

    private String createCxODBusinessUnit(String parentID, String teamName) {
        log.info("Create OD Business Unit {} with parentID {}", (Object)teamName, (Object)parentID);
        HttpEntity httpEntity = new HttpEntity((Object)this.getJSONCreateBUReq(parentID, teamName), (MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(TEAMS), HttpMethod.PUT, httpEntity, OdBusinessUnitCreate.class, new Object[0]);
        OdBusinessUnitCreate buCreate = (OdBusinessUnitCreate)response.getBody();
        return buCreate.getData().getId();
    }

    private String getJSONCreateBUReq(String parentID, String name) {
        JSONObject requestBody = new JSONObject();
        JSONObject createBody = new JSONObject();
        try {
            createBody.put("buParentId", (Object)parentID);
            createBody.put("buName", (Object)name);
            requestBody.put("businessUnit", (Object)createBody);
        }
        catch (JSONException e) {
            log.error("Error generating JSON BU create Request object - JSON object will be empty");
        }
        return requestBody.toString();
    }

    @Override
    public ScanResults getReportContentByScanId(Integer scanId, List<Filter> filter) throws CheckmarxException {
        ScanResults.ScanResultsBuilder scanResults = ScanResults.builder();
        Integer projectId = scanIdMap.get(scanId.toString());
        this.getScanQueries(scanResults, projectId, scanId);
        return scanResults.build();
    }

    private void getScanQueries(ScanResults.ScanResultsBuilder scanResults, Integer projectId, Integer scanId) {
        CxScanSummary scanSummary = new CxScanSummary();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN_QUERIES), HttpMethod.GET, httpEntity, OdScanQueries.class, new Object[]{projectId, scanId});
        OdScanQueries scanQueries = (OdScanQueries)response.getBody();
        ArrayList<ScanResults.XIssue> xIssueList = new ArrayList<ScanResults.XIssue>();
        for (OdScanQueryItem item : scanQueries.getData().getItems()) {
            this.summarizeSeverity(scanSummary, item);
            ScanResults.XIssue.XIssueBuilder xib = ScanResults.XIssue.builder();
            String testURL = this.cxProperties.getUrl().concat("/scan/business-unit/76/application/10001/project/10006/scans/10088");
            xib.link(testURL);
            xib.language(item.getLanguage());
            for (OdScanQueryCategory vulnerability : item.getCategories()) {
                xib.severity(vulnerability.getSeverity());
                xib.vulnerability(vulnerability.getTitle());
                this.getScanResults(xib, projectId, scanId, vulnerability.getId());
                ScanResults.XIssue issue = xib.build();
                if (xIssueList.contains(issue)) continue;
                xIssueList.add(issue);
            }
        }
        scanResults.scanSummary(scanSummary);
        scanResults.xIssues(xIssueList);
    }

    private void summarizeSeverity(CxScanSummary scanSummary, OdScanQueryItem vulnerability) {
        if (scanSummary.getLowSeverity() == null) {
            scanSummary.setLowSeverity(0);
        }
        if (scanSummary.getMediumSeverity() == null) {
            scanSummary.setMediumSeverity(0);
        }
        if (scanSummary.getHighSeverity() == null) {
            scanSummary.setHighSeverity(0);
        }
        for (OdScanQuerySeverity severity : vulnerability.getSeverity()) {
            Integer cnt;
            if (severity.getSeverityId().equals("low")) {
                cnt = scanSummary.getLowSeverity() + severity.getAmount();
                scanSummary.setLowSeverity(cnt);
            }
            if (severity.getSeverityId().equals("medium")) {
                cnt = scanSummary.getMediumSeverity() + severity.getAmount();
                scanSummary.setMediumSeverity(cnt);
            }
            if (!severity.getSeverityId().equals("high")) continue;
            cnt = scanSummary.getHighSeverity() + severity.getAmount();
            scanSummary.setHighSeverity(cnt);
        }
    }

    private void getScanResults(ScanResults.XIssue.XIssueBuilder xib, Integer projectId, Integer scanId, Integer queryId) {
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN_RESULTS_ENCODED), HttpMethod.GET, httpEntity, OdScanResults.class, new Object[]{projectId, scanId, queryId});
        OdScanResults scanResults = (OdScanResults)response.getBody();
        for (OdScanResultItem item : scanResults.getData().getItems()) {
            xib.similarityId(item.getSimilarityId());
            xib.file(item.getSourceFile());
            this.getScanResultNodes(xib, projectId, scanId, item.getId());
        }
    }

    private void getScanResultNodes(ScanResults.XIssue.XIssueBuilder xib, Integer projectId, Integer scanId, Integer resultId) {
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN_RESULT_NODES_ENCODED), HttpMethod.GET, httpEntity, OdScanNodes.class, new Object[]{projectId, scanId, resultId});
        OdScanNodes scanNodes = (OdScanNodes)response.getBody();
        HashMap<Integer, ScanResults.IssueDetails> issueDetailsList = new HashMap<Integer, ScanResults.IssueDetails>();
        for (int i = 0; i < scanNodes.getData().getItems().size(); ++i) {
            OdScanNodeItem item = scanNodes.getData().getItems().get(i);
            String snippet = this.extractCodeSnippet(projectId, scanId, item.getLine(), item.getFile().getId());
            ScanResults.IssueDetails issueDetails = new ScanResults.IssueDetails().codeSnippet(snippet).comment("").falsePositive(false);
            issueDetailsList.put(i, issueDetails);
        }
        xib.details(issueDetailsList);
    }

    private String extractCodeSnippet(Integer projectId, Integer scanId, Integer lineNumber, String filePath) {
        String sourceCode;
        if (this.codeCache.containsKey(filePath)) {
            sourceCode = (String)this.codeCache.get(filePath);
        } else {
            HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)this.authClient.createAuthHeaders());
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(SCAN_FILE), HttpMethod.GET, httpEntity, OdScanFileResult.class, new Object[]{projectId, scanId, filePath});
            OdScanFileResult sfr = (OdScanFileResult)response.getBody();
            sourceCode = sfr.getData().getCode();
            this.codeCache.put(filePath, sourceCode);
        }
        String codeLine = "NOT FOUND!";
        try {
            StringReader code = new StringReader(sourceCode);
            BufferedReader codeReader = new BufferedReader(code);
            for (int curLine = 1; (codeLine = codeReader.readLine()) != null && curLine != lineNumber; ++curLine) {
            }
        }
        catch (IOException e) {
            log.error("Error parsing source file: {}.", (Object)filePath);
        }
        return codeLine.replace("\r", "").replace("\n", "");
    }

    @Override
    public Integer getProjectId(String ownerId, String name) {
        log.info("Retrieving OD Project List");
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(GET_PROJECTS), HttpMethod.GET, httpEntity, OdProjectList.class, new Object[]{ownerId});
        OdProjectList appList = (OdProjectList)response.getBody();
        for (OdProjectListDataItem item : appList.getData().getItems()) {
            if (!item.getName().equals(name)) continue;
            return item.getId();
        }
        return -1;
    }

    @Override
    public void waitForScanCompletion(Integer scanId) throws CheckmarxException {
        Integer projectId = scanIdMap.get(scanId.toString());
        Integer status = this.getScanStatus(projectId, scanId);
        long timer = 0L;
        try {
            while (!(status.equals(SCAN_STATUS_FINISHED) || status.equals(SCAN_STATUS_CANCELED) || status.equals(SCAN_STATUS_FAILED))) {
                Thread.sleep(this.cxProperties.getScanPolling().intValue());
                status = this.getScanStatus(projectId, scanId);
                if ((timer += (long)this.cxProperties.getScanPolling().intValue()) < (long)(this.cxProperties.getScanTimeout() * 60000)) continue;
                log.error("Scan timeout exceeded.  {} minutes", (Object)this.cxProperties.getScanTimeout());
                throw new CheckmarxException("Timeout exceeded during scan");
            }
        }
        catch (InterruptedException e) {
            log.error("Thread sleep error waiting for scan status!");
        }
        if (status.equals(SCAN_STATUS_FAILED) || status.equals(SCAN_STATUS_CANCELED)) {
            throw new CheckmarxException("Scan was cancelled or failed");
        }
    }

    public Integer getScanStatus(Integer projectId, Integer scanId) {
        log.info("Retrieving OD Scan List");
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(GET_SCAN_STATUS), HttpMethod.GET, httpEntity, OdScanList.class, new Object[]{projectId});
        OdScanList appList = (OdScanList)response.getBody();
        for (OdScanListDataItem item : appList.getData().getItems()) {
            if (item.getId() != scanId || !item.getStatus().equals("Done")) continue;
            return SCAN_STATUS_FINISHED;
        }
        return -1;
    }

    @Override
    public String getTeamId(String parentTeamId, String teamName) throws CheckmarxException {
        return UNKNOWN;
    }

    @Override
    public Integer getScanStatus(Integer scanId) {
        return 0;
    }

    @Override
    public Integer getLastScanId(Integer projectId) {
        return null;
    }

    @Override
    public JSONObject getScanData(String scanId) {
        return null;
    }

    @Override
    public LocalDateTime getLastScanDate(Integer projectId) {
        return null;
    }

    @Override
    public Integer createScanReport(Integer scanId) {
        return null;
    }

    @Override
    public Integer getReportStatus(Integer reportId) throws CheckmarxException {
        return null;
    }

    @Override
    public ScanResults getReportContent(Integer reportId, List<Filter> filter) throws CheckmarxException {
        return null;
    }

    @Override
    public Map<String, String> getCustomFields(Integer projectId) {
        return null;
    }

    @Override
    public ScanResults getReportContent(File file, List<Filter> filter) throws CheckmarxException {
        return null;
    }

    @Override
    public ScanResults getOsaReportContent(File vulnsFile, File libsFile, List<Filter> filter) throws CheckmarxException {
        return null;
    }

    @Override
    public String getIssueDescription(Long scanId, Long pathId) {
        return null;
    }

    @Override
    public Integer createProject(String ownerId, String name) {
        return null;
    }

    @Override
    public void deleteProject(Integer projectId) {
    }

    @Override
    public List<CxProject> getProjects() throws CheckmarxException {
        return null;
    }

    @Override
    public List<CxProject> getProjects(String teamId) throws CheckmarxException {
        return null;
    }

    @Override
    public CxProject getProject(Integer projectId) {
        return null;
    }

    @Override
    public boolean scanExists(Integer projectId) {
        return false;
    }

    @Override
    public Integer createScanSetting(Integer projectId, Integer presetId, Integer engineConfigId) {
        return null;
    }

    @Override
    public String getScanSetting(Integer projectId) {
        return null;
    }

    @Override
    public String getPresetName(Integer presetId) {
        return null;
    }

    @Override
    public Integer getProjectPresetId(Integer projectId) {
        return null;
    }

    @Override
    public void setProjectRepositoryDetails(Integer projectId, String gitUrl, String branch) throws CheckmarxException {
    }

    @Override
    public void updateProjectDetails(CxProject project) throws CheckmarxException {
    }

    @Override
    public void uploadProjectSource(Integer projectId, File file) throws CheckmarxException {
    }

    @Override
    public void setProjectExcludeDetails(Integer projectId, List<String> excludeFolders, List<String> excludeFiles) {
    }

    @Override
    public Integer getLdapTeamMapId(Integer ldapServerId, String teamId, String ldapGroupDn) throws CheckmarxException {
        return null;
    }

    @Override
    public List<CxTeam> getTeams() throws CheckmarxException {
        return null;
    }

    @Override
    public void mapTeamLdap(Integer ldapServerId, String teamId, String teamName, String ldapGroupDn) throws CheckmarxException {
    }

    @Override
    public List<CxTeamLdap> getTeamLdap(Integer ldapServerId) throws CheckmarxException {
        return null;
    }

    @Override
    public void removeTeamLdap(Integer ldapServerId, String teamId, String teamName, String ldapGroupDn) throws CheckmarxException {
    }

    @Override
    public List<CxRole> getRoles() throws CheckmarxException {
        return null;
    }

    @Override
    public Integer getRoleId(String roleName) throws CheckmarxException {
        return null;
    }

    @Override
    public List<CxRoleLdap> getRoleLdap(Integer ldapServerId) throws CheckmarxException {
        return null;
    }

    @Override
    public Integer getLdapRoleMapId(Integer ldapServerId, Integer roleId, String ldapGroupDn) throws CheckmarxException {
        return null;
    }

    @Override
    public void mapRoleLdap(Integer ldapServerId, Integer roleId, String ldapGroupDn) throws CheckmarxException {
    }

    @Override
    public void removeRoleLdap(Integer roleMapId) throws CheckmarxException {
    }

    @Override
    public void removeRoleLdap(Integer ldapServerId, Integer roleId, String ldapGroupDn) throws CheckmarxException {
    }

    @Override
    public void mapTeamLdapWS(Integer ldapServerId, String teamId, String teamName, String ldapGroupDn) throws CheckmarxException {
    }

    @Override
    public void removeTeamLdapWS(Integer ldapServerId, String teamId, String teamName, String ldapGroupDn) throws CheckmarxException {
    }

    @Override
    public String createTeamWS(String parentTeamId, String teamName) throws CheckmarxException {
        return null;
    }

    @Override
    public void moveTeam(String teamId, String newParentTeamId) throws CheckmarxException {
    }

    @Override
    public void renameTeam(String teamId, String newTeamName) throws CheckmarxException {
    }

    @Override
    public void deleteTeam(String teamId) throws CheckmarxException {
    }

    @Override
    public void deleteTeamWS(String teamId) throws CheckmarxException {
    }

    @Override
    public Integer getScanConfiguration(String configuration) throws CheckmarxException {
        return null;
    }

    @Override
    public Integer getPresetId(String preset) throws CheckmarxException {
        return null;
    }

    @Override
    public CxScanSummary getScanSummaryByScanId(Integer scanId) throws CheckmarxException {
        return null;
    }

    @Override
    public CxScanSummary getScanSummary(Integer projectId) throws CheckmarxException {
        return null;
    }

    @Override
    public CxScanSummary getScanSummary(String teamName, String projectName) throws CheckmarxException {
        return null;
    }

    @Override
    public void deleteScan(Integer scanId) throws CheckmarxException {
    }

    @Override
    public ScanResults getLatestScanResults(String teamName, String projectName, List<Filter> filters) throws CheckmarxException {
        return null;
    }

    @Override
    public Integer getLdapServerId(String serverName) throws CheckmarxException {
        return null;
    }
}

