/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.dto.filtering;

import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.filtering.ScriptedFilter;
import java.util.List;

public class FilterConfiguration {
    private List<Filter> simpleFilters;
    private ScriptedFilter scriptedFilter;

    public static FilterConfiguration fromSimpleFilters(List<Filter> simpleFilters) {
        return FilterConfiguration.builder().simpleFilters(simpleFilters).build();
    }

    FilterConfiguration(List<Filter> simpleFilters, ScriptedFilter scriptedFilter) {
        this.simpleFilters = simpleFilters;
        this.scriptedFilter = scriptedFilter;
    }

    public static FilterConfigurationBuilder builder() {
        return new FilterConfigurationBuilder();
    }

    public List<Filter> getSimpleFilters() {
        return this.simpleFilters;
    }

    public ScriptedFilter getScriptedFilter() {
        return this.scriptedFilter;
    }

    public void setSimpleFilters(List<Filter> simpleFilters) {
        this.simpleFilters = simpleFilters;
    }

    public void setScriptedFilter(ScriptedFilter scriptedFilter) {
        this.scriptedFilter = scriptedFilter;
    }

    public String toString() {
        return "FilterConfiguration(simpleFilters=" + this.getSimpleFilters() + ", scriptedFilter=" + this.getScriptedFilter() + ")";
    }

    public static class FilterConfigurationBuilder {
        private List<Filter> simpleFilters;
        private ScriptedFilter scriptedFilter;

        FilterConfigurationBuilder() {
        }

        public FilterConfigurationBuilder simpleFilters(List<Filter> simpleFilters) {
            this.simpleFilters = simpleFilters;
            return this;
        }

        public FilterConfigurationBuilder scriptedFilter(ScriptedFilter scriptedFilter) {
            this.scriptedFilter = scriptedFilter;
            return this;
        }

        public FilterConfiguration build() {
            return new FilterConfiguration(this.simpleFilters, this.scriptedFilter);
        }

        public String toString() {
            return "FilterConfiguration.FilterConfigurationBuilder(simpleFilters=" + this.simpleFilters + ", scriptedFilter=" + this.scriptedFilter + ")";
        }
    }
}

