/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.dto.filtering;

public class ScriptInput {
    private final String category;
    private final String cwe;
    private final String severity;
    private final String status;
    private final String state;

    ScriptInput(String category, String cwe, String severity, String status, String state) {
        this.category = category;
        this.cwe = cwe;
        this.severity = severity;
        this.status = status;
        this.state = state;
    }

    public static ScriptInputBuilder builder() {
        return new ScriptInputBuilder();
    }

    public String getCategory() {
        return this.category;
    }

    public String getCwe() {
        return this.cwe;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getStatus() {
        return this.status;
    }

    public String getState() {
        return this.state;
    }

    public static class ScriptInputBuilder {
        private String category;
        private String cwe;
        private String severity;
        private String status;
        private String state;

        ScriptInputBuilder() {
        }

        public ScriptInputBuilder category(String category) {
            this.category = category;
            return this;
        }

        public ScriptInputBuilder cwe(String cwe) {
            this.cwe = cwe;
            return this;
        }

        public ScriptInputBuilder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public ScriptInputBuilder status(String status) {
            this.status = status;
            return this;
        }

        public ScriptInputBuilder state(String state) {
            this.state = state;
            return this;
        }

        public ScriptInput build() {
            return new ScriptInput(this.category, this.cwe, this.severity, this.status, this.state);
        }

        public String toString() {
            return "ScriptInput.ScriptInputBuilder(category=" + this.category + ", cwe=" + this.cwe + ", severity=" + this.severity + ", status=" + this.status + ", state=" + this.state + ")";
        }
    }
}

