/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.dto.cx.CxAuthResponse;
import com.checkmarx.sdk.exception.InvalidCredentialsException;
import com.checkmarx.sdk.service.CxAuthClient;
import java.time.LocalDateTime;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CxAuthService
implements CxAuthClient {
    private static final Logger log = LoggerFactory.getLogger(CxAuthService.class);
    private final CxProperties cxProperties;
    private final RestTemplate restTemplate;
    private CxAuthResponse token = null;
    private LocalDateTime tokenExpires = null;
    private static final String GET_SESSION_TOKEN = "/tokens/tokens/auth";

    public CxAuthService(CxProperties cxProperties, @Qualifier(value="cxRestTemplate") RestTemplate restTemplate) {
        this.cxProperties = cxProperties;
        this.restTemplate = restTemplate;
    }

    private void getAuthToken() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setCacheControl(CacheControl.noCache());
        HttpEntity req = new HttpEntity((Object)this.getJSONTokenReq(), (MultiValueMap)headers);
        this.token = (CxAuthResponse)this.restTemplate.postForObject(this.cxProperties.getUrl().concat(GET_SESSION_TOKEN), (Object)req, CxAuthResponse.class, new Object[0]);
        this.tokenExpires = LocalDateTime.now().plusSeconds(this.token.getExpiresIn() - 500L);
    }

    @Override
    public HttpHeaders createAuthHeaders() {
        if (this.token == null || this.isTokenExpired()) {
            this.getAuthToken();
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.setCacheControl(CacheControl.noCache());
        httpHeaders.set("Authorization", "Bearer ".concat(this.token.getIdToken()));
        return httpHeaders;
    }

    private boolean isTokenExpired() {
        if (this.tokenExpires == null) {
            return true;
        }
        return LocalDateTime.now().isAfter(this.tokenExpires);
    }

    @Override
    public String getCurrentToken() {
        return this.token.getAccessToken();
    }

    private String getJSONTokenReq() {
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("token", (Object)this.cxProperties.getClientSecret());
        }
        catch (JSONException e) {
            log.error("Error creating JSON Token Request object - JSON object will be empty");
        }
        return requestBody.toString();
    }

    @Override
    public String getAuthToken(String username, String password, String clientId, String clientSecret, String scope) throws InvalidCredentialsException {
        return null;
    }

    @Override
    public String getSoapAuthToken(String username, String password) throws InvalidCredentialsException {
        return null;
    }

    @Override
    public String legacyLogin(String username, String password) throws InvalidCredentialsException {
        return null;
    }

    @Override
    public String getCurrentSoapToken() {
        return null;
    }

    @Override
    public String getLegacySession() {
        return null;
    }
}

