/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.dto.cx.CxScanParams;
import com.checkmarx.sdk.exception.CheckmarxException;
import com.checkmarx.sdk.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CxRepoFileService {
    private static final Logger log = LoggerFactory.getLogger(CxRepoFileService.class);
    private final CxProperties cxProperties;

    public CxRepoFileService(CxProperties cxProperties) {
        this.cxProperties = cxProperties;
    }

    public String prepareRepoFile(CxScanParams params) throws CheckmarxException {
        String gitURL = params.getGitUrl();
        String branch = params.getBranch();
        File pathFile = null;
        String srcPath = this.cxProperties.getGitClonePath().concat("/").concat(UUID.randomUUID().toString());
        pathFile = new File(srcPath);
        try {
            URI uri = new URI(gitURL);
            UsernamePasswordCredentialsProvider credentialsProvider = null;
            String token = uri.getUserInfo();
            if (token.startsWith("oauth2:")) {
                log.debug("Using gitlab clone");
                token = token.replace("oauth2:", "");
                gitURL = gitURL.replace(uri.getUserInfo(), "gitlab-ci-token:".concat(token));
                credentialsProvider = new UsernamePasswordCredentialsProvider("user", token);
            } else if (token.contains(":")) {
                String[] userDetails = token.split(":");
                if (userDetails.length == 2) {
                    log.debug("Using clone with username/password");
                    credentialsProvider = new UsernamePasswordCredentialsProvider(userDetails[0], userDetails[1]);
                }
            } else {
                credentialsProvider = new UsernamePasswordCredentialsProvider(token, "");
            }
            log.info("Cloning code locally to {}", (Object)pathFile);
            ((CloneCommand)Git.cloneRepository().setURI(gitURL).setBranch(branch).setBranchesToClone(Collections.singleton(branch)).setDirectory(pathFile).setCredentialsProvider((CredentialsProvider)credentialsProvider)).call().close();
            String cxZipFile = this.cxProperties.getGitClonePath().concat("/").concat("cx.".concat(UUID.randomUUID().toString()).concat(".zip"));
            String exclusions = null;
            if (params.getFileExclude() != null && !params.getFileExclude().isEmpty()) {
                exclusions = String.join((CharSequence)",", params.getFileExclude());
            }
            ZipUtils.zipFile(srcPath, cxZipFile, exclusions);
            try {
                FileUtils.deleteDirectory((File)pathFile);
            }
            catch (IOException e) {
                log.warn("Error deleting file {} - {}", (Object)pathFile, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            return cxZipFile;
        }
        catch (IOException | URISyntaxException | GitAPIException e) {
            log.error(ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new CheckmarxException("Unable to clone Git Url.");
        }
    }
}

