/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.art.classifiers;

import com.github.chen0040.art.core.ARTMAP;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.utils.transforms.ComplementaryCoding;

public class ARTMAPClassifier
implements Cloneable {
    private ARTMAP net;
    private double alpha = 0.1;
    private double rho0 = 0.1;
    private double beta = 0.3;
    private ComplementaryCoding inputNormalization;
    private boolean allowNewNodeInPrediction = false;

    public void copy(ARTMAPClassifier that) throws CloneNotSupportedException {
        this.net = that.net == null ? null : (ARTMAP)that.net.clone();
        this.allowNewNodeInPrediction = that.allowNewNodeInPrediction;
        this.inputNormalization = that.inputNormalization == null ? null : (ComplementaryCoding)that.inputNormalization.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        ARTMAPClassifier clone = (ARTMAPClassifier)super.clone();
        clone.copy(this);
        return clone;
    }

    public String transform(DataRow tuple) {
        return this.simulate(tuple, false);
    }

    public void fit(DataFrame batch) {
        this.inputNormalization = new ComplementaryCoding(batch);
        int dimension = batch.row(0).toArray().length * 2;
        this.net = new ARTMAP(dimension);
        this.net.setAlpha(this.alpha);
        this.net.setBeta(this.beta);
        this.net.setRho(this.rho0);
        int m = batch.rowCount();
        for (int i = 0; i < m; ++i) {
            DataRow tuple = batch.row(i);
            this.simulate(tuple, true);
        }
    }

    public String simulate(DataRow tuple, boolean can_create_node) {
        double[] x = tuple.toArray();
        x = this.inputNormalization.normalize(x);
        return this.net.simulate(x, tuple.categoricalTarget(), can_create_node);
    }

    public int nodeCount() {
        return this.net.getNodeCount();
    }

    public ARTMAP getNet() {
        return this.net;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getRho0() {
        return this.rho0;
    }

    public double getBeta() {
        return this.beta;
    }

    public ComplementaryCoding getInputNormalization() {
        return this.inputNormalization;
    }

    public boolean isAllowNewNodeInPrediction() {
        return this.allowNewNodeInPrediction;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setRho0(double rho0) {
        this.rho0 = rho0;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public void setInputNormalization(ComplementaryCoding inputNormalization) {
        this.inputNormalization = inputNormalization;
    }
}

