/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.art.clustering;

import com.github.chen0040.art.core.FuzzyART;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.utils.transforms.ComplementaryCoding;

public class FuzzyARTClustering
implements Cloneable {
    private FuzzyART net;
    private int initialNodeCount = 1;
    private boolean allowNewNodeInPrediction = false;
    private ComplementaryCoding inputNormalization;
    private double alpha = 0.1;
    private double beta = 0.2;
    private double rho = 0.7;

    public void copy(FuzzyARTClustering that) throws CloneNotSupportedException {
        this.net = that.net == null ? null : (FuzzyART)that.net.clone();
        this.initialNodeCount = that.initialNodeCount;
        this.allowNewNodeInPrediction = that.allowNewNodeInPrediction;
        this.inputNormalization = that.inputNormalization == null ? null : (ComplementaryCoding)that.inputNormalization.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        FuzzyARTClustering clone = (FuzzyARTClustering)super.clone();
        clone.copy(this);
        return clone;
    }

    public int transform(DataRow tuple) {
        return this.simulate(tuple, this.allowNewNodeInPrediction);
    }

    public void transform(DataFrame dataFrame) {
        for (int i = 0; i < dataFrame.rowCount(); ++i) {
            int clusterId = this.transform(dataFrame.row(i));
            dataFrame.row(i).setCategoricalTargetCell("cluster", "" + clusterId);
        }
    }

    public DataFrame fitAndTransform(DataFrame dataFrame) {
        this.fit(dataFrame);
        dataFrame = dataFrame.makeCopy();
        this.transform(dataFrame);
        return dataFrame;
    }

    public void fit(DataFrame batch) {
        this.inputNormalization = new ComplementaryCoding(batch);
        int dimension = batch.row(0).toArray().length * 2;
        this.net = new FuzzyART(dimension, this.initialNodeCount);
        this.net.setAlpha(this.alpha);
        this.net.setBeta(this.beta);
        this.net.setRho(this.rho);
        int m = batch.rowCount();
        for (int i = 0; i < m; ++i) {
            DataRow tuple = batch.row(i);
            this.simulate(tuple, true);
        }
    }

    public int simulate(DataRow tuple, boolean can_create_node) {
        double[] x = tuple.toArray();
        x = this.inputNormalization.normalize(x);
        return this.net.simulate(x, can_create_node);
    }

    public FuzzyART getNet() {
        return this.net;
    }

    public ComplementaryCoding getInputNormalization() {
        return this.inputNormalization;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getRho() {
        return this.rho;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }
}

