/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.art.core;

import java.util.ArrayList;
import java.util.List;

public class ART1
implements Cloneable {
    protected double alpha;
    protected double rho;
    protected double beta;
    protected List<double[]> weights;
    protected List<Double> activation_values;
    protected int inputCount;

    public ART1() {
        this.weights = new ArrayList<double[]>();
        this.activation_values = new ArrayList<Double>();
    }

    public ART1(int inputCount, int initialNeuronCount) {
        this.inputCount = inputCount;
        this.weights = new ArrayList<double[]>();
        this.activation_values = new ArrayList<Double>();
        for (int i = 0; i < initialNeuronCount; ++i) {
            this.addNode();
        }
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getRho() {
        return this.rho;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public List<double[]> getWeights() {
        return this.weights;
    }

    public void setWeights(List<double[]> weights) {
        this.weights = weights;
    }

    public List<Double> getActivation_values() {
        return this.activation_values;
    }

    public void setActivation_values(List<Double> activation_values) {
        this.activation_values = activation_values;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public void setInputCount(int inputCount) {
        this.inputCount = inputCount;
    }

    public void copy(ART1 rhs) {
        int i;
        this.alpha = rhs.alpha;
        this.rho = rhs.rho;
        this.beta = rhs.beta;
        this.weights.clear();
        this.activation_values.clear();
        this.inputCount = rhs.inputCount;
        for (i = 0; i < rhs.weights.size(); ++i) {
            this.weights.add((double[])rhs.weights.get(i).clone());
        }
        for (i = 0; i < rhs.activation_values.size(); ++i) {
            this.activation_values.add(rhs.activation_values.get(i));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ART1 clone = (ART1)super.clone();
        clone.copy(this);
        return clone;
    }

    public void addNode() {
        double[] neuron = new double[this.inputCount];
        for (int i = 0; i < this.inputCount; ++i) {
            neuron[i] = 1.0;
        }
        this.weights.add(neuron);
        this.activation_values.add(0.0);
    }

    public void addNode(double[] x) {
        double[] neuron = new double[this.inputCount];
        for (int i = 0; i < this.inputCount; ++i) {
            neuron[i] = x[i];
        }
        this.weights.add(neuron);
        this.activation_values.add(0.0);
    }

    protected double choice_function(double[] x, int j) {
        double[] W_j = this.weights.get(j);
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.abs(x[i] * W_j[i]);
            sum2 += Math.abs(W_j[i]);
        }
        return sum / (this.alpha + sum2);
    }

    protected int template_with_max_activation_value() {
        int C = this.getNodeCount();
        double max_activation_value = 0.0;
        int template_selected = -1;
        for (int i = 0; i < C; ++i) {
            double activation_value = this.activation_values.get(i);
            if (!(activation_value > max_activation_value)) continue;
            max_activation_value = activation_value;
            template_selected = i;
        }
        return template_selected;
    }

    public int getNodeCount() {
        return this.weights.size();
    }

    protected double match_function(double[] x, int j) {
        double[] W_j = this.weights.get(j);
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.abs(x[i] * W_j[i]);
            sum2 += Math.abs(x[i]);
        }
        return sum / sum2;
    }

    protected void update_node(double[] x, int j) {
        double[] W_j = this.weights.get(j);
        for (int i = 0; i < x.length; ++i) {
            W_j[i] = (1.0 - this.beta) * W_j[i] + this.beta * W_j[i] * x[i];
        }
    }

    public int train(double[] x) {
        return this.simulate(x, true);
    }

    public int simulate(double[] x, boolean can_create_new_node) {
        boolean new_node = can_create_new_node;
        int C = this.getNodeCount();
        int winner = -1;
        if (can_create_new_node) {
            int J;
            int i;
            for (i = 0; i < C; ++i) {
                double activation_value = this.choice_function(x, i);
                this.activation_values.set(i, activation_value);
            }
            for (i = 0; i < C && (J = this.template_with_max_activation_value()) != -1; ++i) {
                double match_value = this.match_function(x, J);
                if (match_value > this.rho) {
                    this.update_node(x, J);
                    winner = J;
                    new_node = false;
                    break;
                }
                this.activation_values.set(J, 0.0);
            }
            if (new_node) {
                this.addNode(x);
                winner = this.getNodeCount() - 1;
            }
        } else {
            double max_match_value = 0.0;
            int J = -1;
            for (int j = 0; j < C; ++j) {
                double match_value = this.match_function(x, j);
                if (!(max_match_value < match_value)) continue;
                max_match_value = match_value;
                J = j;
            }
            winner = J;
        }
        return winner;
    }
}

