/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.art.core;

import com.github.chen0040.art.core.ART1;
import com.github.chen0040.art.core.FuzzyART;
import java.util.ArrayList;
import java.util.List;

public class ARTMAP
extends FuzzyART {
    private List<String> labels = new ArrayList<String>();
    private double epsilon = 1.0E-5;

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public ARTMAP(int inputCount) {
        super(inputCount, 0);
    }

    public ARTMAP() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ARTMAP clone = (ARTMAP)super.clone();
        clone.copy(this);
        return clone;
    }

    @Override
    public void copy(ART1 rhs) {
        super.copy(rhs);
        ARTMAP rhs2 = (ARTMAP)rhs;
        this.labels.clear();
        this.labels.addAll(rhs2.labels);
    }

    public String simulate(double[] x, String label, boolean can_create_new_node) {
        boolean new_node = can_create_new_node;
        int C = this.getNodeCount();
        String winner = label;
        if (label != null && !this.labels.contains(label)) {
            this.addNode(x);
            this.labels.add(label);
        } else {
            if (label == null) {
                can_create_new_node = false;
            }
            if (can_create_new_node) {
                int J;
                int j;
                for (j = 0; j < C; ++j) {
                    double activation_value = this.choice_function(x, j);
                    this.activation_values.set(j, activation_value);
                }
                for (j = 0; j < C && (J = this.template_with_max_activation_value()) != -1; ++j) {
                    double match_value;
                    String labelJ = this.labels.get(J);
                    if (!labelJ.equals(label)) {
                        this.rho = this.match_function(x, J) + this.epsilon;
                    }
                    if ((match_value = this.match_function(x, J)) > this.rho) {
                        this.update_node(x, J);
                        new_node = false;
                        break;
                    }
                    this.activation_values.set(J, 0.0);
                }
                if (new_node) {
                    this.addNode(x);
                    this.labels.add(label);
                }
            } else {
                double max_match_value = 0.0;
                int J = -1;
                for (int j = 0; j < C; ++j) {
                    double match_value = this.match_function(x, j);
                    if (!(max_match_value < match_value)) continue;
                    max_match_value = match_value;
                    J = j;
                }
                winner = this.labels.get(J);
            }
        }
        return winner;
    }
}

