/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.evaluators;

import java.util.ArrayList;
import java.util.List;

public class RegressionEvaluator {
    private List<Double> expectedOutputValues = new ArrayList<Double>();
    private List<Double> actualOutputValues = new ArrayList<Double>();
    private double meanSquaredError = 0.0;
    private double rootMeanSquaredError = 0.0;
    private double meanAbsoluteError = 0.0;
    private double RSquare = 0.0;

    public void reset() {
        this.expectedOutputValues.clear();
        this.actualOutputValues.clear();
    }

    public void evaluate(double expected, double actual) {
        this.expectedOutputValues.add(expected);
        this.actualOutputValues.add(actual);
    }

    public void update() {
        int size = this.expectedOutputValues.size();
        if (size == 0) {
            return;
        }
        double mu_expected = 0.0;
        for (int i = 0; i < size; ++i) {
            double expected = this.expectedOutputValues.get(i);
            mu_expected += expected;
        }
        mu_expected /= (double)size;
        double squaredSum = 0.0;
        double absoluteSum = 0.0;
        double SS_total = 0.0;
        double SS_res = 0.0;
        for (int i = 0; i < size; ++i) {
            double expected = this.expectedOutputValues.get(i);
            double actual = this.actualOutputValues.get(i);
            double difference = expected - actual;
            squaredSum += difference * difference;
            absoluteSum += Math.abs(difference);
            SS_total += Math.pow(expected - mu_expected, 2.0);
            SS_res += difference * difference;
        }
        this.meanSquaredError = squaredSum / (double)size;
        this.meanAbsoluteError = absoluteSum / (double)size;
        this.rootMeanSquaredError = Math.sqrt(this.meanSquaredError);
        this.RSquare = 1.0 - SS_res / SS_total;
    }

    public double getMeanSquaredError() {
        return this.meanSquaredError;
    }

    public double getRootMeanSquaredError() {
        return this.rootMeanSquaredError;
    }

    public double getMeanAbsoluteError() {
        return this.meanAbsoluteError;
    }

    public double getRSquare() {
        return this.RSquare;
    }
}

