/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.frame;

import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.utils.CollectionUtils;
import com.github.chen0040.data.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BasicDataRow
implements DataRow,
Serializable {
    private static final long serialVersionUID = -1932292620125077757L;
    private final Map<String, Double> targets = new HashMap<String, Double>();
    private final Map<String, String> categoricalTargets = new HashMap<String, String>();
    private final Map<String, Double> values = new HashMap<String, Double>();
    private final Map<String, String> categoricalValues = new HashMap<String, String>();
    private final List<String> columns = new ArrayList<String>();
    private final List<String> categoricalColumns = new ArrayList<String>();
    private final List<String> targetColumns = new ArrayList<String>();
    private final List<String> categoricalTargetColumns = new ArrayList<String>();
    private final Map<String, List<String>> levels = new HashMap<String, List<String>>();

    @Override
    public double target() {
        return this.getTargetCell(this.targetColumnName());
    }

    @Override
    public String categoricalTarget() {
        return this.getCategoricalTargetCell(this.categoricalTargetColumnName());
    }

    @Override
    public double getTargetCell(String columnName) {
        return this.targets.getOrDefault(columnName, 0.0);
    }

    @Override
    public String getCategoricalTargetCell(String columnName) {
        return this.categoricalTargets.getOrDefault(columnName, "");
    }

    @Override
    public void setTargetCell(String columnName, double value) {
        if (value == 0.0) {
            this.targets.remove(columnName);
        }
        this.targets.put(columnName, value);
    }

    @Override
    public void setCategoricalTargetCell(String columnName, String value) {
        if (StringUtils.isEmpty(value)) {
            this.categoricalTargets.remove(columnName);
        }
        this.categoricalTargets.put(columnName, value);
    }

    @Override
    public void setColumnNames(List<String> inputColumns) {
        this.columns.clear();
        this.columns.addAll(inputColumns);
    }

    @Override
    public void setCategoricalColumnNames(List<String> inputColumns) {
        this.categoricalColumns.clear();
        this.categoricalColumns.addAll(inputColumns);
    }

    @Override
    public void setLevels(Map<String, List<String>> levels) {
        this.levels.clear();
        this.levels.putAll(levels);
    }

    @Override
    public void setTargetColumnNames(List<String> outputColumns) {
        this.targetColumns.clear();
        this.targetColumns.addAll(outputColumns);
    }

    @Override
    public void setCategoricalTargetColumnNames(List<String> outputColumns) {
        this.categoricalTargetColumns.clear();
        this.categoricalTargetColumns.addAll(outputColumns);
    }

    @Override
    public DataRow makeCopy() {
        BasicDataRow clone = new BasicDataRow();
        clone.copy(this);
        return clone;
    }

    @Override
    public void copy(DataRow that) {
        this.targets.clear();
        this.categoricalTargets.clear();
        this.values.clear();
        this.categoricalValues.clear();
        this.columns.clear();
        this.categoricalColumns.clear();
        this.targetColumns.clear();
        this.categoricalTargetColumns.clear();
        for (String string : that.getTargetColumnNames()) {
            this.targets.put(string, that.getTargetCell(string));
        }
        for (String string : that.getColumnNames()) {
            this.values.put(string, that.getCell(string));
        }
        for (String string : that.getCategoricalColumnNames()) {
            this.categoricalValues.put(string, that.getCategoricalCell(string));
        }
        for (String string : that.getCategoricalTargetColumnNames()) {
            this.categoricalTargets.put(string, that.getCategoricalTargetCell(string));
        }
        this.setColumnNames(that.getColumnNames());
        this.setCategoricalColumnNames(that.getCategoricalColumnNames());
        this.setTargetColumnNames(that.getTargetColumnNames());
        this.setCategoricalTargetColumnNames(that.getCategoricalTargetColumnNames());
        this.levels.clear();
        for (Map.Entry entry : that.getLevels().entrySet()) {
            this.levels.put((String)entry.getKey(), CollectionUtils.clone((List)entry.getValue(), x -> x));
        }
    }

    @Override
    public String targetColumnName() {
        return this.getTargetColumnNames().get(0);
    }

    @Override
    public String categoricalTargetColumnName() {
        return this.getCategoricalTargetColumnNames().get(0);
    }

    @Override
    public double[] toArray() {
        int i;
        List<String> cols = this.getColumnNames();
        ArrayList<Double> result = new ArrayList<Double>();
        for (i = 0; i < cols.size(); ++i) {
            result.add(this.getCell(cols.get(i)));
        }
        cols = this.getCategoricalColumnNames();
        for (i = 0; i < cols.size(); ++i) {
            String name = cols.get(i);
            String val = this.getCategoricalCell(name);
            List<String> levelsInFactor = this.levels.get(name);
            int index = levelsInFactor.indexOf(val);
            int count = levelsInFactor.size();
            if (count == 2) {
                count = 1;
            }
            for (int j = 0; j < count; ++j) {
                result.add(j == index ? 1.0 : 0.0);
            }
        }
        return CollectionUtils.toDoubleArray(result);
    }

    private void buildColumns() {
        List cols = this.values.keySet().stream().collect(Collectors.toList());
        cols.sort(String::compareTo);
        this.columns.addAll(cols);
    }

    private void buildCategoricalColumns() {
        List cols = this.categoricalValues.keySet().stream().collect(Collectors.toList());
        cols.sort(String::compareTo);
        this.categoricalColumns.addAll(cols);
    }

    private void buildTargetColumns() {
        List cols = this.targets.keySet().stream().collect(Collectors.toList());
        cols.sort(String::compareTo);
        this.targetColumns.addAll(cols);
    }

    private void buildCategoricalTargetColumns() {
        List cols = this.categoricalTargets.keySet().stream().collect(Collectors.toList());
        cols.sort(String::compareTo);
        this.categoricalTargetColumns.addAll(cols);
    }

    @Override
    public void setCell(String columnName, double value) {
        if (value == 0.0) {
            this.values.remove(columnName);
        }
        this.values.put(columnName, value);
    }

    @Override
    public void setCategoricalCell(String columnName, String value) {
        if (StringUtils.isEmpty(value)) {
            this.categoricalValues.remove(columnName);
        }
        this.categoricalValues.put(columnName, value);
    }

    @Override
    public List<String> getColumnNames() {
        if (this.columns.size() < this.values.size()) {
            this.buildColumns();
        }
        return this.columns;
    }

    @Override
    public List<String> getCategoricalColumnNames() {
        if (this.categoricalColumns.size() < this.categoricalValues.size()) {
            this.buildCategoricalColumns();
        }
        return this.categoricalColumns;
    }

    @Override
    public List<String> getTargetColumnNames() {
        if (this.targetColumns.size() < this.targets.size()) {
            this.buildTargetColumns();
        }
        return this.targetColumns;
    }

    @Override
    public List<String> getCategoricalTargetColumnNames() {
        if (this.categoricalTargetColumns.size() < this.categoricalTargets.size()) {
            this.buildCategoricalTargetColumns();
        }
        return this.categoricalTargetColumns;
    }

    @Override
    public double getCell(String key) {
        return this.values.getOrDefault(key, 0.0);
    }

    @Override
    public String getCategoricalCell(String key) {
        return this.categoricalValues.getOrDefault(key, "");
    }

    @Override
    public Map<String, List<String>> getLevels() {
        return this.levels;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        List<String> keys = this.getColumnNames();
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append(keys.get(i2)).append(":").append(this.getCell(keys.get(i2)));
        }
        List<String> keys2 = this.getCategoricalColumnNames();
        if (!keys2.isEmpty() && !keys.isEmpty()) {
            sb.append(", ");
        }
        for (i = 0; i < keys2.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(keys2.get(i)).append(":").append(this.getCategoricalCell(keys2.get(i)));
        }
        sb.append(" =>");
        keys = this.getTargetColumnNames();
        if (!keys.isEmpty()) {
            sb.append(" (");
            for (i = 0; i < keys.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(keys.get(i)).append(":").append(this.getTargetCell(keys.get(i)));
            }
            sb.append(")");
        }
        if (!(keys = this.getCategoricalTargetColumnNames()).isEmpty()) {
            sb.append(" (");
            for (i = 0; i < keys.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(keys.get(i)).append(":").append(this.getCategoricalTargetCell(keys.get(i)));
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

