/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CountRepository {
    private Map<String, CountRepository> chain = new HashMap<String, CountRepository>();
    private String eventName;
    private double storedValue;

    public void copy(CountRepository rhs) {
        this.storedValue = rhs.storedValue;
        this.eventName = rhs.eventName;
        this.chain.clear();
        for (String key : rhs.chain.keySet()) {
            this.chain.put(key, rhs.chain.get(key).makeCopy());
        }
    }

    public CountRepository makeCopy() {
        CountRepository clone = new CountRepository();
        clone.copy(this);
        return clone;
    }

    public CountRepository() {
        this.storedValue = 0.0;
    }

    public CountRepository(String evt) {
        this.eventName = evt;
    }

    public String getEventName() {
        return this.eventName;
    }

    public double getStoredValue() {
        return this.storedValue;
    }

    public Map<String, CountRepository> getChain() {
        return this.chain;
    }

    public List<String> getSubEventNames(String ... eventNames) {
        return this.getSubEventNames(this, eventNames);
    }

    private List<String> getSubEventNames(CountRepository repo, String ... eventNames) {
        int eventNameCount = eventNames.length;
        if (eventNameCount == 0) {
            ArrayList<String> events = new ArrayList<String>();
            for (String eventName : repo.chain.keySet()) {
                events.add(eventName);
            }
            return events;
        }
        if (repo.chain.containsKey(eventNames[0])) {
            repo = repo.chain.get(eventNames[0]);
            if (eventNameCount == 1) {
                return this.getSubEventNames(repo, new String[0]);
            }
            String[] subevents = new String[eventNameCount - 1];
            for (int j = 1; j < eventNameCount; ++j) {
                subevents[j - 1] = eventNames[j];
            }
            return this.getSubEventNames(repo, subevents);
        }
        return new ArrayList<String>();
    }

    public void addSupportCount(String ... events) {
        this.addSupportCount(1.0, events);
    }

    public void addSupportCount(double increment, String ... events) {
        int eventCount = events.length;
        if (eventCount == 0) {
            this.storedValue += increment;
        } else {
            CountRepository c;
            String evt = events[0];
            if (this.chain.containsKey(evt)) {
                c = this.chain.get(evt);
            } else {
                c = new CountRepository(evt);
                this.chain.put(evt, c);
            }
            if (eventCount == 1) {
                c.addSupportCount(increment, new String[0]);
            } else {
                String[] subevents = new String[eventCount - 1];
                for (int j = 1; j < eventCount; ++j) {
                    subevents[j - 1] = events[j];
                }
                c.addSupportCount(increment, subevents);
            }
        }
    }

    public void setValue(double value, String ... events) {
        int eventCount = events.length;
        if (eventCount == 0) {
            this.storedValue = value;
        } else {
            CountRepository c;
            String evt = events[0];
            if (this.chain.containsKey(evt)) {
                c = this.chain.get(evt);
            } else {
                c = new CountRepository(evt);
                this.chain.put(evt, c);
            }
            if (eventCount == 1) {
                c.setValue(value, new String[0]);
            } else {
                String[] subevents = new String[eventCount - 1];
                for (int j = 1; j < eventCount; ++j) {
                    subevents[j - 1] = events[j];
                }
                c.setValue(value, subevents);
            }
        }
    }

    public double getProbability(String eventName) {
        if (this.storedValue == 0.0) {
            return 0.0;
        }
        double count = this.getSupportCount(eventName);
        return count / this.storedValue;
    }

    public double getConditionalProbability(String eventA, String eventB) {
        double givenCount = this.getSupportCount(eventA);
        if (givenCount == 0.0) {
            return 0.0;
        }
        return this.getSupportCount(eventA, eventB) / givenCount;
    }

    public double getSupportCount(String ... events) {
        int eventCount = events.length;
        if (eventCount == 0) {
            return this.storedValue;
        }
        String evt = events[0];
        CountRepository c = null;
        if (this.chain.containsKey(evt)) {
            c = this.chain.get(evt);
        }
        if (c == null) {
            return 0.0;
        }
        if (eventCount == 1) {
            return c.getStoredValue();
        }
        String[] subevents = new String[eventCount - 1];
        for (int j = 1; j < eventCount; ++j) {
            subevents[j - 1] = events[j];
        }
        return c.getSupportCount(subevents);
    }

    public double getValue(String ... events) {
        int eventCount = events.length;
        if (eventCount == 0) {
            return this.storedValue;
        }
        String evt = events[0];
        CountRepository c = null;
        if (this.chain.containsKey(evt)) {
            c = this.chain.get(evt);
        }
        if (c == null) {
            return 0.0;
        }
        if (eventCount == 1) {
            return c.getValue(new String[0]);
        }
        String[] subevents = new String[eventCount - 1];
        for (int j = 1; j < eventCount; ++j) {
            subevents[j - 1] = events[j];
        }
        return c.getSupportCount(subevents);
    }
}

