/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.utils.discretizers;

import com.github.chen0040.data.frame.BasicDataFrame;
import com.github.chen0040.data.frame.BasicDataRow;
import com.github.chen0040.data.frame.DataColumn;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.utils.discretizers.AttributeValueDiscretizer;
import com.github.chen0040.data.utils.discretizers.KMeansFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KMeansDiscretizer
implements AttributeValueDiscretizer,
Serializable {
    private static final long serialVersionUID = 2193706516691610469L;
    private final Map<String, KMeansFilter> filters = new HashMap<String, KMeansFilter>();
    private int maxLevelCount = 10;
    private int maxIters = 500;

    public void copy(KMeansDiscretizer that) {
        this.maxLevelCount = that.maxLevelCount;
        this.filters.clear();
        for (String index : that.filters.keySet()) {
            this.filters.put(index, that.filters.get(index).makeCopy());
        }
    }

    public KMeansDiscretizer makeCopy() {
        KMeansDiscretizer clone = new KMeansDiscretizer();
        clone.copy(this);
        return clone;
    }

    @Override
    public int discretize(double value, String columnName) {
        if (this.filters.containsKey(columnName)) {
            return this.filters.get(columnName).discretize(value);
        }
        return (int)value;
    }

    @Override
    public DataRow transform(DataRow tuple) {
        int value;
        BasicDataRow newRow = new BasicDataRow();
        for (String columnName : tuple.getCategoricalColumnNames()) {
            newRow.setCategoricalCell(columnName, tuple.getCategoricalCell(columnName));
        }
        for (String columnName : tuple.getColumnNames()) {
            value = this.discretize(tuple.getCell(columnName), columnName);
            newRow.setCategoricalCell(columnName, "" + value);
        }
        for (String columnName : tuple.getCategoricalTargetColumnNames()) {
            newRow.setCategoricalTargetCell(columnName, tuple.getCategoricalTargetCell(columnName));
        }
        for (String columnName : tuple.getTargetColumnNames()) {
            value = this.discretize(tuple.getTargetCell(columnName), columnName);
            newRow.setCategoricalTargetCell(columnName, "" + value);
        }
        return newRow;
    }

    @Override
    public DataFrame fitAndTransform(DataFrame frame) {
        this.fit(frame);
        BasicDataFrame newFrame = new BasicDataFrame();
        for (int rowIndex = 0; rowIndex < frame.rowCount(); ++rowIndex) {
            newFrame.addRow(this.transform(frame.row(rowIndex)));
        }
        newFrame.lock();
        return newFrame;
    }

    /*
     * WARNING - void declaration
     */
    public void fit(DataFrame frame) {
        void var4_7;
        int m = frame.rowCount();
        this.filters.clear();
        for (DataColumn dataColumn : frame.getAllColumns()) {
            if (dataColumn.isCategorical()) continue;
            KMeansFilter f = new KMeansFilter(dataColumn.getColumnName(), this.maxLevelCount);
            f.setMaxIters(this.maxIters);
            this.filters.put(dataColumn.getColumnName(), f);
        }
        HashMap values = new HashMap();
        for (String columnName : this.filters.keySet()) {
            values.put(columnName, new ArrayList());
        }
        boolean bl = false;
        while (var4_7 < m) {
            DataRow tuple = frame.row((int)var4_7);
            for (DataColumn c : frame.getAllColumns()) {
                if (c.isCategorical()) continue;
                if (c.isOutputColumn()) {
                    ((List)values.get(c.getColumnName())).add(tuple.getTargetCell(c.getColumnName()));
                    continue;
                }
                ((List)values.get(c.getColumnName())).add(tuple.getCell(c.getColumnName()));
            }
            ++var4_7;
        }
        for (Map.Entry<String, KMeansFilter> filter : this.filters.entrySet()) {
            filter.getValue().build((List)values.get(filter.getKey()));
        }
    }

    public Map<String, KMeansFilter> getFilters() {
        return this.filters;
    }

    public int getMaxLevelCount() {
        return this.maxLevelCount;
    }

    public int getMaxIters() {
        return this.maxIters;
    }

    public void setMaxLevelCount(int maxLevelCount) {
        this.maxLevelCount = maxLevelCount;
    }

    public void setMaxIters(int maxIters) {
        this.maxIters = maxIters;
    }
}

