/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.trees.id3;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.utils.discretizers.KMeansDiscretizer;
import com.github.chen0040.trees.id3.ID3TreeNode;
import java.util.List;
import java.util.Random;

public class ID3 {
    private static Random rand = new Random();
    private KMeansDiscretizer discretizer = new KMeansDiscretizer();
    private ID3TreeNode tree;
    private int maxHeight = 1000;

    public void copy(ID3 rhs2) {
        this.tree = rhs2.tree == null ? null : (ID3TreeNode)rhs2.tree.clone();
        this.maxHeight = rhs2.maxHeight;
        this.discretizer = rhs2.discretizer == null ? null : rhs2.discretizer.makeCopy();
    }

    public Object clone() throws CloneNotSupportedException {
        ID3 clone = (ID3)super.clone();
        clone.copy(this);
        return clone;
    }

    public String classify(DataRow tuple) {
        tuple = this.discretizer.transform(tuple);
        return this.tree.predict(tuple);
    }

    protected boolean isValidTrainingSample(DataRow tuple) {
        return !tuple.getCategoricalTargetColumnNames().isEmpty();
    }

    public void fit(DataFrame batch) {
        batch = this.discretizer.fitAndTransform(batch);
        List columns = batch.row(0).getCategoricalColumnNames();
        this.tree = new ID3TreeNode(batch, rand, 0, this.maxHeight, columns);
    }

    public KMeansDiscretizer getDiscretizer() {
        return this.discretizer;
    }

    public ID3TreeNode getTree() {
        return this.tree;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setDiscretizer(KMeansDiscretizer discretizer) {
        this.discretizer = discretizer;
    }

    public void setTree(ID3TreeNode tree) {
        this.tree = tree;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }
}

