/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.trees.id3;

import com.github.chen0040.data.frame.BasicDataFrame;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.utils.CountRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class ID3TreeNode
implements Cloneable {
    private int rowCount;
    private int splitAttributeIndex;
    private String attributeValue;
    private final List<ID3TreeNode> childNodes = new ArrayList<ID3TreeNode>();
    private String classLabel;
    private final List<String> columns = new ArrayList<String>();

    public void copy(ID3TreeNode rhs) {
        this.rowCount = rhs.rowCount;
        this.splitAttributeIndex = rhs.splitAttributeIndex;
        this.attributeValue = rhs.attributeValue;
        this.childNodes.clear();
        for (int i = 0; i < rhs.childNodes.size(); ++i) {
            this.childNodes.add((ID3TreeNode)rhs.childNodes.get(i).clone());
        }
        this.classLabel = rhs.classLabel;
    }

    public Object clone() {
        ID3TreeNode clone = new ID3TreeNode();
        clone.copy(this);
        return clone;
    }

    public ID3TreeNode() {
    }

    public ID3TreeNode(DataFrame batch, Random random, int height, int maxHeight, List<String> columns) {
        int i;
        double information_gain;
        int i2;
        this.columns.addAll(columns);
        this.rowCount = batch.rowCount();
        this.splitAttributeIndex = -1;
        this.attributeValue = "";
        this.classLabel = "";
        this.updateClassLabel(batch);
        if (this.rowCount <= 1 || height == maxHeight) {
            return;
        }
        int n = columns.size();
        CountRepository[] counts = new CountRepository[n];
        CountRepository counts2 = new CountRepository();
        for (i2 = 0; i2 < n; ++i2) {
            String category = String.format("field%d", i2);
            counts[i2] = new CountRepository(category);
        }
        for (i2 = 0; i2 < this.rowCount; ++i2) {
            DataRow tuple = batch.row(i2);
            String label = tuple.categoricalTarget();
            String classEventName = "ClassLabel=" + (String)label;
            for (int j = 0; j < n; ++j) {
                String category_value = columns.get(j);
                counts[j].addSupportCount(new String[]{category_value, classEventName});
                counts[j].addSupportCount(new String[]{category_value});
                counts[j].addSupportCount(new String[0]);
            }
            counts2.addSupportCount(new String[]{classEventName});
            counts2.addSupportCount(new String[0]);
        }
        double entropy_S = 0.0;
        for (String classEventName : counts2.getSubEventNames(new String[0])) {
            double p_class = counts2.getProbability(classEventName);
            entropy_S += -p_class * this.log2(p_class);
        }
        if (entropy_S == 0.0) {
            return;
        }
        this.splitAttributeIndex = -1;
        HashMap<Integer, Double> candidates = new HashMap<Integer, Double>();
        for (int i3 = 0; i3 < n; ++i3) {
            List T = counts[i3].getSubEventNames(new String[0]);
            double entropy_reduced = 0.0;
            for (int j = 0; j < T.size(); ++j) {
                String t = (String)T.get(j);
                double p_t = counts[i3].getProbability(t);
                List classNames = counts[i3].getSubEventNames(new String[]{t});
                double entropy_t = 0.0;
                for (int k = 0; k < classNames.size(); ++k) {
                    double p_class_in_t = counts[i3].getConditionalProbability((String)T.get(j), (String)classNames.get(k));
                    entropy_t += -p_class_in_t * this.log2(p_class_in_t);
                }
                entropy_reduced += p_t * entropy_t;
            }
            information_gain = entropy_S - entropy_reduced;
            if (!(information_gain > 0.0)) continue;
            candidates.put(i3, information_gain);
        }
        if (candidates.isEmpty()) {
            return;
        }
        double max_information_gain = 0.0;
        for (Integer candidateFeatureIndex : candidates.keySet()) {
            information_gain = (Double)candidates.get(candidateFeatureIndex);
            if (!(information_gain > max_information_gain)) continue;
            max_information_gain = information_gain;
            this.splitAttributeIndex = candidateFeatureIndex;
        }
        List T = counts[this.splitAttributeIndex].getSubEventNames(new String[0]);
        DataFrame[] batches = new DataFrame[T.size()];
        for (i = 0; i < batches.length; ++i) {
            batches[i] = new BasicDataFrame();
        }
        for (i = 0; i < this.rowCount; ++i) {
            DataRow row = batch.row(i);
            String attribute_value = columns.get(this.splitAttributeIndex);
            batches[T.indexOf(attribute_value)].addRow(row);
        }
        for (i = 0; i < batches.length; ++i) {
            batches[i].lock();
            this.childNodes.add(new ID3TreeNode(batches[i], random, height + 1, maxHeight, columns));
            this.childNodes.get((int)i).attributeValue = (String)T.get(i);
        }
    }

    public static double heuristicCost(double n) {
        if (n <= 1.0) {
            return 0.0;
        }
        return 2.0 * (Math.log(n - 1.0) + 0.5772156649) - 2.0 * (n - 1.0) / n;
    }

    private double log2(double val) {
        return Math.log(val) / Math.log(2.0);
    }

    private void updateClassLabel(DataFrame batch) {
        HashMap<String, Integer> classLabelCounts = new HashMap<String, Integer>();
        for (int i = 0; i < batch.rowCount(); ++i) {
            String label;
            classLabelCounts.put(label, classLabelCounts.containsKey(label = batch.row(i).categoricalTarget()) ? (Integer)classLabelCounts.get(label) + 1 : 1);
        }
        int maxCount = 0;
        for (String label : classLabelCounts.keySet()) {
            if ((Integer)classLabelCounts.get(label) <= maxCount) continue;
            maxCount = (Integer)classLabelCounts.get(label);
            this.classLabel = label;
        }
    }

    public String predict(DataRow row) {
        if (!this.childNodes.isEmpty()) {
            String value = this.columns.get(this.splitAttributeIndex);
            for (ID3TreeNode child : this.childNodes) {
                if (!child.attributeValue.equals(value)) continue;
                return child.predict(row);
            }
        }
        return this.classLabel;
    }

    protected double pathLength(DataRow row) {
        if (!this.childNodes.isEmpty()) {
            String value = this.columns.get(this.splitAttributeIndex);
            for (ID3TreeNode child : this.childNodes) {
                if (!child.attributeValue.equals(value)) continue;
                return child.pathLength(row) + 1.0;
            }
        }
        return ID3TreeNode.heuristicCost(this.rowCount);
    }
}

