/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.trees.isolation;

import com.github.chen0040.data.frame.BasicDataFrame;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class IFTreeNode
implements Cloneable {
    private int rowCount;
    private int featureIndex;
    private double splitPoint;
    private List<IFTreeNode> childNodes;
    private String nodeId;

    public void copy(IFTreeNode rhs) throws CloneNotSupportedException {
        this.rowCount = rhs.rowCount;
        this.featureIndex = rhs.featureIndex;
        this.splitPoint = rhs.splitPoint;
        this.nodeId = rhs.nodeId;
        this.childNodes = null;
        if (rhs.childNodes != null) {
            this.childNodes = new ArrayList<IFTreeNode>();
            for (int i = 0; i < rhs.childNodes.size(); ++i) {
                this.childNodes.add((IFTreeNode)rhs.childNodes.get(i).clone());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IFTreeNode clone = (IFTreeNode)super.clone();
        clone.copy(this);
        return clone;
    }

    public IFTreeNode() {
        this.childNodes = new ArrayList<IFTreeNode>();
        this.nodeId = UUID.randomUUID().toString();
    }

    private static double epsilon() {
        return 1.0E-11;
    }

    public IFTreeNode(DataFrame batch, Random random, int height, int maxHeight) {
        int i;
        this.rowCount = batch.rowCount();
        this.nodeId = UUID.randomUUID().toString();
        if (this.rowCount <= 1 || height == maxHeight) {
            return;
        }
        int n = batch.row(0).toArray().length;
        double[] minValues = new double[n];
        double[] maxValues = new double[n];
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            DataRow tuple = batch.row(i2);
            double[] x = tuple.toArray();
            int n_min = Math.min(n, x.length);
            for (int j = 0; j < n_min; ++j) {
                minValues[j] = Math.min(minValues[j], x[j]);
                maxValues[j] = Math.max(maxValues[j], x[j]);
            }
        }
        ArrayList<Integer> featureList = new ArrayList<Integer>();
        for (int i3 = 0; i3 < n; ++i3) {
            if (!(minValues[i3] < maxValues[i3]) || !(maxValues[i3] - minValues[i3] > IFTreeNode.epsilon())) continue;
            featureList.add(i3);
        }
        if (featureList.isEmpty()) {
            return;
        }
        this.featureIndex = random.nextInt(featureList.size());
        this.splitPoint = minValues[this.featureIndex] + (maxValues[this.featureIndex] - minValues[this.featureIndex]) * random.nextDouble();
        DataFrame[] batches = new DataFrame[2];
        this.childNodes = new ArrayList<IFTreeNode>();
        for (i = 0; i < batches.length; ++i) {
            batches[i] = new BasicDataFrame();
        }
        for (i = 0; i < this.rowCount; ++i) {
            DataRow tuple = batch.row(i);
            double[] x = tuple.toArray();
            double featureValue = x[this.featureIndex];
            if (featureValue < this.splitPoint) {
                batches[0].addRow(tuple);
                continue;
            }
            batches[1].addRow(tuple);
        }
        for (i = 0; i < batches.length; ++i) {
            batches[i].lock();
            this.childNodes.add(new IFTreeNode(batches[i], random, height + 1, maxHeight));
        }
    }

    public static double heuristicCost(double n) {
        if (n <= 1.0) {
            return 0.0;
        }
        return 2.0 * (Math.log(n - 1.0) + 0.5772156649) - 2.0 * (n - 1.0) / n;
    }

    public int getTupleCount() {
        return this.rowCount;
    }

    public void setTupleCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getFeatureIndex() {
        return this.featureIndex;
    }

    public void setFeatureIndex(int featureIndex) {
        this.featureIndex = featureIndex;
    }

    public double getSplitPoint() {
        return this.splitPoint;
    }

    public void setSplitPoint(double splitPoint) {
        this.splitPoint = splitPoint;
    }

    public List<IFTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(ArrayList<IFTreeNode> childNodes) {
        this.childNodes = childNodes;
    }

    protected double pathLength(DataRow tuple) {
        if (this.childNodes == null) {
            return IFTreeNode.heuristicCost(this.rowCount);
        }
        double[] x = tuple.toArray();
        double featureValue = x[this.featureIndex];
        if (featureValue < this.splitPoint) {
            return this.childNodes.get(0).pathLength(tuple) + 1.0;
        }
        return this.childNodes.get(1).pathLength(tuple) + 1.0;
    }
}

