/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.trees.isolation;

import com.github.chen0040.data.frame.BasicDataFrame;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.trees.isolation.IFTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class IsolationForest
implements Cloneable {
    private double threshold = 0.5;
    private int treeCount = 100;
    private static final Random random = new Random();
    private static final double log2 = Math.log(2.0);
    private List<IFTreeNode> trees;
    private int rowCount;

    public void copy(IsolationForest rhs2) throws CloneNotSupportedException {
        this.rowCount = rhs2.rowCount;
        this.trees = null;
        if (rhs2.trees != null) {
            this.trees = new ArrayList<IFTreeNode>();
            for (int i = 0; i < rhs2.trees.size(); ++i) {
                this.trees.add((IFTreeNode)rhs2.trees.get(i).clone());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IsolationForest clone = (IsolationForest)super.clone();
        clone.copy(this);
        return clone;
    }

    private static double log2(double n) {
        return Math.log(n) / log2;
    }

    public boolean isAnomaly(DataRow tuple) {
        return this.evaluate(tuple) > this.threshold;
    }

    public void fit(DataFrame batch) {
        this.trees = new ArrayList<IFTreeNode>();
        this.rowCount = batch.rowCount();
        int maxHeight = (int)Math.ceil(IsolationForest.log2(this.rowCount));
        for (int i = 0; i < this.treeCount; ++i) {
            DataFrame treeBatch = this.randomize(batch);
            IFTreeNode tree = new IFTreeNode(treeBatch, random, 0, maxHeight);
            this.trees.add(tree);
        }
    }

    private DataFrame randomize(DataFrame dataFrame) {
        int i;
        BasicDataFrame treeBatch = new BasicDataFrame();
        ArrayList<DataRow> list = new ArrayList<DataRow>();
        for (i = 0; i < dataFrame.rowCount(); ++i) {
            list.add(dataFrame.row(i));
        }
        Collections.shuffle(list);
        for (i = 0; i < list.size(); ++i) {
            treeBatch.addRow((DataRow)list.get(i));
        }
        treeBatch.lock();
        return treeBatch;
    }

    public double[] getDistributionScores(DataRow tuple) {
        double[] scores;
        scores = new double[]{this.evaluate(tuple), 1.0 - scores[0]};
        return scores;
    }

    public double evaluate(DataRow tuple) {
        double avgPathLength = 0.0;
        for (int i = 0; i < this.trees.size(); ++i) {
            avgPathLength += this.trees.get(i).pathLength(tuple);
        }
        return Math.pow(2.0, -(avgPathLength /= (double)this.trees.size()) / IFTreeNode.heuristicCost(this.rowCount));
    }

    public DataFrame fitAndTransform(DataFrame data) {
        this.fit(data);
        data = data.makeCopy();
        for (int i = 0; i < data.rowCount(); ++i) {
            DataRow row;
            boolean anomaly = this.isAnomaly(row = data.row(i));
            row.setCategoricalTargetCell("anomaly", anomaly ? "1" : "0");
        }
        return data;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int getTreeCount() {
        return this.treeCount;
    }

    public List<IFTreeNode> getTrees() {
        return this.trees;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setTreeCount(int treeCount) {
        this.treeCount = treeCount;
    }
}

