/*
 * Decompiled with CFR 0.152.
 */
package com.github.choonchernlim.security.adfs.saml2;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.WebUtils;

final class CsrfHeaderFilter
extends OncePerRequestFilter {
    static final String HEADER_NAME = "X-XSRF-TOKEN";
    static final String COOKIE_NAME = "XSRF-TOKEN";

    CsrfHeaderFilter() {
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        CsrfToken csrf = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
        if (csrf != null) {
            String token = csrf.getToken();
            Cookie existingCookie = WebUtils.getCookie((HttpServletRequest)request, (String)COOKIE_NAME);
            if (existingCookie == null || !token.equals(existingCookie.getValue())) {
                Cookie cookie = new Cookie(COOKIE_NAME, token);
                cookie.setPath(request.getContextPath());
                cookie.setSecure(true);
                cookie.setMaxAge(28800);
                response.addCookie(cookie);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

