/*
 * Decompiled with CFR 0.152.
 */
package com.github.choonchernlim.security.adfs.saml2;

import com.github.choonchernlim.betterPreconditions.preconditions.ObjectPreconditions;
import com.github.choonchernlim.betterPreconditions.preconditions.PreconditionFactory;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

final class MockFilterSecurityInterceptor
implements Filter {
    private final User user;

    MockFilterSecurityInterceptor(User user) {
        ((ObjectPreconditions)((ObjectPreconditions)PreconditionFactory.expect((Object)user, (String)"user").not()).toBeNull()).check();
        this.user = user;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)this.user, null, this.user.getAuthorities());
        authentication.setDetails((Object)this.user);
        SecurityContext securityContext = SecurityContextHolder.getContext();
        securityContext.setAuthentication((Authentication)authentication);
        ((HttpServletRequest)servletRequest).getSession(true).setAttribute("SPRING_SECURITY_CONTEXT", (Object)securityContext);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

