/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket;

import com.github.chouheiwa.wallet.socket.account_object;
import com.github.chouheiwa.wallet.socket.asset;
import com.github.chouheiwa.wallet.socket.chain.asset_object;
import com.github.chouheiwa.wallet.socket.chain.bucket_object;
import com.github.chouheiwa.wallet.socket.chain.object_id;
import com.github.chouheiwa.wallet.socket.chain.operation_history_object;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.util.Pair;

public class BitshareData {
    public List<asset> listBalances;
    public List<Pair<operation_history_object, Date>> listHistoryObject;
    public Map<object_id<account_object>, account_object> mapId2AccountObject;
    public Map<object_id<asset_object>, asset_object> mapId2AssetObject;
    public asset_object assetObjectCurrency;
    public Map<object_id<asset_object>, List<bucket_object>> mapAssetId2Bucket;

    public TotalBalances getTotalAmountBalances() {
        asset_object assetObjectBase = this.mapId2AssetObject.get(new object_id<asset_object>(0, asset_object.class));
        long lTotalAmount = 0L;
        for (asset assetBalances : this.listBalances) {
            long lBaseAmount = this.convert_asset_to_base((asset)assetBalances, (asset_object)assetObjectBase).amount;
            lTotalAmount += lBaseAmount;
        }
        asset_object.asset_object_legible assetObjectLegible = assetObjectBase.get_legible_asset_object(lTotalAmount);
        double fResult = (double)assetObjectLegible.lDecimal / (double)assetObjectLegible.scaled_precision + (double)assetObjectLegible.lCount;
        int nResult = (int)Math.rint(fResult);
        TotalBalances totalBalances = new TotalBalances();
        totalBalances.strTotalBalances = String.format(Locale.ENGLISH, "%d %s", nResult, assetObjectBase.symbol);
        long lTotalCurrency = this.assetObjectCurrency.convert_exchange_from_base(lTotalAmount);
        asset_object.asset_object_legible legibleCurrency = this.assetObjectCurrency.get_legible_asset_object(lTotalCurrency);
        double fCurrency = (double)legibleCurrency.lDecimal / (double)legibleCurrency.scaled_precision + (double)legibleCurrency.lCount;
        int nCurrencyResult = (int)Math.rint(fCurrency);
        totalBalances.strTotalCurrency = String.format(Locale.ENGLISH, "%d %s", nCurrencyResult, this.assetObjectCurrency.symbol);
        double fExchange = this.get_base_exchange_rate(this.assetObjectCurrency, assetObjectBase);
        totalBalances.strExchangeRate = String.format(Locale.ENGLISH, "%.4f %s/%s", fExchange, this.assetObjectCurrency.symbol, assetObjectBase.symbol);
        return totalBalances;
    }

    public asset convert_asset_to_base(asset assetAmount, asset_object assetObjectBase) {
        if (assetAmount.asset_id.equals(assetObjectBase.id)) {
            return assetAmount;
        }
        List<bucket_object> bucketObject = this.mapAssetId2Bucket.get(assetAmount.asset_id);
        long lBaseAmount = (long)((double)assetAmount.amount * ((double)bucketObject.get((int)0).close_base / (double)bucketObject.get((int)0).close_quote));
        return new asset(lBaseAmount, assetObjectBase.id);
    }

    public double get_base_exchange_rate(asset_object assetObject, asset_object assetObjectBase) {
        List<bucket_object> bucketObject = this.mapAssetId2Bucket.get(assetObject.id);
        double fExchange = (double)bucketObject.get((int)0).close_quote / (double)bucketObject.get((int)0).close_base * (double)assetObjectBase.get_scaled_precision() / (double)assetObject.get_scaled_precision();
        return fExchange;
    }

    public class TotalBalances {
        public String strTotalBalances;
        public String strTotalCurrency;
        public String strExchangeRate;
    }
}

