/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket;

import com.github.chouheiwa.wallet.net.model.AllHistory;
import com.github.chouheiwa.wallet.net.model.HistoryResponseModel;
import com.github.chouheiwa.wallet.socket.BitshareData;
import com.github.chouheiwa.wallet.socket.account_object;
import com.github.chouheiwa.wallet.socket.asset;
import com.github.chouheiwa.wallet.socket.chain.CallOrder;
import com.github.chouheiwa.wallet.socket.chain.asset_object;
import com.github.chouheiwa.wallet.socket.chain.asset_options;
import com.github.chouheiwa.wallet.socket.chain.bitasset_options;
import com.github.chouheiwa.wallet.socket.chain.block_chain_info;
import com.github.chouheiwa.wallet.socket.chain.block_header;
import com.github.chouheiwa.wallet.socket.chain.block_object;
import com.github.chouheiwa.wallet.socket.chain.bucket_object;
import com.github.chouheiwa.wallet.socket.chain.config;
import com.github.chouheiwa.wallet.socket.chain.dynamic_global_property_object;
import com.github.chouheiwa.wallet.socket.chain.global_property_object;
import com.github.chouheiwa.wallet.socket.chain.limit_order_object;
import com.github.chouheiwa.wallet.socket.chain.memo_data;
import com.github.chouheiwa.wallet.socket.chain.object_id;
import com.github.chouheiwa.wallet.socket.chain.operation_history_object;
import com.github.chouheiwa.wallet.socket.chain.operation_types_histoy_object;
import com.github.chouheiwa.wallet.socket.chain.operations;
import com.github.chouheiwa.wallet.socket.chain.signed_transaction;
import com.github.chouheiwa.wallet.socket.chain.types;
import com.github.chouheiwa.wallet.socket.exception.NetworkStatusException;
import com.github.chouheiwa.wallet.socket.fc.crypto.sha256_object;
import com.github.chouheiwa.wallet.socket.full_account_object;
import com.github.chouheiwa.wallet.socket.market.MarketTicker;
import com.github.chouheiwa.wallet.socket.market.OrderBook;
import com.github.chouheiwa.wallet.socket.wallet_api;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;

public class BitsharesWalletWraper {
    private wallet_api mWalletApi;
    private Map<object_id<account_object>, account_object> mMapAccountId2Object = new ConcurrentHashMap<object_id<account_object>, account_object>();
    private Map<object_id<account_object>, List<asset>> mMapAccountId2Asset = new ConcurrentHashMap<object_id<account_object>, List<asset>>();
    private Map<object_id<account_object>, List<operation_history_object>> mMapAccountId2History = new ConcurrentHashMap<object_id<account_object>, List<operation_history_object>>();
    private Map<object_id<asset_object>, asset_object> mMapAssetId2Object = new ConcurrentHashMap<object_id<asset_object>, asset_object>();
    private String mstrWalletFilePath;
    private String chain_id;
    private String websocket_server;
    private int mnStatus = -1;
    private static final int STATUS_INVALID = -1;
    private static final int STATUS_INITIALIZED = 0;
    private BitshareData mBitshareData;

    public BitsharesWalletWraper() {
        this.chain_id = "a3b8ef27e8992d68df66532650ab4edd814b52becec9e6fc12ab33d1c8785e93";
        this.setWebsocket_server("ws://39.104.110.98:11112");
    }

    public BitsharesWalletWraper(String chain_id, String prefix) {
        this.chain_id = chain_id;
        config.GRAPHENE_ADDRESS_PREFIX = prefix;
    }

    public Boolean setWebsocket_server(String websocket_server) {
        this.websocket_server = websocket_server;
        this.clear();
        return this.build_connect() == 0;
    }

    public void clear() {
        if (this.mWalletApi != null) {
            this.mWalletApi.reset();
        }
        this.mWalletApi = new wallet_api(this.websocket_server);
        this.mMapAccountId2Object.clear();
        this.mMapAccountId2Asset.clear();
        this.mMapAccountId2History.clear();
        this.mMapAssetId2Object.clear();
        this.mnStatus = -1;
    }

    public void reset() {
        this.mWalletApi.reset();
        this.mWalletApi = new wallet_api(this.websocket_server);
        this.mMapAccountId2Object.clear();
        this.mMapAccountId2Asset.clear();
        this.mMapAccountId2History.clear();
        this.mMapAssetId2Object.clear();
        if (this.mstrWalletFilePath != null) {
            File file = new File(this.mstrWalletFilePath);
            file.delete();
        }
        this.mnStatus = -1;
    }

    public account_object get_account() {
        List<account_object> listAccount = this.mWalletApi.list_my_accounts();
        if (listAccount == null || listAccount.isEmpty()) {
            return null;
        }
        return listAccount.get(0);
    }

    public boolean is_new() {
        return this.mWalletApi.is_new();
    }

    public boolean is_locked() {
        return this.mWalletApi.is_locked();
    }

    public synchronized int build_connect() {
        if (this.mnStatus == 0) {
            return 0;
        }
        int nRet = this.mWalletApi.initialize(this.chain_id);
        if (nRet != 0) {
            return nRet;
        }
        this.mnStatus = 0;
        return 0;
    }

    public void close() {
        this.mWalletApi.close();
    }

    public void set_passwrod(String strPassword) {
        this.mWalletApi.set_passwrod(strPassword);
    }

    public int load_wallet_file(String strFileName, String password) {
        return this.mWalletApi.load_wallet_file(strFileName, password);
    }

    public List<account_object> list_my_accounts() {
        return this.mWalletApi.list_my_accounts();
    }

    public int import_key(String strAccountNameOrId, String strPrivateKey) {
        try {
            int nRet = this.mWalletApi.import_key(strAccountNameOrId, strPrivateKey);
            if (nRet != 0) {
                return nRet;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        for (account_object accountObject : this.list_my_accounts()) {
            this.mMapAccountId2Object.put(accountObject.id, accountObject);
        }
        return 0;
    }

    public int import_keys(String strAccountNameOrId, String strPrivateKey1, String strPrivateKey2) {
        try {
            int nRet = this.mWalletApi.import_keys(strAccountNameOrId, strPrivateKey1, strPrivateKey2);
            if (nRet != 0) {
                return nRet;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        for (account_object accountObject : this.list_my_accounts()) {
            this.mMapAccountId2Object.put(accountObject.id, accountObject);
        }
        return 0;
    }

    public int import_brain_key(String strAccountNameOrId, String strBrainKey) {
        try {
            int nRet = this.mWalletApi.import_brain_key(strAccountNameOrId, strBrainKey);
            if (nRet != 0) {
                return nRet;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -7;
        }
        for (account_object accountObject : this.list_my_accounts()) {
            this.mMapAccountId2Object.put(accountObject.id, accountObject);
        }
        return 0;
    }

    public int unlock(String strPassword) {
        return this.mWalletApi.unlock(strPassword);
    }

    public sha256_object get_chain_id() throws Exception {
        return this.mWalletApi.get_chain_id();
    }

    public signed_transaction create_account_with_pub_key(String pubKey, String strAccountName, String strRegistar, String strReferrer, int refferPercent) throws Exception {
        return this.mWalletApi.create_account_with_pub_key(pubKey, strAccountName, strRegistar, strReferrer, refferPercent);
    }

    public signed_transaction upgrade_account(String name, boolean upgrade_to_lifetime_member) throws Exception {
        return this.mWalletApi.upgrade_account(name, upgrade_to_lifetime_member);
    }

    public signed_transaction with_draw_vesting(String name_or_id, String vesting_name, String amount, String asset_symbol) throws Exception {
        return this.mWalletApi.withdraw_vesting(name_or_id, vesting_name, amount, asset_symbol);
    }

    public signed_transaction create_asset(String issuer, String symbol, short precision, asset_options common, bitasset_options bitasset_opts) throws Exception {
        return this.mWalletApi.create_asset(issuer, symbol, precision, common, bitasset_opts);
    }

    public signed_transaction issue_asset(String to_account, String amount, String symbol, String memo) throws Exception {
        return this.mWalletApi.issue_asset(to_account, amount, symbol, memo);
    }

    public signed_transaction publish_asset_feed(String publishing_account, String symbol, long core_exchange_base_amount, long core_exchange_quote_amount, double maintenance_collateral_ratio, double maximum_short_squeeze_ratio) throws Exception {
        return this.mWalletApi.publish_asset_feed(publishing_account, symbol, core_exchange_base_amount, core_exchange_quote_amount, maintenance_collateral_ratio, maximum_short_squeeze_ratio);
    }

    public int lock() {
        return this.mWalletApi.lock();
    }

    public List<asset> list_balances(boolean bRefresh) throws Exception {
        ArrayList<asset> listAllAsset = new ArrayList<asset>();
        for (account_object accountObject : this.list_my_accounts()) {
            List<asset> listAsset = this.list_account_balance(accountObject.id, bRefresh);
            listAllAsset.addAll(listAsset);
        }
        return listAllAsset;
    }

    public List<asset> list_account_balance(object_id<account_object> accountObjectId, boolean bRefresh) throws Exception {
        List<asset> listAsset = null;
        if (this.mMapAccountId2Asset != null) {
            listAsset = this.mMapAccountId2Asset.get(accountObjectId);
            if (bRefresh || listAsset == null) {
                listAsset = this.mWalletApi.list_account_balance(accountObjectId);
                this.mMapAccountId2Asset.put(accountObjectId, listAsset);
                return listAsset;
            }
        } else {
            return null;
        }
        return listAsset;
    }

    public List<asset_object> list_assets_obj(String strLowerBound, int nLimit) throws Exception {
        return this.mWalletApi.list_assets_obj(strLowerBound, nLimit);
    }

    public Map<object_id<asset_object>, asset_object> get_assets(List<object_id<asset_object>> listAssetObjectId) throws Exception {
        HashMap<object_id<asset_object>, asset_object> mapId2Object = new HashMap<object_id<asset_object>, asset_object>();
        ArrayList<object_id<asset_object>> listRequestId = new ArrayList<object_id<asset_object>>();
        for (object_id<asset_object> objectId : listAssetObjectId) {
            asset_object assetObject = this.mMapAssetId2Object.get(objectId);
            if (assetObject != null) {
                mapId2Object.put(objectId, assetObject);
                continue;
            }
            listRequestId.add(objectId);
        }
        if (!listRequestId.isEmpty()) {
            List<asset_object> listAssetObject = this.mWalletApi.get_assets(listRequestId);
            for (asset_object assetObject : listAssetObject) {
                mapId2Object.put(assetObject.id, assetObject);
                this.mMapAssetId2Object.put(assetObject.id, assetObject);
            }
        }
        return mapId2Object;
    }

    public asset_object lookup_asset_symbols(String strAssetSymbol) throws Exception {
        return this.mWalletApi.lookup_asset_symbols(strAssetSymbol);
    }

    public String lookup_asset_symbols_rate(String strAssetSymbol) throws Exception {
        return this.mWalletApi.lookup_asset_symbols_rate(strAssetSymbol);
    }

    public String get_Fee(String id, int op) throws Exception {
        return this.mWalletApi.get_Fee(id, op);
    }

    public String get_object(String object) throws Exception {
        return this.mWalletApi.get_object(object);
    }

    public Map<object_id<account_object>, account_object> get_accounts(List<object_id<account_object>> listAccountObjectId) throws Exception {
        HashMap<object_id<account_object>, account_object> mapId2Object = new HashMap<object_id<account_object>, account_object>();
        ArrayList<object_id<account_object>> listRequestId = new ArrayList<object_id<account_object>>();
        for (object_id<account_object> objectId : listAccountObjectId) {
            account_object accountObject = this.mMapAccountId2Object.get(objectId);
            if (accountObject != null) {
                mapId2Object.put(objectId, accountObject);
                continue;
            }
            listRequestId.add(objectId);
        }
        if (!listRequestId.isEmpty()) {
            List<account_object> listAccountObject = this.mWalletApi.get_accounts(listRequestId);
            for (account_object accountObject : listAccountObject) {
                mapId2Object.put(accountObject.id, accountObject);
                this.mMapAccountId2Object.put(accountObject.id, accountObject);
            }
        }
        return mapId2Object;
    }

    public signed_transaction transfer(String strFrom, String strTo, String strAmount, String strAssetSymbol, String strMemo, String amount_to_fee, String symbol_to_fee) throws Exception {
        return this.mWalletApi.transfer(strFrom, strTo, strAmount, strAssetSymbol, strMemo, amount_to_fee, symbol_to_fee);
    }

    public signed_transaction borrow_asset(String amount_to_borrow, String asset_symbol, String amount_to_collateral, int index) throws Exception {
        return this.mWalletApi.borrow_asset(amount_to_borrow, asset_symbol, amount_to_collateral, index);
    }

    public signed_transaction change_account_key(String account, String pubkey) throws Exception {
        return this.mWalletApi.change_account_key(account, pubkey);
    }

    public signed_transaction create_transcation(operations.base_operation base_operation2) throws Exception {
        return this.mWalletApi.create_transcation(base_operation2);
    }

    public block_chain_info info() throws Exception {
        return this.mWalletApi.get_info();
    }

    public block_object get_block(int nblocknum) throws Exception {
        return this.mWalletApi.get_block(nblocknum);
    }

    public Map<object_id<asset_object>, List<bucket_object>> get_market_histories_base(List<object_id<asset_object>> listAssetObjectId, Integer bugket, Date dateObjectStart, Date dateObjectEnd) throws Exception {
        HashMap<object_id<asset_object>, List<bucket_object>> mapId2BucketObject = new HashMap<object_id<asset_object>, List<bucket_object>>();
        object_id<asset_object> assetObjectBase = new object_id<asset_object>(0, asset_object.class);
        for (object_id<asset_object> objectId : listAssetObjectId) {
            List<bucket_object> listBucketObject;
            if (objectId.equals(assetObjectBase) || (listBucketObject = this.mWalletApi.get_market_history(objectId, assetObjectBase, bugket, dateObjectStart, dateObjectEnd)).isEmpty()) continue;
            mapId2BucketObject.put(objectId, listBucketObject);
        }
        return mapId2BucketObject;
    }

    public block_header get_block_header(int nBlockNumber) throws Exception {
        return this.mWalletApi.get_block_header(nBlockNumber);
    }

    public List<operation_history_object> get_history(boolean bRefresh) throws Exception {
        ArrayList<operation_history_object> listAllHistoryObject = new ArrayList<operation_history_object>();
        for (account_object accountObject : this.list_my_accounts()) {
            List<operation_history_object> listHistoryObject = this.get_account_history(accountObject.id, 100, bRefresh);
            listAllHistoryObject.addAll(listHistoryObject);
        }
        return listAllHistoryObject;
    }

    public List<CallOrder> get_call_orders(String assetIdOrName, Integer limit) throws NetworkStatusException {
        object_id<Object> object_id2 = object_id.create_from_string(assetIdOrName);
        if (object_id2 == null) {
            asset_object list = null;
            try {
                list = this.lookup_asset_symbols(assetIdOrName);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (list == null) {
                return null;
            }
            object_id2 = list.id;
        }
        return this.mWalletApi.get_call_orders(object_id2, limit);
    }

    public List<operation_history_object> get_account_history(object_id<account_object> accountObjectId, int nLimit, boolean bRefresh) throws Exception {
        List<operation_history_object> listHistoryObject = this.mMapAccountId2History.get(accountObjectId);
        if (listHistoryObject == null || bRefresh) {
            listHistoryObject = this.mWalletApi.get_account_history(accountObjectId, nLimit);
            if (listHistoryObject == null) {
                return null;
            }
            this.mMapAccountId2History.put(accountObjectId, listHistoryObject);
        }
        return listHistoryObject;
    }

    public operation_types_histoy_object get_account_history_by_operations(String accountIdOrName, List<Integer> operation_types, int start, int nLimit) throws Exception {
        operation_types_histoy_object listHistoryObject = this.mWalletApi.get_account_history_by_operations(accountIdOrName, operation_types, start, nLimit);
        return listHistoryObject;
    }

    public BitshareData prepare_data_to_display(boolean bRefresh, String quotoSymbo, Integer bugket, Date dateStart, Date dateEnd, BitsharesWalletWraper bww) {
        try {
            List<asset> listBalances = bww.list_balances(bRefresh);
            HashSet hashSetObjectId = new HashSet();
            HashSet<object_id<asset_object>> hashSetAssetObject = new HashSet<object_id<asset_object>>();
            hashSetAssetObject.add(new object_id<asset_object>(0, asset_object.class));
            for (asset assetBalances : listBalances) {
                hashSetAssetObject.add(assetBalances.asset_id);
            }
            ArrayList<object_id<account_object>> listAccountObjectId = new ArrayList<object_id<account_object>>();
            listAccountObjectId.addAll(hashSetObjectId);
            Map<object_id<account_object>, account_object> mapId2AccountObject = bww.get_accounts(listAccountObjectId);
            ArrayList<object_id<asset_object>> listAssetObjectId = new ArrayList<object_id<asset_object>>();
            listAssetObjectId.addAll(hashSetAssetObject);
            asset_object currencyObject = this.mWalletApi.list_assets_obj(quotoSymbo, 1).get(0);
            hashSetAssetObject.add(currencyObject.id);
            listAssetObjectId.clear();
            listAssetObjectId.addAll(hashSetAssetObject);
            Map<object_id<asset_object>, List<bucket_object>> mapAssetId2Bucket = this.get_market_histories_base(listAssetObjectId, bugket, dateStart, dateEnd);
            this.mBitshareData = new BitshareData();
            this.mBitshareData.assetObjectCurrency = currencyObject;
            this.mBitshareData.listBalances = listBalances;
            this.mBitshareData.mapId2AccountObject = mapId2AccountObject;
            this.mBitshareData.mapAssetId2Bucket = mapAssetId2Bucket;
            return this.mBitshareData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public signed_transaction sell_asset(String amountToSell, String symbolToSell, String minToReceive, String symbolToReceive, int timeoutSecs, boolean fillOrKill, String amount_to_fee, String symbol_to_fee, int index) throws Exception {
        return this.mWalletApi.sell_asset(amountToSell, symbolToSell, minToReceive, symbolToReceive, timeoutSecs, fillOrKill, amount_to_fee, symbol_to_fee, index);
    }

    public asset calculate_sell_fee(asset_object assetToSell, asset_object assetToReceive, double rate, double amount, global_property_object globalPropertyObject) {
        return this.mWalletApi.calculate_sell_fee(assetToSell, assetToReceive, rate, amount, globalPropertyObject);
    }

    public asset calculate_buy_fee(asset_object assetToReceive, asset_object assetToSell, double rate, double amount, global_property_object globalPropertyObject) {
        return this.mWalletApi.calculate_buy_fee(assetToReceive, assetToSell, rate, amount, globalPropertyObject);
    }

    public signed_transaction sell(String quote, String base, double minToReceive, double amount, String amount_to_fee, String symbol_to_fee, int index) throws Exception {
        return this.mWalletApi.sell(quote, base, minToReceive, amount, amount_to_fee, symbol_to_fee, index);
    }

    public signed_transaction sell(String base, String quote, double rate, double amount, int timeoutSecs, String amount_to_fee, String symbol_to_fee, int index) throws Exception {
        return this.mWalletApi.sell(base, quote, rate, amount, timeoutSecs, amount_to_fee, symbol_to_fee, index);
    }

    public signed_transaction buy(String quote, String base, double amountToSell, double amount, String amount_to_fee, String symbol_to_fee, int index) throws Exception {
        return this.mWalletApi.buy(quote, base, amountToSell, amount, amount_to_fee, symbol_to_fee, index);
    }

    public signed_transaction buy(String base, String quote, double rate, double amount, int timeoutSecs, String amount_to_fee, String symbol_to_fee, int index) throws Exception {
        return this.mWalletApi.buy(base, quote, rate, amount, timeoutSecs, amount_to_fee, symbol_to_fee, index);
    }

    public BitshareData getBitshareData() {
        return this.mBitshareData;
    }

    public account_object get_account_object(String strAccount) throws Exception {
        return this.mWalletApi.get_account(strAccount);
    }

    public asset transfer_calculate_fee(String strAmount, String strAssetSymbol, String strMemo) throws Exception {
        return this.mWalletApi.transfer_calculate_fee(strAmount, strAssetSymbol, strMemo);
    }

    public String get_plain_text_message(memo_data memoData) {
        return this.mWalletApi.decrypt_memo_message(memoData);
    }

    public List<full_account_object> get_full_accounts(List<String> names, boolean subscribe) throws Exception {
        return this.mWalletApi.get_full_accounts(names, subscribe);
    }

    public signed_transaction cancel_order(object_id<limit_order_object> id) throws Exception {
        return this.mWalletApi.cancel_order(id);
    }

    public global_property_object get_global_properties() throws Exception {
        return this.mWalletApi.get_global_properties();
    }

    public HashMap<types.public_key_type, types.private_key_type> get_wallet_hash() {
        return this.mWalletApi.get_wallet_hash();
    }

    public boolean is_public_key_registered(String pub_key) throws Exception {
        return this.mWalletApi.is_public_key_registered(pub_key);
    }

    public long get_witness_budget() throws Exception {
        long witness_budget = 0L;
        dynamic_global_property_object dynamic_obj = this.mWalletApi.get_dynamic_global_properties();
        if (dynamic_obj == null) {
            return witness_budget;
        }
        witness_budget = dynamic_obj.witness_budget;
        return witness_budget;
    }

    public boolean is_suggest_brain_key(String accountName) {
        String suggestPublicKey = "";
        String suggestPrivateKey = "";
        try {
            types.public_key_type pubKeyType;
            BitsharesWalletWraper bww = new BitsharesWalletWraper();
            account_object account = bww.get_account_object(accountName);
            if (account != null && (pubKeyType = account.owner.get_keys().get(0)) != null) {
                suggestPublicKey = pubKeyType.toString();
                types.private_key_type privateKeyType = bww.get_wallet_hash().get(pubKeyType);
                if (privateKeyType != null) {
                    suggestPrivateKey = privateKeyType.toString();
                } else {
                    privateKeyType = bww.get_wallet_hash().get(pubKeyType);
                    if (privateKeyType != null) {
                        suggestPrivateKey = privateKeyType.toString();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return suggestPublicKey.equals("") || suggestPrivateKey.equals("");
    }

    public List<account_object> lookup_account_names(String strAccountName) throws Exception {
        return this.mWalletApi.lookup_account_names(strAccountName);
    }

    public List<operation_history_object> get_account_history_with_last_id(String accountId, int nLimit, String id) throws Exception {
        object_id<account_object> id_object = object_id.create_from_string(accountId);
        if (id_object == null) {
            id_object = this.get_account_object((String)accountId).id;
        }
        return this.mWalletApi.get_account_history_with_last_id(id_object, nLimit, id);
    }

    public List<HistoryResponseModel.DataBean> get_transfer_history(object_id<account_object> accountObjectId, int nLimit) throws Exception, JSONException {
        List<HistoryResponseModel.DataBean> listHistoryObject = this.mWalletApi.get_transfer_history(accountObjectId, nLimit);
        return listHistoryObject;
    }

    public MarketTicker get_ticker(String base, String quote) throws Exception {
        return this.mWalletApi.get_ticker(base, quote);
    }

    public String get_bitasset_data(String symbol) throws Exception {
        return this.mWalletApi.get_bitasset_data(symbol);
    }

    public AllHistory get_all_history(String baseSymbolId, String qouteSymbolId, int nLimit) throws Exception {
        return this.mWalletApi.get_all_history(baseSymbolId, qouteSymbolId, nLimit);
    }

    public OrderBook get_order_book(String base, String quote, int limit) throws Exception {
        return this.mWalletApi.get_order_book(base, quote, limit);
    }

    public operations.operation_type get_history_object(Integer object) throws NetworkStatusException {
        return this.mWalletApi.get_history_object(object);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        System.out.println("\u91ca\u653ewallet");
    }
}

