/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket;

import com.github.chouheiwa.wallet.socket.account_object;
import com.github.chouheiwa.wallet.socket.chain.object_id;
import com.github.chouheiwa.wallet.socket.chain.types;
import com.github.chouheiwa.wallet.socket.fc.io.base_encoder;
import com.github.chouheiwa.wallet.socket.fc.io.raw_type;
import com.google.common.primitives.UnsignedInteger;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class authority {
    private Integer weight_threshold;
    private ArrayList<ArrayList> account_auths = new ArrayList();
    private ArrayList<ArrayList> key_auths = new ArrayList();
    private ArrayList<ArrayList> address_auths = new ArrayList();

    public HashMap<object_id<account_object>, Integer> account_auths() {
        HashMap<object_id<account_object>, Integer> auths = new HashMap<object_id<account_object>, Integer>();
        for (ArrayList key : this.account_auths) {
            auths.put((object_id)key.get(0), (Integer)key.get(1));
        }
        return auths;
    }

    public authority() {
    }

    public authority(int nWeightThreshold, types.public_key_type publicKeyType, int nWeightType) {
        this.weight_threshold = nWeightThreshold;
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(publicKeyType);
        key.add(nWeightType);
        this.key_auths.add(key);
    }

    public void addAuthority(types.public_key_type publicKeyType, int nWeightType) {
        if (this.is_public_key_type_exist(publicKeyType)) {
            return;
        }
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(publicKeyType);
        key.add(nWeightType);
        this.key_auths.add(key);
    }

    public boolean is_public_key_type_exist(types.public_key_type publicKeyType) {
        for (ArrayList key : this.key_auths) {
            if (key.get(0).getClass() != types.public_key_type.class) {
                String pub = (String)key.get(0);
                try {
                    key.set(0, new types.public_key_type(pub));
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            if (!key.get(0).equals(publicKeyType)) continue;
            return true;
        }
        return false;
    }

    public List<types.public_key_type> get_keys() {
        ArrayList<types.public_key_type> listKeyType = new ArrayList<types.public_key_type>();
        for (ArrayList key : this.key_auths) {
            Object pub;
            if (key.get(0).getClass() != types.public_key_type.class) {
                pub = (String)key.get(0);
                try {
                    key.set(0, new types.public_key_type((String)pub));
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            pub = (types.public_key_type)key.get(0);
            listKeyType.add((types.public_key_type)pub);
        }
        return listKeyType;
    }

    public void write_to_endcode(base_encoder baseEncoder) {
        raw_type rawObject = new raw_type();
        baseEncoder.write(rawObject.get_byte_array(this.weight_threshold));
        rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.account_auths.size()));
        for (ArrayList key : this.account_auths) {
            rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)((object_id)key.get(0)).get_instance()));
            Integer weight = (Integer)key.get(1);
            baseEncoder.write(rawObject.get_byte_array(weight.shortValue()));
        }
        rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.key_auths.size()));
        for (ArrayList key : this.key_auths) {
            Object pub;
            if (key.get(0).getClass() != types.public_key_type.class) {
                pub = (String)key.get(0);
                try {
                    key.set(0, new types.public_key_type((String)pub));
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            pub = (types.public_key_type)key.get(0);
            if (key.get(1).getClass() != Integer.class) {
                key.set(1, ((Double)key.get(1)).intValue());
            }
            Integer weight = (Integer)key.get(1);
            baseEncoder.write(((types.public_key_type)pub).key_data);
            baseEncoder.write(rawObject.get_byte_array(weight.shortValue()));
        }
        System.out.println("authority address_auths");
        rawObject.pack(baseEncoder, UnsignedInteger.fromIntBits((int)this.address_auths.size()));
    }

    public static class authority_type_deserializer
    implements JsonDeserializer<authority> {
        public authority deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            ArrayList<Object> account;
            JsonObject object = jsonElement.getAsJsonObject();
            authority authority2 = new authority();
            ArrayList account_auths = new ArrayList();
            try {
                JsonArray json_array = object.getAsJsonArray("account_auths");
                for (Object element : json_array) {
                    JsonArray json_item = element.getAsJsonArray();
                    account = new ArrayList<Object>();
                    account.add(object_id.create_from_string(json_item.get(0).getAsString()));
                    account.add(json_item.get(1).getAsInt());
                    account_auths.add(account);
                }
            }
            catch (Exception e) {
                JsonObject json_item = object.getAsJsonObject("account_auths");
                for (String key : json_item.keySet()) {
                    account = new ArrayList();
                    account.add(object_id.create_from_string(key));
                    account.add(json_item.getAsJsonPrimitive(key).getAsInt());
                    account_auths.add(account);
                }
            }
            ArrayList key_auths = new ArrayList();
            try {
                JsonArray json_array = object.getAsJsonArray("key_auths");
                for (JsonElement element : json_array) {
                    JsonArray json_item = element.getAsJsonArray();
                    ArrayList<Object> key = new ArrayList<Object>();
                    key.add(new types.public_key_type(json_item.get(0).getAsString()));
                    key.add(json_item.get(1).getAsInt());
                    key_auths.add(key);
                }
            }
            catch (Exception e) {
                JsonObject json_item = object.getAsJsonObject("key_auths");
                for (String key : json_item.keySet()) {
                    ArrayList<Object> account2 = new ArrayList<Object>();
                    try {
                        account2.add(new types.public_key_type(key));
                    }
                    catch (NoSuchAlgorithmException e1) {
                        e1.printStackTrace();
                    }
                    account2.add(json_item.getAsJsonPrimitive(key).getAsInt());
                    key_auths.add(account2);
                }
            }
            authority2.key_auths = key_auths;
            return authority2;
        }
    }
}

