/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.BitcoinSigner;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.IPrivateKeyRing;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.IPublicKeyRing;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PublicKey;
import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.CompactInt;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.model.OutputList;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInput;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptInputStandard;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutput;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutputP2SH;
import com.github.chouheiwa.wallet.socket.bitlib.model.ScriptOutputStandard;
import com.github.chouheiwa.wallet.socket.bitlib.model.Transaction;
import com.github.chouheiwa.wallet.socket.bitlib.model.TransactionInput;
import com.github.chouheiwa.wallet.socket.bitlib.model.TransactionOutput;
import com.github.chouheiwa.wallet.socket.bitlib.model.UnspentTransactionOutput;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.CoinUtil;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;

public class StandardTransactionBuilder {
    public static final int MAX_INPUT_SIZE = 148;
    private static final int OUTPUT_SIZE = 34;
    private NetworkParameters _network;
    private List<TransactionOutput> _outputs;

    public StandardTransactionBuilder(NetworkParameters network) {
        this._network = network;
        this._outputs = new LinkedList<TransactionOutput>();
    }

    public void addOutput(Address sendTo, long value) throws OutputTooSmallException {
        this.addOutput(StandardTransactionBuilder.createOutput(sendTo, value, this._network));
    }

    public void addOutput(TransactionOutput output) throws OutputTooSmallException {
        if (output.value < 5460L) {
            throw new OutputTooSmallException(output.value);
        }
        this._outputs.add(output);
    }

    public void addOutputs(OutputList outputs) throws OutputTooSmallException {
        for (TransactionOutput output : outputs) {
            if (output.value <= 0L) continue;
            this.addOutput(output);
        }
    }

    public static TransactionOutput createOutput(Address sendTo, long value, NetworkParameters network) {
        ScriptOutput script = sendTo.isMultisig(network) ? new ScriptOutputP2SH(sendTo.getTypeSpecificBytes()) : new ScriptOutputStandard(sendTo.getTypeSpecificBytes());
        return new TransactionOutput(value, script);
    }

    public static List<byte[]> generateSignatures(SigningRequest[] requests, IPrivateKeyRing keyRing) {
        LinkedList<byte[]> signatures = new LinkedList<byte[]>();
        for (SigningRequest request : requests) {
            BitcoinSigner signer = keyRing.findSignerByPublicKey(request.publicKey);
            if (signer == null) {
                throw new RuntimeException("Private key not found");
            }
            byte[] signature = signer.makeStandardBitcoinSignature(request.toSign);
            signatures.add(signature);
        }
        return signatures;
    }

    public UnsignedTransaction createUnsignedTransaction(Collection<UnspentTransactionOutput> inventory, Address changeAddress, IPublicKeyRing keyRing, NetworkParameters network, long minerFeeToUse) throws InsufficientFundsException, UnableToBuildTransactionException {
        LinkedList<UnspentTransactionOutput> unspent = new LinkedList<UnspentTransactionOutput>(inventory);
        FifoCoinSelector coinSelector = new FifoCoinSelector(minerFeeToUse, unspent);
        long fee = coinSelector.getFee();
        long outputSum = coinSelector.getOutputSum();
        List<UnspentTransactionOutput> funding = this.pruneRedundantOutputs(coinSelector.getFundings(), fee + outputSum);
        boolean needChangeOutputInEstimation = this.needChangeOutputInEstimation(funding, outputSum, minerFeeToUse);
        int outputsSizeInFeeEstimation = this._outputs.size();
        if (needChangeOutputInEstimation) {
            ++outputsSizeInFeeEstimation;
        }
        fee = StandardTransactionBuilder.estimateFee(funding.size(), outputsSizeInFeeEstimation, minerFeeToUse);
        long found = 0L;
        for (UnspentTransactionOutput output : funding) {
            found += output.value;
        }
        long toSend = fee + outputSum;
        if (changeAddress == null) {
            changeAddress = this.getRichest(funding, network);
        }
        long change = found - toSend;
        LinkedList<TransactionOutput> outputs = new LinkedList<TransactionOutput>(this._outputs);
        if (change >= 5460L) {
            TransactionOutput changeOutput = StandardTransactionBuilder.createOutput(changeAddress, change, this._network);
            int position = new Random().nextInt(outputs.size() + 1);
            outputs.add(position, changeOutput);
        }
        UnsignedTransaction unsignedTransaction = new UnsignedTransaction(outputs, funding, keyRing, network);
        int estimateTransactionSize = StandardTransactionBuilder.estimateTransactionSize(unsignedTransaction.getFundingOutputs().length, unsignedTransaction.getOutputs().length);
        long calculatedFee = unsignedTransaction.calculateFee();
        float estimatedFeePerKb = (long)((float)calculatedFee / ((float)estimateTransactionSize / 1000.0f));
        if (estimatedFeePerKb > 2.0E7f) {
            throw new UnableToBuildTransactionException(String.format(Locale.getDefault(), "Unreasonable high transaction fee of %s sat/1000Byte on a %d Bytes tx. Fee: %d sat, Suggested fee: %d sat", Float.valueOf(estimatedFeePerKb), estimateTransactionSize, calculatedFee, minerFeeToUse));
        }
        return unsignedTransaction;
    }

    private boolean needChangeOutputInEstimation(List<UnspentTransactionOutput> funding, long outputSum, long minerFeeToUse) {
        long fee = StandardTransactionBuilder.estimateFee(funding.size(), this._outputs.size(), minerFeeToUse);
        long found = 0L;
        for (UnspentTransactionOutput output : funding) {
            found += output.value;
        }
        long toSend = fee + outputSum;
        long change = found - toSend;
        return change >= 5460L;
    }

    private List<UnspentTransactionOutput> pruneRedundantOutputs(List<UnspentTransactionOutput> funding, long outputSum) {
        List largestToSmallest = Ordering.natural().reverse().onResultOf((Function)new Function<UnspentTransactionOutput, Comparable>(){

            public Comparable apply(UnspentTransactionOutput input) {
                return Long.valueOf(input.value);
            }
        }).sortedCopy(funding);
        long target = 0L;
        for (int i = 0; i < largestToSmallest.size(); ++i) {
            UnspentTransactionOutput output = (UnspentTransactionOutput)largestToSmallest.get(i);
            if ((target += output.value) < outputSum) continue;
            List<UnspentTransactionOutput> ret = largestToSmallest.subList(0, i + 1);
            Collections.shuffle(ret);
            return ret;
        }
        return largestToSmallest;
    }

    @VisibleForTesting
    Address getRichest(Collection<UnspentTransactionOutput> unspent, final NetworkParameters network) {
        Preconditions.checkArgument((!unspent.isEmpty() ? 1 : 0) != 0);
        Function<UnspentTransactionOutput, Address> txout2Address = new Function<UnspentTransactionOutput, Address>(){

            public Address apply(UnspentTransactionOutput input) {
                return input.script.getAddress(network);
            }
        };
        ImmutableListMultimap index = Multimaps.index(unspent, (Function)txout2Address);
        Address ret = this.getRichest((Multimap<Address, UnspentTransactionOutput>)index);
        return (Address)Preconditions.checkNotNull((Object)ret);
    }

    private Address getRichest(Multimap<Address, UnspentTransactionOutput> index) {
        Address ret = null;
        long maxSum = 0L;
        for (Address address2 : index.keys()) {
            Collection unspentTransactionOutputs = index.get((Object)address2);
            long newSum = this.sum(unspentTransactionOutputs);
            if (newSum <= maxSum) continue;
            ret = address2;
            maxSum = newSum;
        }
        return ret;
    }

    private long sum(Iterable<UnspentTransactionOutput> outputs) {
        long sum = 0L;
        for (UnspentTransactionOutput output : outputs) {
            sum += output.value;
        }
        return sum;
    }

    public static Transaction finalizeTransaction(UnsignedTransaction unsigned, List<byte[]> signatures) {
        TransactionInput[] inputs = new TransactionInput[unsigned._funding.length];
        for (int i = 0; i < unsigned._funding.length; ++i) {
            ScriptInputStandard script = new ScriptInputStandard(signatures.get(i), ((UnsignedTransaction)unsigned)._signingRequests[i].publicKey.getPublicKeyBytes());
            inputs[i] = new TransactionInput(((UnsignedTransaction)unsigned)._funding[i].outPoint, script, unsigned.getDefaultSequenceNumber());
        }
        return new Transaction(1, inputs, unsigned._outputs, unsigned.getLockTime());
    }

    private UnspentTransactionOutput extractOldest(Collection<UnspentTransactionOutput> unspent) {
        int minHeight = Integer.MAX_VALUE;
        UnspentTransactionOutput oldest = null;
        for (UnspentTransactionOutput output : unspent) {
            int height;
            if (!(output.script instanceof ScriptOutputStandard) || (height = output.height > 0 ? output.height : 0x7FFFFFFE) >= minHeight) continue;
            minHeight = height;
            oldest = output;
        }
        if (oldest == null) {
            return null;
        }
        unspent.remove(oldest);
        return oldest;
    }

    private long outputSum() {
        long sum = 0L;
        for (TransactionOutput output : this._outputs) {
            sum += output.value;
        }
        return sum;
    }

    private static Sha256Hash hashTransaction(Transaction t) {
        ByteWriter writer = new ByteWriter(1024);
        t.toByteWriter(writer);
        int hashType = 1;
        writer.putIntLE(hashType);
        return HashUtils.doubleSha256(writer.toBytes());
    }

    public static int estimateTransactionSize(int inputs, int outputs) {
        int estimate = 0;
        estimate += 4;
        estimate += CompactInt.toBytes(inputs).length;
        estimate += 148 * inputs;
        estimate += CompactInt.toBytes(outputs).length;
        estimate += 34 * outputs;
        return estimate += 4;
    }

    public static long estimateFee(int inputs, int outputs, long minerFeePerKb) {
        float txSizeKb = (float)((double)StandardTransactionBuilder.estimateTransactionSize(inputs, outputs) / 1000.0);
        return (long)(txSizeKb * (float)minerFeePerKb);
    }

    private class FifoCoinSelector
    implements CoinSelector {
        private List<UnspentTransactionOutput> allFunding = new LinkedList<UnspentTransactionOutput>();
        private long feeSat;
        private long outputSum;

        public FifoCoinSelector(long feeSatPerKb, List<UnspentTransactionOutput> unspent) throws InsufficientFundsException {
            UnspentTransactionOutput unspentTransactionOutput;
            this.feeSat = StandardTransactionBuilder.estimateFee(unspent.size(), 1, feeSatPerKb);
            this.outputSum = StandardTransactionBuilder.this.outputSum();
            for (long foundSat = 0L; foundSat < this.feeSat + this.outputSum; foundSat += unspentTransactionOutput.value) {
                unspentTransactionOutput = StandardTransactionBuilder.this.extractOldest(unspent);
                if (unspentTransactionOutput == null) {
                    throw new InsufficientFundsException(this.outputSum, this.feeSat);
                }
                this.allFunding.add(unspentTransactionOutput);
                this.feeSat = StandardTransactionBuilder.estimateFee(this.allFunding.size(), StandardTransactionBuilder.this.needChangeOutputInEstimation(this.allFunding, this.outputSum, feeSatPerKb) ? StandardTransactionBuilder.this._outputs.size() + 1 : StandardTransactionBuilder.this._outputs.size(), feeSatPerKb);
            }
        }

        @Override
        public List<UnspentTransactionOutput> getFundings() {
            return this.allFunding;
        }

        @Override
        public long getFee() {
            return this.feeSat;
        }

        @Override
        public long getOutputSum() {
            return this.outputSum;
        }
    }

    private static interface CoinSelector {
        public List<UnspentTransactionOutput> getFundings();

        public long getFee();

        public long getOutputSum();
    }

    public static class UnsignedTransaction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int NO_SEQUENCE = -1;
        private TransactionOutput[] _outputs;
        private UnspentTransactionOutput[] _funding;
        private SigningRequest[] _signingRequests;
        private NetworkParameters _network;

        public TransactionOutput[] getOutputs() {
            return this._outputs;
        }

        public UnspentTransactionOutput[] getFundingOutputs() {
            return this._funding;
        }

        public UnsignedTransaction(List<TransactionOutput> outputs, List<UnspentTransactionOutput> funding, IPublicKeyRing keyRing, NetworkParameters network) {
            this._network = network;
            this._outputs = outputs.toArray(new TransactionOutput[outputs.size()]);
            this._funding = funding.toArray(new UnspentTransactionOutput[funding.size()]);
            this._signingRequests = new SigningRequest[this._funding.length];
            TransactionInput[] inputs = new TransactionInput[this._funding.length];
            for (int i = 0; i < this._funding.length; ++i) {
                inputs[i] = new TransactionInput(this._funding[i].outPoint, ScriptInput.EMPTY, this.getDefaultSequenceNumber());
            }
            Transaction transaction2 = new Transaction(1, inputs, this._outputs, this.getLockTime());
            for (int i = 0; i < this._funding.length; ++i) {
                UnspentTransactionOutput f = this._funding[i];
                if (!(f.script instanceof ScriptOutputStandard)) {
                    throw new RuntimeException("Unsupported script");
                }
                byte[] addressBytes = ((ScriptOutputStandard)f.script).getAddressBytes();
                Address address2 = Address.fromStandardBytes(addressBytes, this._network);
                PublicKey publicKey = keyRing.findPublicKeyByAddress(address2);
                if (publicKey == null) {
                    throw new RuntimeException("Public key not found");
                }
                inputs[i].script = ScriptInput.fromOutputScript(this._funding[i].script);
                Sha256Hash hash = StandardTransactionBuilder.hashTransaction(transaction2);
                inputs[i] = new TransactionInput(this._funding[i].outPoint, ScriptInput.EMPTY);
                this._signingRequests[i] = new SigningRequest(publicKey, hash);
            }
        }

        public SigningRequest[] getSignatureInfo() {
            return this._signingRequests;
        }

        public long calculateFee() {
            long in = 0L;
            long out = 0L;
            for (UnspentTransactionOutput unspentTransactionOutput : this._funding) {
                in += unspentTransactionOutput.value;
            }
            for (Serializable serializable : this._outputs) {
                out += ((TransactionOutput)serializable).value;
            }
            return in - out;
        }

        public int getLockTime() {
            return 0;
        }

        public int getDefaultSequenceNumber() {
            return -1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String fee = CoinUtil.valueString(this.calculateFee(), false);
            sb.append(String.format("Fee: %s", fee)).append('\n');
            int max = Math.max(this._funding.length, this._outputs.length);
            for (int i = 0; i < max; ++i) {
                TransactionOutput out;
                UnspentTransactionOutput in = i < this._funding.length ? this._funding[i] : null;
                TransactionOutput transactionOutput = out = i < this._outputs.length ? this._outputs[i] : null;
                String line = in != null && out != null ? String.format("%36s %13s -> %36s %13s", this.getAddress(in.script, this._network), this.getValue(in.value), this.getAddress(out.script, this._network), this.getValue(out.value)) : (in != null ? String.format("%36s %13s    %36s %13s", this.getAddress(in.script, this._network), this.getValue(in.value), "", "") : (out != null ? String.format("%36s %13s    %36s %13s", "", "", this.getAddress(out.script, this._network), this.getValue(out.value)) : ""));
                sb.append(line).append('\n');
            }
            return sb.toString();
        }

        private String getAddress(ScriptOutput script, NetworkParameters network) {
            Address address2 = script.getAddress(network);
            if (address2 == null) {
                return "Unknown";
            }
            return address2.toString();
        }

        private String getValue(Long value) {
            return String.format("(%s)", CoinUtil.valueString(value, false));
        }
    }

    public static class SigningRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public PublicKey publicKey;
        public Sha256Hash toSign;

        public SigningRequest(PublicKey publicKey, Sha256Hash toSign) {
            this.publicKey = publicKey;
            this.toSign = toSign;
        }
    }

    public static class UnableToBuildTransactionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnableToBuildTransactionException(String msg) {
            super(msg);
        }
    }

    public static class OutputTooSmallException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public long value;

        public OutputTooSmallException(long value) {
            super("An output was added with a value of " + value + " satoshis, which is smaller than the minimum accepted by the Bitcoin network");
        }
    }

    public static class InsufficientFundsException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public long sending;
        public long fee;

        public InsufficientFundsException(long sending, long fee) {
            super("Insufficient funds to send " + sending + " satoshis with fee " + fee);
            this.sending = sending;
            this.fee = fee;
        }
    }
}

