/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib;

import com.github.chouheiwa.wallet.socket.bitlib.model.Transaction;
import com.github.chouheiwa.wallet.socket.bitlib.model.TransactionOutput;
import com.github.chouheiwa.wallet.socket.bitlib.model.UnspentTransactionOutput;
import java.io.Serializable;

public class TransactionUtils {
    public static final long INCLUDE_IN_BLOCK_FEE = 1000L;
    public static final long MINIMUM_KB_FEE = 1000L;
    public static final long DEFAULT_KB_FEE = 100000L;
    public static final long MINIMUM_OUTPUT_VALUE = 5460L;

    public static boolean hasInSufficientFees(Transaction tx, UnspentTransactionOutput[] funding, long minerFeeToUse) {
        int txSize = tx.toBytes().length;
        return TransactionUtils.calculateFeePaid(tx, funding) < TransactionUtils.calculateFeeRequired(txSize, minerFeeToUse);
    }

    public static long calculateFeeRequired(int txSize, long minerFeeToUse) {
        return (long)(1 + txSize / 1000) * minerFeeToUse;
    }

    private static long calculateFeePaid(Transaction tx, UnspentTransactionOutput[] funding) {
        long fee = 0L;
        for (UnspentTransactionOutput unspentTransactionOutput : funding) {
            fee += unspentTransactionOutput.value;
        }
        for (Serializable serializable : tx.outputs) {
            fee -= ((TransactionOutput)serializable).value;
        }
        return fee;
    }
}

