/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.Rijndael.Rijndael;
import com.github.chouheiwa.wallet.socket.bitlib.bitcoinj.Base58;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.InMemoryPrivateKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Parameters;
import com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto.SCrypt;
import com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto.SCryptProgress;
import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;

public class Bip38 {
    public static final String BIP38_CHARACTER_ENCODING = "UTF-8";
    public static final int SCRYPT_N = 16384;
    public static final int SCRYPT_LOG2_N = 14;
    public static final int SCRYPT_R = 8;
    public static final int SCRYPT_P = 8;
    public static final int SCRYPT_LENGTH = 64;

    public static String encryptNoEcMultiply(String passphrase, String base58EncodedPrivateKey, SCryptProgress progressTracker, NetworkParameters network) throws InterruptedException {
        InMemoryPrivateKey key = new InMemoryPrivateKey(base58EncodedPrivateKey, NetworkParameters.productionNetwork);
        Address address2 = key.getPublicKey().toAddress(NetworkParameters.productionNetwork);
        byte[] salt = Bip38.calculateScryptSalt(address2);
        byte[] stretchedKeyMaterial = Bip38.bip38Stretch1(passphrase, salt, progressTracker, 64);
        return Bip38.encryptNoEcMultiply(stretchedKeyMaterial, key, salt);
    }

    public static byte[] bip38Stretch1(String passphrase, byte[] salt, SCryptProgress progressTracker, int outputSize) throws InterruptedException {
        try {
            byte[] derived = SCrypt.scrypt(passphrase.getBytes(BIP38_CHARACTER_ENCODING), salt, 16384, 8, 8, outputSize, progressTracker);
            return derived;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptNoEcMultiply(byte[] stretcedKeyMaterial, InMemoryPrivateKey key, byte[] salt) {
        int checksumLength = 4;
        byte[] encoded = new byte[39 + checksumLength];
        int index = 0;
        encoded[index++] = 1;
        encoded[index++] = 66;
        int non_EC_multiplied = -64;
        int compressedPublicKey = key.getPublicKey().isCompressed() ? 32 : 0;
        encoded[index++] = (byte)(non_EC_multiplied | compressedPublicKey);
        System.arraycopy(salt, 0, encoded, index, salt.length);
        index += salt.length;
        byte[] derivedHalf1 = new byte[32];
        System.arraycopy(stretcedKeyMaterial, 0, derivedHalf1, 0, 32);
        byte[] derivedHalf2 = new byte[32];
        System.arraycopy(stretcedKeyMaterial, 32, derivedHalf2, 0, 32);
        Rijndael aes2 = new Rijndael();
        aes2.makeKey(derivedHalf2, 256);
        byte[] complete = key.getPrivateKeyBytes();
        byte[] toEncryptPart1 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            toEncryptPart1[i] = (byte)(complete[i] & 0xFF ^ derivedHalf1[i] & 0xFF);
        }
        byte[] encryptedHalf1 = new byte[16];
        aes2.encrypt(toEncryptPart1, encryptedHalf1);
        System.arraycopy(encryptedHalf1, 0, encoded, index, encryptedHalf1.length);
        index += encryptedHalf1.length;
        byte[] toEncryptPart2 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            toEncryptPart2[i] = (byte)(complete[16 + i] & 0xFF ^ derivedHalf1[16 + i] & 0xFF);
        }
        byte[] encryptedHalf2 = new byte[16];
        aes2.encrypt(toEncryptPart2, encryptedHalf2);
        System.arraycopy(encryptedHalf2, 0, encoded, index, encryptedHalf2.length);
        index += encryptedHalf2.length;
        Sha256Hash checkSum = HashUtils.doubleSha256(encoded, 0, 39);
        byte[] start = checkSum.firstFourBytes();
        System.arraycopy(start, 0, encoded, 39, checksumLength);
        String result = Base58.encode(encoded);
        return result;
    }

    public static boolean isBip38PrivateKey(String bip38PrivateKey) {
        return Bip38.parseBip38PrivateKey(bip38PrivateKey) != null;
    }

    public static Bip38PrivateKey parseBip38PrivateKey(String bip38PrivateKey) {
        boolean lotSequence;
        boolean ecMultiply;
        byte[] decoded = Base58.decodeChecked(bip38PrivateKey);
        if (decoded == null) {
            return null;
        }
        if (decoded.length != 39) {
            return null;
        }
        int index = 0;
        if (decoded[index++] != 1) {
            return null;
        }
        if (decoded[index] == 66) {
            ecMultiply = false;
        } else if (decoded[index] == 67) {
            ecMultiply = true;
        } else {
            return null;
        }
        int n = ++index;
        ++index;
        int flags = decoded[n] & 0xFF;
        if (ecMultiply) {
            if ((flags | 0x24) != 36) {
                return null;
            }
            lotSequence = (flags & 4) != 0;
        } else {
            if ((flags | 0xE0) != 224) {
                return null;
            }
            if ((flags & 0xC0) != 192) {
                return null;
            }
            lotSequence = false;
        }
        boolean compressed = (flags & 0x20) != 0;
        byte[] salt = new byte[]{decoded[index++], decoded[index++], decoded[index++], decoded[index++]};
        byte[] data = new byte[32];
        System.arraycopy(decoded, index, data, 0, data.length);
        index += data.length;
        return new Bip38PrivateKey(ecMultiply, compressed, lotSequence, salt, data);
    }

    public static String decrypt(String bip38PrivateKeyString, String passphrase, SCryptProgress progressTracker, NetworkParameters network) throws InterruptedException {
        Bip38PrivateKey bip38Key = Bip38.parseBip38PrivateKey(bip38PrivateKeyString);
        if (bip38Key == null) {
            return null;
        }
        if (bip38Key.ecMultiply) {
            return Bip38.decryptEcMultiply(bip38Key, passphrase, progressTracker, network);
        }
        byte[] stretcedKeyMaterial = Bip38.bip38Stretch1(passphrase, bip38Key.salt, progressTracker, 64);
        return Bip38.decryptNoEcMultiply(bip38Key, stretcedKeyMaterial, network);
    }

    public static String decryptEcMultiply(Bip38PrivateKey bip38Key, String passphrase, SCryptProgress progressTracker, NetworkParameters network) throws InterruptedException {
        byte[] derived;
        byte[] ownerEntropy = new byte[8];
        System.arraycopy(bip38Key.data, 0, ownerEntropy, 0, 8);
        byte[] ownerSalt = ownerEntropy;
        if (bip38Key.lotSequence) {
            ownerSalt = new byte[4];
            System.arraycopy(ownerEntropy, 0, ownerSalt, 0, 4);
        }
        byte[] passFactor = Bip38.bip38Stretch1(passphrase, ownerSalt, progressTracker, 32);
        if (bip38Key.lotSequence) {
            byte[] tmp = new byte[40];
            System.arraycopy(passFactor, 0, tmp, 0, 32);
            System.arraycopy(ownerEntropy, 0, tmp, 32, 8);
            passFactor = HashUtils.doubleSha256(tmp).getBytes();
        }
        InMemoryPrivateKey key = new InMemoryPrivateKey(passFactor, true);
        byte[] passPoint = key.getPublicKey().getPublicKeyBytes();
        byte[] encryptedPart1 = new byte[16];
        System.arraycopy(bip38Key.data, 8, encryptedPart1, 0, 8);
        byte[] encryptedPart2 = new byte[16];
        System.arraycopy(bip38Key.data, 16, encryptedPart2, 0, 16);
        byte[] saltPlusOwnerSalt = new byte[12];
        System.arraycopy(bip38Key.salt, 0, saltPlusOwnerSalt, 0, 4);
        System.arraycopy(ownerEntropy, 0, saltPlusOwnerSalt, 4, 8);
        try {
            derived = SCrypt.scrypt(passPoint, saltPlusOwnerSalt, 1024, 1, 1, 64, null);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        byte[] derivedQuater1 = new byte[16];
        System.arraycopy(derived, 0, derivedQuater1, 0, 16);
        byte[] derivedQuater2 = new byte[16];
        System.arraycopy(derived, 16, derivedQuater2, 0, 16);
        byte[] derivedHalf2 = new byte[32];
        System.arraycopy(derived, 32, derivedHalf2, 0, 32);
        Rijndael aes2 = new Rijndael();
        aes2.makeKey(derivedHalf2, 256);
        byte[] unencryptedPart2 = new byte[16];
        aes2.decrypt(encryptedPart2, unencryptedPart2);
        Bip38.xorBytes(derivedQuater2, unencryptedPart2);
        System.arraycopy(unencryptedPart2, 0, encryptedPart1, 8, 8);
        byte[] unencryptedPart1 = new byte[16];
        aes2.decrypt(encryptedPart1, unencryptedPart1);
        Bip38.xorBytes(derivedQuater1, unencryptedPart1);
        byte[] seedB = new byte[24];
        System.arraycopy(unencryptedPart1, 0, seedB, 0, 16);
        System.arraycopy(unencryptedPart2, 8, seedB, 16, 8);
        Sha256Hash factorB = HashUtils.doubleSha256(seedB);
        BigInteger privateKey = new BigInteger(1, passFactor).multiply(factorB.toPositiveBigInteger()).mod(Parameters.n);
        byte[] keyBytes = new byte[32];
        byte[] bytes = privateKey.toByteArray();
        if (bytes.length <= keyBytes.length) {
            System.arraycopy(bytes, 0, keyBytes, keyBytes.length - bytes.length, bytes.length);
        } else {
            assert (bytes.length == 33 && bytes[0] == 0);
            System.arraycopy(bytes, 1, keyBytes, 0, bytes.length - 1);
        }
        InMemoryPrivateKey finalKey = new InMemoryPrivateKey(keyBytes, bip38Key.compressed);
        Address address2 = finalKey.getPublicKey().toAddress(network);
        byte[] newSalt = Bip38.calculateScryptSalt(address2);
        if (!BitUtils.areEqual(bip38Key.salt, newSalt)) {
            return null;
        }
        return finalKey.getBase58EncodedPrivateKey(network);
    }

    public static String decryptNoEcMultiply(Bip38PrivateKey bip38Key, byte[] stretcedKeyMaterial, NetworkParameters network) {
        byte[] derivedHalf1 = new byte[32];
        System.arraycopy(stretcedKeyMaterial, 0, derivedHalf1, 0, 32);
        byte[] derivedHalf2 = new byte[32];
        System.arraycopy(stretcedKeyMaterial, 32, derivedHalf2, 0, 32);
        Rijndael aes2 = new Rijndael();
        aes2.makeKey(derivedHalf2, 256);
        byte[] encryptedHalf1 = new byte[16];
        System.arraycopy(bip38Key.data, 0, encryptedHalf1, 0, encryptedHalf1.length);
        byte[] encryptedHalf2 = new byte[16];
        System.arraycopy(bip38Key.data, 16, encryptedHalf2, 0, encryptedHalf2.length);
        byte[] decryptedHalf1 = new byte[16];
        aes2.decrypt(encryptedHalf1, decryptedHalf1);
        byte[] decryptedHalf2 = new byte[16];
        aes2.decrypt(encryptedHalf2, decryptedHalf2);
        byte[] complete = new byte[32];
        for (int i = 0; i < 16; ++i) {
            complete[i] = (byte)(decryptedHalf1[i] & 0xFF ^ derivedHalf1[i] & 0xFF);
            complete[i + 16] = (byte)(decryptedHalf2[i] & 0xFF ^ derivedHalf1[i + 16] & 0xFF);
        }
        InMemoryPrivateKey key = new InMemoryPrivateKey(complete, bip38Key.compressed);
        Address address2 = key.getPublicKey().toAddress(network);
        byte[] newSalt = Bip38.calculateScryptSalt(address2);
        if (!BitUtils.areEqual(bip38Key.salt, newSalt)) {
            return null;
        }
        String result = key.getBase58EncodedPrivateKey(network);
        return result;
    }

    public static SCryptProgress getScryptProgressTracker() {
        return new SCryptProgress(16384, 8, 8);
    }

    public static byte[] calculateScryptSalt(Address address2) {
        Sha256Hash hash = HashUtils.doubleSha256(address2.toString().getBytes());
        return hash.firstFourBytes();
    }

    private static void xorBytes(byte[] toApply, byte[] target) {
        if (toApply.length != target.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < toApply.length; ++i) {
            target[i] = (byte)(target[i] ^ toApply[i]);
        }
    }

    public static class Bip38PrivateKey {
        public boolean ecMultiply;
        public boolean compressed;
        public boolean lotSequence;
        public byte[] salt;
        public byte[] data;

        public Bip38PrivateKey(boolean ecMultiply, boolean compressed, boolean lotSequence, byte[] salt, byte[] data) {
            this.ecMultiply = ecMultiply;
            this.compressed = compressed;
            this.lotSequence = lotSequence;
            this.salt = salt;
            this.data = data;
        }
    }
}

