/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.bitcoinj.Base58;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.Gf256;
import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class BipSss {
    private static final int TYPE_BASE_58_STRING = 19;

    public static String combine(Collection<Share> shares) throws IncompatibleSharesException, NotEnoughSharesException, InvalidContentTypeException {
        Collection<Share> unique;
        if (shares.size() == 0) {
            throw new NotEnoughSharesException(1);
        }
        Iterator<Share> it = shares.iterator();
        Share firstShare = it.next();
        while (it.hasNext()) {
            Share share = it.next();
            if (share.isCompatible(firstShare)) continue;
            throw new IncompatibleSharesException();
        }
        if (firstShare.contentType != 19) {
            throw new InvalidContentTypeException();
        }
        int threshold = unique.iterator().next().threshold;
        unique = Share.removeDuplicateIndexes(shares);
        if (threshold > unique.size()) {
            throw new NotEnoughSharesException(threshold - unique.size());
        }
        ArrayList<Share> selection = new ArrayList<Share>();
        it = unique.iterator();
        while (it.hasNext()) {
            selection.add(it.next());
            if (selection.size() != threshold) continue;
        }
        Gf256 gf = new Gf256();
        ArrayList<Gf256.Share> gfShares = new ArrayList<Gf256.Share>();
        for (Share s : selection) {
            gfShares.add(new Gf256.Share((byte)s.shareNumber, s.shareData));
        }
        byte[] content = gf.combineShares(gfShares);
        return Base58.encodeWithChecksum(content);
    }

    public static class Share
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String SSS_PREFIX = "SSS-";
        public final byte[] id;
        public final int contentType;
        public final int shareNumber;
        public final int threshold;
        public final byte[] shareData;

        private Share(int contentType, byte[] id, int shareNumber, int threshold, byte[] shareData) {
            this.id = id;
            this.contentType = contentType;
            this.shareNumber = shareNumber;
            this.threshold = threshold;
            this.shareData = shareData;
        }

        public String toString() {
            ByteWriter w = new ByteWriter(1024);
            w.put((byte)this.contentType);
            w.putBytes(this.id);
            w.put(this.getByteForNumberAndThreshold(this.shareNumber, this.threshold));
            w.putBytes(this.shareData);
            String base58 = Base58.encodeWithChecksum(w.toBytes());
            return SSS_PREFIX + base58;
        }

        private byte getByteForNumberAndThreshold(int shareNumber, int threshold) {
            int number = (shareNumber - 1) * 16 + (threshold - 1);
            return (byte)number;
        }

        public static Share fromString(String encodedShare) {
            byte[] decoded;
            if (encodedShare.startsWith(SSS_PREFIX)) {
                encodedShare = encodedShare.substring(SSS_PREFIX.length());
            }
            if ((decoded = Base58.decodeChecked(encodedShare)) == null || decoded.length < 4) {
                return null;
            }
            ByteReader reader = new ByteReader(decoded);
            try {
                byte contentByte = reader.get();
                byte[] id = reader.getBytes(2);
                byte numberAndThreshold = reader.get();
                byte[] content = reader.getBytes(reader.available());
                return new Share(Share.b2i(contentByte), id, Share.getShareNumber(numberAndThreshold), Share.getThreshold(numberAndThreshold), content);
            }
            catch (ByteReader.InsufficientBytesException e) {
                return null;
            }
        }

        private static int getThreshold(byte numberAndThreshold) {
            return Share.b2i(numberAndThreshold) / 16 + 1;
        }

        private static int getShareNumber(byte numberAndThreshold) {
            return Share.b2i(numberAndThreshold) % 16 + 1;
        }

        public boolean isCompatible(Share share) {
            if (this.contentType != share.contentType) {
                return false;
            }
            if (!BitUtils.areEqual(this.id, share.id)) {
                return false;
            }
            return this.threshold == share.threshold;
        }

        public static Collection<Share> removeDuplicateIndexes(Collection<Share> shares) {
            HashMap<Integer, Share> map = new HashMap<Integer, Share>();
            for (Share share : shares) {
                map.put(share.shareNumber, share);
            }
            return map.values();
        }

        private static int b2i(byte b) {
            return b & 0xFF;
        }
    }

    public static class IncompatibleSharesException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidContentTypeException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class NotEnoughSharesException
    extends Exception {
        public int needed;
        private static final long serialVersionUID = 1L;

        public NotEnoughSharesException(int needed) {
            this.needed = needed;
        }
    }
}

