/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.InMemoryPrivateKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PublicKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.EcTools;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Point;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import java.math.BigInteger;

public class Ecdh {
    public static final int SECRET_LENGTH = 32;

    public static byte[] calculateSharedSecret(PublicKey foreignPublicKey, InMemoryPrivateKey privateKey) {
        Point P = Ecdh.calculateSharedSecretPoint(foreignPublicKey, privateKey);
        BigInteger Px = P.getX().toBigInteger();
        byte[] bytes = EcTools.integerToBytes(Px, 32);
        return HashUtils.sha256(bytes).getBytes();
    }

    private static Point calculateSharedSecretPoint(PublicKey foreignPublicKey, InMemoryPrivateKey privateKey) {
        BigInteger pk = new BigInteger(1, privateKey.getPrivateKeyBytes());
        Point P = foreignPublicKey.getQ().multiply(pk);
        return P;
    }
}

