/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class Gf256 {
    public static final int DEFAULT_POLYNOMIAL = 285;
    private int[] _logTable = new int[256];
    private int[] _expTable = new int[256];
    private static final int INFINITY = 255;

    public Gf256() {
        this(285);
    }

    public Gf256(int polynomial) {
        this._logTable = new int[256];
        this._expTable = new int[256];
        int b = 1;
        for (int i = 0; i < 255; ++i) {
            this._logTable[b] = i;
            this._expTable[i] = b;
            if (((b <<= 1) & 0x100) <= 0) continue;
            b ^= polynomial;
        }
        this._logTable[0] = -1;
        this._expTable[255] = 0;
        Preconditions.checkState((b == 1 ? 1 : 0) != 0);
    }

    private final int log(int n) {
        return this._logTable[n];
    }

    private final int exp(int n) {
        return this._expTable[n];
    }

    private final byte[] add(byte[] a, byte[] b) {
        Preconditions.checkState((a.length == b.length ? 1 : 0) != 0);
        byte[] c = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = this.add(a[i], b[i]);
        }
        return c;
    }

    private final byte add(byte a, byte b) {
        return (byte)(a ^ b);
    }

    private final byte sub(byte a, byte b) {
        return this.add(a, b);
    }

    private byte[] mul(byte[] a, byte[] b) {
        Preconditions.checkState((a.length == b.length ? 1 : 0) != 0);
        byte[] c = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = this.mul(a[i], b[i]);
        }
        return c;
    }

    private final byte mul(byte a, byte b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        int lp = this.mod255(this.log(this.b2i(a)) + this.log(this.b2i(b)));
        return (byte)this.exp(lp);
    }

    private final byte div(byte a, byte b) {
        if (b == 0) {
            throw new RuntimeException("Division by zero");
        }
        if (a == 0) {
            return 0;
        }
        int lp = this.mod255(this.log(this.b2i(a)) - this.log(this.b2i(b)));
        return (byte)this.exp(lp);
    }

    private int mod255(int n) {
        return n % 255 + (n < 0 ? 255 : 0);
    }

    private final int b2i(byte b) {
        return b & 0xFF;
    }

    private byte[][] sha256Coefficients(byte[] secret, int m) {
        byte[][] res = new byte[m][];
        byte[] coeff = BitUtils.copyByteArray(secret);
        res[0] = coeff;
        for (int n = 1; n < m; ++n) {
            ByteWriter writer = new ByteWriter(coeff.length + 32);
            for (int i = 0; i < coeff.length; i += 32) {
                int toHash = Math.min(32, coeff.length - i);
                writer.putBytes(HashUtils.sha256(coeff, i, toHash).getBytes());
            }
            coeff = BitUtils.copyOf(writer.toBytes(), coeff.length);
            res[n] = coeff;
        }
        return res;
    }

    private Share makeShare(byte x, byte[][] coeff) {
        Preconditions.checkArgument((x != 0 ? 1 : 0) != 0);
        int q = coeff[0].length;
        byte[] s = coeff[0];
        byte xpow = 1;
        for (int i = 1; i < coeff.length; ++i) {
            xpow = this.mul(xpow, x);
            s = this.add(s, this.mul(Gf256.byteArrayOf(xpow, q), coeff[i]));
        }
        return new Share(x, s);
    }

    public byte[] combineShares(List<Share> shares) {
        int m = shares.size();
        Preconditions.checkArgument((m > 0 ? 1 : 0) != 0);
        int q = shares.get((int)0).data.length;
        byte n = 1;
        for (Share share : shares) {
            n = this.mul(n, share.index);
        }
        byte[] a = new byte[q];
        for (Share share : shares) {
            byte lc = this.div(n, share.index);
            for (Share otherShare : shares) {
                if (otherShare.index == share.index) continue;
                lc = this.div(lc, this.sub(otherShare.index, share.index));
            }
            a = this.add(a, this.mul(share.data, Gf256.byteArrayOf(lc, q)));
        }
        return a;
    }

    private static final byte[] byteArrayOf(byte b, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = b;
        }
        return result;
    }

    public List<Share> makeShares(byte[] secret, int threshold, int shares) {
        Preconditions.checkArgument((shares > 0 ? 1 : 0) != 0, (Object)"Number of shares must be larger than zero");
        Preconditions.checkArgument((threshold <= shares ? 1 : 0) != 0, (Object)"Number of shares needed must be less than or equal to the number of shares");
        byte[][] coeff = this.sha256Coefficients(secret, threshold);
        ArrayList<Share> shareList = new ArrayList<Share>(shares);
        for (int i = 0; i < shares; ++i) {
            shareList.add(this.makeShare((byte)(i + 1), coeff));
        }
        return shareList;
    }

    public static class Share {
        public final byte index;
        public final byte[] data;

        public Share(byte index, byte[] data) {
            this.index = index;
            this.data = data;
        }
    }
}

