/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.Hmac;
import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class HmacPRNG
extends SecureRandom {
    private static final long serialVersionUID = 5678497558585271430L;
    private int _nonce;
    private byte[] _key;
    private byte[] _randomBuffer;
    private int _index;

    public HmacPRNG(byte[] seed) throws NoSuchAlgorithmException {
        this._key = seed;
        this._nonce = 1;
        this._randomBuffer = new byte[16];
        this.hmacIteration();
    }

    private void hmacIteration() {
        byte[] message = new byte[4];
        BitUtils.uint32ToByteArrayLE(this._nonce++, message, 0);
        byte[] temp = Hmac.hmacSha256(this._key, message);
        System.arraycopy(temp, 0, this._randomBuffer, 0, this._randomBuffer.length);
        this._index = 0;
    }

    @Override
    public String getAlgorithm() {
        throw new RuntimeException("Not supported");
    }

    @Override
    public synchronized void setSeed(byte[] seed) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    public synchronized void nextBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.nextByte();
        }
    }

    private byte nextByte() {
        if (this._index == this._randomBuffer.length) {
            this.hmacIteration();
        }
        return this._randomBuffer[this._index++];
    }

    @Override
    public byte[] generateSeed(int numBytes) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public int nextInt() {
        throw new RuntimeException("Not supported");
    }

    @Override
    public int nextInt(int n) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public long nextLong() {
        throw new RuntimeException("Not supported");
    }

    @Override
    public boolean nextBoolean() {
        throw new RuntimeException("Not supported");
    }

    @Override
    public float nextFloat() {
        throw new RuntimeException("Not supported");
    }

    @Override
    public double nextDouble() {
        throw new RuntimeException("Not supported");
    }

    @Override
    public synchronized double nextGaussian() {
        throw new RuntimeException("Not supported");
    }
}

