/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.bitcoinj.Base58;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.Hmac;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.KeyExporter;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PrivateKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PublicKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.RandomSource;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signature;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.EcTools;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Parameters;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Point;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import com.google.common.base.Optional;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

public class InMemoryPrivateKey
extends PrivateKey
implements KeyExporter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BigInteger _privateKey;
    private final PublicKey _publicKey;

    public InMemoryPrivateKey(RandomSource randomSource) {
        this(randomSource, false);
    }

    public InMemoryPrivateKey(RandomSource randomSource, boolean compressed) {
        byte[] bytes;
        BigInteger d;
        int nBitLength = Parameters.n.bitLength();
        do {
            bytes = new byte[nBitLength / 8];
            randomSource.nextBytes(bytes);
            bytes[0] = (byte)(bytes[0] & 0x7F);
        } while ((d = new BigInteger(bytes)).equals(BigInteger.ZERO) || d.compareTo(Parameters.n) >= 0);
        Point Q = EcTools.multiply(Parameters.G, d);
        this._privateKey = d;
        if (compressed) {
            Q = new Point(Q.getCurve(), Q.getX(), Q.getY(), true);
        }
        this._publicKey = new PublicKey(Q.getEncoded());
    }

    public InMemoryPrivateKey(byte[] bytes) {
        this(bytes, false);
    }

    public InMemoryPrivateKey(Sha256Hash hash, boolean compressed) {
        this(hash.getBytes(), compressed);
    }

    public InMemoryPrivateKey(byte[] bytes, boolean compressed) {
        if (bytes.length != 32) {
            throw new IllegalArgumentException("The length must be 32 bytes");
        }
        byte[] keyBytes = new byte[33];
        System.arraycopy(bytes, 0, keyBytes, 1, 32);
        this._privateKey = new BigInteger(keyBytes);
        Point Q = EcTools.multiply(Parameters.G, this._privateKey);
        if (compressed) {
            Q = new Point(Q.getCurve(), Q.getX(), Q.getY(), true);
        }
        this._publicKey = new PublicKey(Q.getEncoded());
    }

    public InMemoryPrivateKey(byte[] priBytes, byte[] pubBytes) {
        if (priBytes.length != 32) {
            throw new IllegalArgumentException("The length of the array of bytes must be 32");
        }
        byte[] keyBytes = new byte[33];
        System.arraycopy(priBytes, 0, keyBytes, 1, 32);
        this._privateKey = new BigInteger(keyBytes);
        this._publicKey = new PublicKey(pubBytes);
    }

    public InMemoryPrivateKey(String base58Encoded, NetworkParameters network) {
        boolean compressed;
        byte[] decoded = Base58.decodeChecked(base58Encoded);
        if (decoded == null || decoded.length < 33 || decoded.length > 34) {
            throw new IllegalArgumentException("Invalid base58 encoded key");
        }
        if (network.equals(NetworkParameters.productionNetwork) && decoded[0] != -128) {
            throw new IllegalArgumentException("The base58 encoded key is not for the production network");
        }
        if (network.equals(NetworkParameters.testNetwork) && decoded[0] != -17) {
            throw new IllegalArgumentException("The base58 encoded key is not for the test network");
        }
        if (decoded.length == 34) {
            if (decoded[33] != 1) {
                throw new IllegalArgumentException("Invalid base58 encoded key");
            }
            byte[] temp = new byte[33];
            System.arraycopy(decoded, 0, temp, 0, temp.length);
            decoded = temp;
            compressed = true;
        } else {
            compressed = false;
        }
        decoded[0] = 0;
        this._privateKey = new BigInteger(decoded);
        Point Q = EcTools.multiply(Parameters.G, this._privateKey);
        if (compressed) {
            Q = new Point(Q.getCurve(), Q.getX(), Q.getY(), true);
        }
        this._publicKey = new PublicKey(Q.getEncoded());
    }

    public static Optional<InMemoryPrivateKey> fromBase58String(String base58, NetworkParameters network) {
        try {
            InMemoryPrivateKey key = new InMemoryPrivateKey(base58, network);
            return Optional.of((Object)key);
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }

    public static Optional<InMemoryPrivateKey> fromBase58MiniFormat(String base58, NetworkParameters network) {
        if (base58 == null || base58.length() < 2 || !base58.startsWith("S")) {
            return Optional.absent();
        }
        String withQuestionMark = base58 + "?";
        byte[] checkHash = HashUtils.sha256(withQuestionMark.getBytes()).firstFourBytes();
        if (checkHash[0] != 0) {
            return Optional.absent();
        }
        Sha256Hash privateKeyBytes = HashUtils.sha256(base58.getBytes());
        try {
            InMemoryPrivateKey key = new InMemoryPrivateKey(privateKeyBytes, false);
            return Optional.of((Object)key);
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }

    @Override
    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    private BigInteger calculateE(BigInteger n, byte[] messageHash) {
        if (n.bitLength() > messageHash.length * 8) {
            return new BigInteger(1, messageHash);
        }
        int messageBitLength = messageHash.length * 8;
        BigInteger trunc = new BigInteger(1, messageHash);
        if (messageBitLength - n.bitLength() > 0) {
            trunc = trunc.shiftRight(messageBitLength - n.bitLength());
        }
        return trunc;
    }

    @Override
    protected Signature generateSignature(Sha256Hash messageHash) {
        return this.generateSignatureInternal(messageHash, new DsaSignatureNonceGenDeterministic(messageHash, this));
    }

    @Override
    protected Signature generateSignature(Sha256Hash messageHash, RandomSource randomSource) {
        return this.generateSignatureInternal(messageHash, new DsaSignatureNonceGenRandom(randomSource));
    }

    private Signature generateSignatureInternal(Sha256Hash messageHash, DsaSignatureNonceGen kGen) {
        BigInteger d;
        BigInteger k;
        BigInteger n = Parameters.n;
        BigInteger e = this.calculateE(n, messageHash.getBytes());
        BigInteger r = null;
        BigInteger s = null;
        do {
            k = kGen.getNonce();
            Point p = EcTools.multiply(Parameters.G, k);
            BigInteger x = p.getX().toBigInteger();
            r = x.mod(n);
            d = this._privateKey;
        } while ((s = k.modInverse(n).multiply(e.add(d.multiply(r))).mod(n)).equals(BigInteger.ZERO));
        if (s.compareTo(Parameters.MAX_SIG_S) == 1) {
            s = Parameters.n.subtract(s);
        }
        return new Signature(r, s);
    }

    @Override
    public byte[] getPrivateKeyBytes() {
        byte[] result = new byte[32];
        byte[] bytes = this._privateKey.toByteArray();
        if (bytes.length <= result.length) {
            System.arraycopy(bytes, 0, result, result.length - bytes.length, bytes.length);
        } else {
            assert (bytes.length == 33 && bytes[0] == 0);
            System.arraycopy(bytes, 1, result, 0, bytes.length - 1);
        }
        return result;
    }

    @Override
    public String getBase58EncodedPrivateKey(NetworkParameters network) {
        if (this.getPublicKey().isCompressed()) {
            return this.getBase58EncodedPrivateKeyCompressed(network);
        }
        return this.getBase58EncodedPrivateKeyUncompressed(network);
    }

    private String getBase58EncodedPrivateKeyUncompressed(NetworkParameters network) {
        byte[] toEncode = new byte[37];
        toEncode[0] = network.isProdnet() ? -128 : -17;
        byte[] keyBytes = this.getPrivateKeyBytes();
        System.arraycopy(keyBytes, 0, toEncode, 1, keyBytes.length);
        byte[] checkSum = HashUtils.doubleSha256(toEncode, 0, 33).firstFourBytes();
        System.arraycopy(checkSum, 0, toEncode, 33, 4);
        return Base58.encode(toEncode);
    }

    private String getBase58EncodedPrivateKeyCompressed(NetworkParameters network) {
        byte[] toEncode = new byte[38];
        toEncode[0] = network.isProdnet() ? -128 : -17;
        byte[] keyBytes = this.getPrivateKeyBytes();
        System.arraycopy(keyBytes, 0, toEncode, 1, keyBytes.length);
        toEncode[33] = 1;
        byte[] checkSum = HashUtils.doubleSha256(toEncode, 0, 34).firstFourBytes();
        System.arraycopy(checkSum, 0, toEncode, 34, 4);
        return Base58.encode(toEncode);
    }

    private static class DsaSignatureNonceGenDeterministic
    extends DsaSignatureNonceGen {
        private final Sha256Hash messageHash;
        private final KeyExporter privateKey;

        private DsaSignatureNonceGenDeterministic(Sha256Hash messageHash, KeyExporter privateKey) {
            this.messageHash = messageHash;
            this.privateKey = privateKey;
        }

        @Override
        public BigInteger getNonce() {
            byte[] v = new byte[32];
            Arrays.fill(v, (byte)1);
            byte[] k = new byte[32];
            Arrays.fill(k, (byte)0);
            ByteWriter bwD = new ByteWriter(97);
            bwD.putBytes(v);
            bwD.put((byte)0);
            bwD.putBytes(this.privateKey.getPrivateKeyBytes());
            bwD.putBytes(this.messageHash.getBytes());
            k = Hmac.hmacSha256(k, bwD.toBytes());
            v = Hmac.hmacSha256(k, v);
            ByteWriter bwF = new ByteWriter(97);
            bwF.putBytes(v);
            bwF.put((byte)1);
            bwF.putBytes(this.privateKey.getPrivateKeyBytes());
            bwF.putBytes(this.messageHash.getBytes());
            k = Hmac.hmacSha256(k, bwF.toBytes());
            v = Hmac.hmacSha256(k, v);
            v = Hmac.hmacSha256(k, v);
            BigInteger t = this.bits2int(v);
            while (t.signum() <= 0 || t.compareTo(Parameters.n) >= 0) {
                ByteWriter bwH = new ByteWriter(33);
                bwH.putBytes(v);
                bwH.put((byte)0);
                k = Hmac.hmacSha256(k, bwH.toBytes());
                v = Hmac.hmacSha256(k, v);
                t = new BigInteger(v);
            }
            return t;
        }

        private BigInteger bits2int(byte[] in) {
            BigInteger v = new BigInteger(1, in);
            return v;
        }
    }

    private static class DsaSignatureNonceGenRandom
    extends DsaSignatureNonceGen {
        private final RandomSource randomSource;

        private DsaSignatureNonceGenRandom(RandomSource randomSource) {
            this.randomSource = randomSource;
        }

        @Override
        public BigInteger getNonce() {
            byte[] bytes;
            BigInteger k;
            int nBitLength = Parameters.n.bitLength();
            do {
                bytes = new byte[nBitLength / 8];
                this.randomSource.nextBytes(bytes);
                bytes[0] = (byte)(bytes[0] & 0x7F);
            } while ((k = new BigInteger(bytes)).equals(BigInteger.ZERO));
            return k;
        }
    }

    private static abstract class DsaSignatureNonceGen {
        private DsaSignatureNonceGen() {
        }

        public abstract BigInteger getNonce();
    }
}

