/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.Rijndael.Rijndael;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.Bip39;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.InMemoryPrivateKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.RandomSource;
import com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto.SCrypt;
import com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto.SCryptProgress;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;

public class MrdExport {
    private static final byte[] MAGIC_COOKIE = new byte[]{-60, 73, -36};
    public static final int V1_VERSION = 1;

    public static boolean isChecksumValid(String enteredText) {
        if (enteredText.length() != 16) {
            return false;
        }
        String password = enteredText.substring(0, 15);
        char chechsumChar = V1.calculatePasswordChecksum(password);
        return Character.toUpperCase(chechsumChar) == enteredText.charAt(15);
    }

    public static int decodeVersion(String base64EncryptedPrivateKey) throws DecodingException {
        byte[] data = MrdExport.base64UrlDecode(base64EncryptedPrivateKey);
        if (data.length < 4) {
            throw new DecodingException();
        }
        if (data[0] != MAGIC_COOKIE[0] || data[1] != MAGIC_COOKIE[1] || data[2] != MAGIC_COOKIE[2]) {
            throw new DecodingException();
        }
        int version = data[3] >> 4 & 0xF;
        return version;
    }

    private static void xorBytes(byte[] toApply, byte[] target) {
        if (toApply.length != target.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < toApply.length; ++i) {
            target[i] = (byte)(target[i] ^ toApply[i]);
        }
    }

    private static String base64UrlEncode(byte[] data) {
        return BaseEncoding.base64Url().omitPadding().encode(data);
    }

    private static byte[] base64UrlDecode(String base64String) throws DecodingException {
        try {
            return BaseEncoding.base64Url().decode((CharSequence)base64String);
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException();
        }
    }

    public static class V1 {
        public static final String PASSWORD_CHARACTER_ENCODING = "US-ASCII";
        public static final int V1_PASSPHRASE_LENGTH = 15;
        private static final int V1_SALT_LENGTH = 4;
        private static final int V1_HEADER_LENGTH = MrdExport.access$000().length + 3 + 4;
        private static final int V1_CHECKSUM_LENGTH = 4;
        private static final int V1_BLOCK_CIPHER_LENGTH = 16;
        public static final int V1_CIPHER_KEY_LENGTH = 32;
        private static char[] ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

        public static Header extractHeader(String base64EncryptedPrivateKey) throws DecodingException {
            byte[] data = MrdExport.base64UrlDecode(base64EncryptedPrivateKey);
            return Header.fromBytes(data);
        }

        public static String decryptPrivateKey(EncryptionParameters parameters, String base64EncryptedPrivateKey, NetworkParameters network) throws DecodingException, WrongNetworkException, InvalidChecksumException {
            byte[] data = MrdExport.base64UrlDecode(base64EncryptedPrivateKey);
            int index = 0;
            Header header = Header.fromBytes(data);
            index += V1_HEADER_LENGTH;
            if (!network.equals(header.network)) {
                throw new WrongNetworkException();
            }
            if (header.type != Header.Type.UNCOMPRESSED && header.type != Header.Type.COMPRESSED) {
                throw new DecodingException();
            }
            byte[] ciphertext = new byte[32];
            System.arraycopy(data, index, ciphertext, 0, 32);
            byte[] checksum = new byte[4];
            System.arraycopy(data, index += 32, checksum, 0, 4);
            index += 4;
            byte[] decrypted = V1.decryptBytes(parameters, ciphertext, checksum);
            InMemoryPrivateKey key = new InMemoryPrivateKey(decrypted, header.type == Header.Type.COMPRESSED);
            byte[] checksumVerify = V1.calculatePrivateKeyChecksum(key, network);
            if (!BitUtils.areEqual(checksum, checksumVerify)) {
                throw new InvalidChecksumException();
            }
            return key.getBase58EncodedPrivateKey(network);
        }

        public static Bip39.MasterSeed decryptMasterSeed(EncryptionParameters parameters, String base64EncryptedMasterSeed, NetworkParameters network) throws DecodingException, WrongNetworkException, InvalidChecksumException {
            byte[] data = MrdExport.base64UrlDecode(base64EncryptedMasterSeed);
            int index = 0;
            Header header = Header.fromBytes(data);
            index += V1_HEADER_LENGTH;
            if (!network.equals(header.network)) {
                throw new WrongNetworkException();
            }
            if (header.type != Header.Type.MASTER_SEED) {
                throw new DecodingException();
            }
            int encryptedSeedLength = data.length - V1_HEADER_LENGTH - 4;
            if (encryptedSeedLength <= 0 || encryptedSeedLength % 16 != 0) {
                throw new DecodingException();
            }
            byte[] ciphertext = new byte[encryptedSeedLength];
            System.arraycopy(data, index, ciphertext, 0, encryptedSeedLength);
            byte[] checksum = new byte[4];
            System.arraycopy(data, index += encryptedSeedLength, checksum, 0, 4);
            index += 4;
            byte[] decrypted = V1.decryptBytes(parameters, ciphertext, checksum);
            Optional<Bip39.MasterSeed> masterSeed = Bip39.MasterSeed.fromBytes(decrypted, true);
            if (!masterSeed.isPresent()) {
                throw new DecodingException();
            }
            byte[] checksumVerify = V1.calculateMasterSeedChecksum((Bip39.MasterSeed)masterSeed.get());
            if (!BitUtils.areEqual(checksum, checksumVerify)) {
                throw new InvalidChecksumException();
            }
            return (Bip39.MasterSeed)masterSeed.get();
        }

        private static byte[] decryptBytes(EncryptionParameters parameters, byte[] ciphertext, byte[] checksum) throws InvalidChecksumException {
            Preconditions.checkArgument((ciphertext.length % 16 == 0 ? 1 : 0) != 0);
            byte[] decrypted = new byte[ciphertext.length];
            byte[] IV = new byte[16];
            byte[] hash = HashUtils.sha256(parameters.salt, checksum).getBytes();
            System.arraycopy(hash, 0, IV, 0, IV.length);
            Rijndael aes2 = new Rijndael();
            aes2.makeKey(parameters.aesKey, 256);
            byte[] cbcBlock = IV;
            int blocks = ciphertext.length / 16;
            for (int i = 0; i < blocks; ++i) {
                byte[] ciphertextBlock = new byte[16];
                System.arraycopy(ciphertext, i * 16, ciphertextBlock, 0, 16);
                byte[] plaintextBlock = new byte[16];
                aes2.decrypt(ciphertextBlock, plaintextBlock);
                MrdExport.xorBytes(cbcBlock, plaintextBlock);
                System.arraycopy(plaintextBlock, 0, decrypted, i * 16, 16);
                cbcBlock = ciphertextBlock;
            }
            return decrypted;
        }

        public static String encryptPrivateKey(EncryptionParameters parameters, String base58EncodedPrivateKey, NetworkParameters network) {
            InMemoryPrivateKey key = new InMemoryPrivateKey(base58EncodedPrivateKey, network);
            byte[] encoded = new byte[V1_HEADER_LENGTH + 32 + 4];
            int index = 0;
            Header.Type type = key.getPublicKey().isCompressed() ? Header.Type.COMPRESSED : Header.Type.UNCOMPRESSED;
            Header h = new Header(1, network, type, parameters.n, parameters.r, parameters.p, parameters.salt);
            System.arraycopy(h.toBytes(), 0, encoded, index, V1_HEADER_LENGTH);
            byte[] checksum = V1.calculatePrivateKeyChecksum(key, network);
            byte[] ciphertext = V1.encryptBytes(parameters, key.getPrivateKeyBytes(), checksum);
            System.arraycopy(ciphertext, 0, encoded, index += V1_HEADER_LENGTH, 16);
            System.arraycopy(ciphertext, 16, encoded, index += 16, 16);
            System.arraycopy(checksum, 0, encoded, index += 16, checksum.length);
            String result = MrdExport.base64UrlEncode(encoded);
            return result;
        }

        public static String encryptMasterSeed(EncryptionParameters parameters, Bip39.MasterSeed masterSeed, NetworkParameters network) {
            int index = 0;
            byte[] compressedMasterSeed = masterSeed.toBytes(true);
            byte[] paddedPlaintext = V1.addZeroPadding(compressedMasterSeed);
            Header.Type type = Header.Type.MASTER_SEED;
            byte[] encoded = new byte[V1_HEADER_LENGTH + paddedPlaintext.length + 4];
            Header h = new Header(1, network, type, parameters.n, parameters.r, parameters.p, parameters.salt);
            System.arraycopy(h.toBytes(), 0, encoded, index, V1_HEADER_LENGTH);
            byte[] checksum = V1.calculateMasterSeedChecksum(masterSeed);
            byte[] ciphertext = V1.encryptBytes(parameters, paddedPlaintext, checksum);
            System.arraycopy(ciphertext, 0, encoded, index += V1_HEADER_LENGTH, paddedPlaintext.length);
            System.arraycopy(checksum, 0, encoded, index += paddedPlaintext.length, checksum.length);
            String result = MrdExport.base64UrlEncode(encoded);
            return result;
        }

        private static byte[] addZeroPadding(byte[] data) {
            ByteWriter writer = new ByteWriter(data.length + 16);
            writer.putBytes(data);
            int excess = writer.length() % 16;
            if (excess == 0) {
                return writer.toBytes();
            }
            return BitUtils.copyOf(writer.toBytes(), writer.length() + 16 - excess);
        }

        private static byte[] encryptBytes(EncryptionParameters parameters, byte[] plaintext, byte[] checksum) {
            Preconditions.checkArgument((plaintext.length % 16 == 0 ? 1 : 0) != 0);
            byte[] encrypted = new byte[plaintext.length];
            byte[] IV = new byte[16];
            byte[] hash = HashUtils.sha256(parameters.salt, checksum).getBytes();
            System.arraycopy(hash, 0, IV, 0, 16);
            Rijndael aes2 = new Rijndael();
            aes2.makeKey(parameters.aesKey, 256);
            byte[] cbcBlock = IV;
            int blocks = plaintext.length / 16;
            for (int i = 0; i < blocks; ++i) {
                byte[] plaintextBlock = new byte[16];
                System.arraycopy(plaintext, i * 16, plaintextBlock, 0, 16);
                MrdExport.xorBytes(cbcBlock, plaintextBlock);
                byte[] ciphertextBlock = new byte[16];
                aes2.encrypt(plaintextBlock, ciphertextBlock);
                System.arraycopy(ciphertextBlock, 0, encrypted, i * 16, 16);
                cbcBlock = ciphertextBlock;
            }
            return encrypted;
        }

        private static char[] getExtendedAlphabet() {
            int repetitions = 256 / ALPHABET.length;
            char[] extendedAlphabet = new char[repetitions * ALPHABET.length];
            for (int i = 0; i < repetitions; ++i) {
                System.arraycopy(ALPHABET, 0, extendedAlphabet, i * ALPHABET.length, ALPHABET.length);
            }
            return extendedAlphabet;
        }

        public static String generatePassword(RandomSource randomSource) {
            char[] extendedAlphabet = V1.getExtendedAlphabet();
            char[] passphrase = new char[15];
            byte[] one = new byte[1];
            for (int i = 0; i < 15; ++i) {
                int index;
                do {
                    randomSource.nextBytes(one);
                } while ((index = one[0] & 0xFF) > extendedAlphabet.length - 1);
                passphrase[i] = extendedAlphabet[index];
            }
            return new String(passphrase);
        }

        public static char calculatePasswordChecksum(String password) {
            Sha256Hash hash;
            try {
                hash = HashUtils.sha256(password.getBytes(PASSWORD_CHARACTER_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            long asInteger = BitUtils.uint32ToLong(hash.firstFourBytes(), 0);
            int index = (int)(asInteger % (long)ALPHABET.length);
            return ALPHABET[index];
        }

        private static byte[] calculatePrivateKeyChecksum(InMemoryPrivateKey key, NetworkParameters network) {
            try {
                String address2 = key.getPublicKey().toAddress(network).toString();
                byte[] hash = HashUtils.sha256(address2.getBytes(PASSWORD_CHARACTER_ENCODING)).getBytes();
                byte[] checksum = new byte[4];
                System.arraycopy(hash, 0, checksum, 0, 4);
                return checksum;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private static byte[] calculateMasterSeedChecksum(Bip39.MasterSeed masterSeed) {
            byte[] hash = HashUtils.doubleSha256(masterSeed.getBip32Seed()).getBytes();
            byte[] checksum = new byte[4];
            System.arraycopy(hash, 0, checksum, 0, 4);
            return checksum;
        }

        public static class Header {
            public int version;
            public NetworkParameters network;
            public Type type;
            public int n;
            public int r;
            public int p;
            public byte[] salt;

            public Header(int version, NetworkParameters network, Type type, int n, int r, int p, byte[] salt) {
                this.version = version;
                this.network = network;
                this.type = type;
                this.n = n;
                this.r = r;
                this.p = p;
                this.salt = salt;
                if (version != 1) {
                    throw new RuntimeException("Unsupported version number");
                }
                if (n < 0 || n > 31 || r < 1 || r > 31 || p < 1 || p > 31) {
                    throw new RuntimeException("SCrypt parameters out of range");
                }
            }

            public byte[] toBytes() {
                int typeBits;
                byte[] bytes = new byte[V1_HEADER_LENGTH];
                bytes[0] = MAGIC_COOKIE[0];
                bytes[1] = MAGIC_COOKIE[1];
                bytes[2] = MAGIC_COOKIE[2];
                int versionBits = 16;
                byte networkBits = (byte)(this.network.isProdnet() ? 0 : 8);
                switch (this.type) {
                    case UNCOMPRESSED: {
                        typeBits = 0;
                        break;
                    }
                    case COMPRESSED: {
                        typeBits = 1;
                        break;
                    }
                    case MASTER_SEED: {
                        typeBits = 2;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid type: " + this.type.toString());
                    }
                }
                bytes[3] = (byte)(versionBits | networkBits | typeBits);
                byte nBits = (byte)((byte)this.n << 3);
                byte rBitsTop = (byte)((byte)this.r >> 2);
                bytes[4] = (byte)(nBits | rBitsTop);
                byte rBitsBot = (byte)((byte)this.r << 6);
                byte pBits = (byte)((byte)this.p << 1);
                bytes[5] = (byte)(rBitsBot | pBits);
                System.arraycopy(this.salt, 0, bytes, 6, 4);
                return bytes;
            }

            public static Header fromBytes(byte[] bytes) throws DecodingException {
                Type type;
                if (bytes.length < V1_HEADER_LENGTH) {
                    throw new DecodingException();
                }
                if (bytes[0] != MAGIC_COOKIE[0] || bytes[1] != MAGIC_COOKIE[1] || bytes[2] != MAGIC_COOKIE[2]) {
                    throw new DecodingException();
                }
                int version = bytes[3] >> 4 & 0xF;
                if (version != 1) {
                    throw new DecodingException();
                }
                NetworkParameters network = (bytes[3] & 8) == 8 ? NetworkParameters.testNetwork : NetworkParameters.productionNetwork;
                int typeBits = bytes[3] & 7;
                switch (typeBits) {
                    case 0: {
                        type = Type.UNCOMPRESSED;
                        break;
                    }
                    case 1: {
                        type = Type.COMPRESSED;
                        break;
                    }
                    case 2: {
                        type = Type.MASTER_SEED;
                        break;
                    }
                    default: {
                        throw new DecodingException();
                    }
                }
                int n = bytes[4] >> 3 & 0x1F;
                int r = bytes[4] << 2 & 0x1F;
                r += bytes[5] >> 6 & 3;
                int p = bytes[5] >> 1 & 0x1F;
                if ((bytes[5] & 1) != 0) {
                    throw new DecodingException();
                }
                byte[] salt = new byte[4];
                System.arraycopy(bytes, 6, salt, 0, 4);
                return new Header(version, network, type, n, r, p, salt);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Header)) {
                    return false;
                }
                Header o = (Header)obj;
                return this.version == o.version && this.network.equals(o.network) && this.type == o.type && this.n == o.n && this.r == o.r && this.p == o.p;
            }

            public static enum Type {
                UNCOMPRESSED,
                COMPRESSED,
                MASTER_SEED;

            }
        }

        public static class KdfParameters
        extends ScryptParameters {
            private static final long serialVersionUID = 1L;
            public String passphrase;
            public byte[] salt;
            private SCryptProgress _scryptProgressTracker;

            public static KdfParameters createNewFromPassphrase(String passphrase, RandomSource rnd, ScryptParameters useScryptParameters) {
                byte[] salt = new byte[4];
                rnd.nextBytes(salt);
                return new KdfParameters(passphrase, salt, useScryptParameters);
            }

            public static KdfParameters fromPassphraseAndHeader(String passphrase, Header header) {
                return new KdfParameters(passphrase, header.salt, new ScryptParameters(header));
            }

            protected KdfParameters(String passphrase, byte[] salt, ScryptParameters scryptParameters) {
                super(scryptParameters);
                if (this.n >= 32) {
                    throw new RuntimeException("Parameter n can never be larger than 31. Note that n = 14 means scrypt with N = 16384");
                }
                this.passphrase = passphrase;
                this.salt = salt;
                this._scryptProgressTracker = new SCryptProgress(1 << this.n, this.r, this.p);
            }

            public double getProgress() {
                return this._scryptProgressTracker.getProgress();
            }

            public void terminate() {
                this._scryptProgressTracker.terminate();
            }
        }

        public static class ScryptParameters
        implements Serializable {
            public static final ScryptParameters DEFAULT_PARAMS = new ScryptParameters(14, 8, 1);
            public static final ScryptParameters LOW_MEM_PARAMS = new ScryptParameters(14, 4, 1);
            public final int n;
            public final int r;
            public final int p;

            public ScryptParameters(int n, int r, int p) {
                this.n = n;
                this.r = r;
                this.p = p;
            }

            public ScryptParameters(ScryptParameters scryptParameters) {
                this.n = scryptParameters.n;
                this.r = scryptParameters.r;
                this.p = scryptParameters.p;
            }

            public ScryptParameters(Header header) {
                this.n = header.n;
                this.r = header.r;
                this.p = header.p;
            }
        }

        public static class EncryptionParameters
        implements Serializable {
            private static final long serialVersionUID = 1L;
            public int n;
            public int r;
            public int p;
            public byte[] salt;
            public byte[] aesKey;

            public EncryptionParameters(byte[] aesKey, KdfParameters kdfParameters) {
                this.n = kdfParameters.n;
                this.r = kdfParameters.r;
                this.p = kdfParameters.p;
                this.salt = kdfParameters.salt;
                this.aesKey = aesKey;
            }

            public static EncryptionParameters generate(KdfParameters p) throws InterruptedException, OutOfMemoryError {
                try {
                    byte[] aesKey = SCrypt.scrypt(p.passphrase.getBytes(V1.PASSWORD_CHARACTER_ENCODING), p.salt, 1 << p.n, p.r, p.p, 32, p._scryptProgressTracker);
                    return new EncryptionParameters(aesKey, p);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public static class InvalidChecksumException
        extends DecodingException {
            private static final long serialVersionUID = 1L;
        }

        public static class WrongNetworkException
        extends DecodingException {
            private static final long serialVersionUID = 1L;
        }
    }

    public static class DecodingException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

