/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.BitcoinSigner;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PublicKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.RandomSource;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signature;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signatures;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.SignedMessage;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import java.io.Serializable;

public abstract class PrivateKey
implements BitcoinSigner,
Serializable {
    private static final long serialVersionUID = 1L;

    public abstract PublicKey getPublicKey();

    @Override
    public byte[] makeStandardBitcoinSignature(Sha256Hash transactionSigningHash) {
        byte[] signature = this.signMessage(transactionSigningHash);
        ByteWriter writer = new ByteWriter(1024);
        writer.putBytes(signature);
        writer.put((byte)1);
        return writer.toBytes();
    }

    protected byte[] signMessage(Sha256Hash message) {
        return this.generateSignature(message).derEncode();
    }

    protected abstract Signature generateSignature(Sha256Hash var1, RandomSource var2);

    protected abstract Signature generateSignature(Sha256Hash var1);

    public int hashCode() {
        return this.getPublicKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PrivateKey)) {
            return false;
        }
        PrivateKey other = (PrivateKey)obj;
        return this.getPublicKey().equals(other.getPublicKey());
    }

    public SignedMessage signMessage(String message) {
        byte[] data = Signatures.formatMessageForSigning(message);
        Sha256Hash hash = HashUtils.doubleSha256(data);
        return this.signHash(hash);
    }

    public SignedMessage signHash(Sha256Hash hashToSign) {
        Signature sig = this.generateSignature(hashToSign);
        PublicKey targetPubKey = this.getPublicKey();
        boolean compressed = targetPubKey.isCompressed();
        int recId = -1;
        for (int i = 0; i < 4; ++i) {
            PublicKey k = SignedMessage.recoverFromSignature(i, sig, hashToSign, compressed);
            if (k == null || !targetPubKey.equals(k)) continue;
            recId = i;
            break;
        }
        return SignedMessage.from(sig, targetPubKey, recId);
    }

    public SignedMessage signHash(Sha256Hash hashToSign, RandomSource randomSource) {
        Signature sig = this.generateSignature(hashToSign, randomSource);
        PublicKey targetPubKey = this.getPublicKey();
        boolean compressed = targetPubKey.isCompressed();
        int recId = -1;
        for (int i = 0; i < 4; ++i) {
            PublicKey k = SignedMessage.recoverFromSignature(i, sig, hashToSign, compressed);
            if (k == null || !targetPubKey.equals(k)) continue;
            recId = i;
            break;
        }
        return SignedMessage.from(sig, targetPubKey, recId);
    }
}

