/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.BitcoinSigner;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.IPrivateKeyRing;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.KeyExporter;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PrivateKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PublicKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PublicKeyRing;
import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import java.util.HashMap;
import java.util.Map;

public class PrivateKeyRing
extends PublicKeyRing
implements IPrivateKeyRing {
    private Map<PublicKey, PrivateKey> _privateKeys = new HashMap<PublicKey, PrivateKey>();

    public void addPrivateKey(PrivateKey key, NetworkParameters network) {
        this._privateKeys.put(key.getPublicKey(), key);
        this.addPublicKey(key.getPublicKey(), network);
    }

    public void addPrivateKey(PrivateKey privateKey, PublicKey publicKey, Address address2) {
        this._privateKeys.put(publicKey, privateKey);
        this.addPublicKey(publicKey, address2);
    }

    @Override
    public BitcoinSigner findSignerByPublicKey(PublicKey publicKey) {
        return this._privateKeys.get(publicKey);
    }

    public KeyExporter findKeyExporterByPublicKey(PublicKey publicKey) {
        PrivateKey key = this._privateKeys.get(publicKey);
        if (key instanceof KeyExporter) {
            return (KeyExporter)((Object)key);
        }
        return null;
    }
}

