/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signature;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signatures;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Parameters;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Point;
import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.HexUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import java.io.Serializable;
import java.util.Arrays;

public class PublicKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] _pubKeyBytes;
    private byte[] _pubKeyHash;
    private Point _Q;

    public PublicKey(byte[] publicKeyBytes) {
        this._pubKeyBytes = publicKeyBytes;
    }

    public Address toAddress(NetworkParameters networkParameters) {
        byte[] hashedPublicKey = this.getPublicKeyHash();
        return Address.fromStandardBytes(hashedPublicKey, networkParameters);
    }

    public byte[] getPublicKeyBytes() {
        return this._pubKeyBytes;
    }

    public byte[] getPublicKeyHash() {
        if (this._pubKeyHash == null) {
            this._pubKeyHash = HashUtils.addressHash(this._pubKeyBytes);
        }
        return this._pubKeyHash;
    }

    public int hashCode() {
        byte[] bytes = this.getPublicKeyHash();
        int hash = 0;
        for (int i = 0; i < bytes.length; ++i) {
            hash = (hash << 8) + (bytes[i] & 0xFF);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey)obj;
        return Arrays.equals(this.getPublicKeyHash(), other.getPublicKeyHash());
    }

    public String toString() {
        return HexUtils.toHex(this._pubKeyBytes);
    }

    public boolean verifyStandardBitcoinSignature(Sha256Hash data, byte[] signature, boolean forceLowS) {
        ByteReader reader = new ByteReader(signature);
        Signature params = Signatures.decodeSignatureParameters(reader);
        if (params == null) {
            return false;
        }
        if (reader.available() != 1) {
            return false;
        }
        if (forceLowS) {
            return Signatures.verifySignatureLowS(data.getBytes(), params, this.getQ());
        }
        return Signatures.verifySignature(data.getBytes(), params, this.getQ());
    }

    public boolean verifyDerEncodedSignature(Sha256Hash data, byte[] signature) {
        ByteReader reader = new ByteReader(signature);
        Signature params = Signatures.decodeSignatureParameters(reader);
        if (params == null) {
            return false;
        }
        return Signatures.verifySignature(data.getBytes(), params, this.getQ());
    }

    public boolean isCompressed() {
        return this.getQ().isCompressed();
    }

    public Point getQ() {
        if (this._Q == null) {
            this._Q = Parameters.curve.decodePoint(this._pubKeyBytes);
        }
        return this._Q;
    }
}

