/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.IPublicKeyRing;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.PublicKey;
import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PublicKeyRing
implements IPublicKeyRing {
    private List<Address> _addresses = new ArrayList<Address>();
    private Set<Address> _addressSet = new HashSet<Address>();
    private Map<Address, PublicKey> _publicKeys = new HashMap<Address, PublicKey>();

    public void addPublicKey(PublicKey key, NetworkParameters network) {
        Address address2 = key.toAddress(network);
        this._addresses.add(address2);
        this._addressSet.add(address2);
        this._publicKeys.put(address2, key);
    }

    public void addPublicKey(PublicKey key, Address address2) {
        this._addresses.add(address2);
        this._addressSet.add(address2);
        this._publicKeys.put(address2, key);
    }

    @Override
    public PublicKey findPublicKeyByAddress(Address address2) {
        return this._publicKeys.get(address2);
    }

    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this._addresses);
    }

    public Set<Address> getAddressSet() {
        return Collections.unmodifiableSet(this._addressSet);
    }
}

