/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import java.io.Serializable;
import java.math.BigInteger;

public class Signature
implements Serializable {
    private static final long serialVersionUID = -7537263193002961466L;
    public final BigInteger r;
    public final BigInteger s;

    public Signature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public byte[] derEncode() {
        ByteWriter writer = new ByteWriter(1024);
        writer.put((byte)48);
        byte[] s1 = this.r.toByteArray();
        byte[] s2 = this.s.toByteArray();
        int totalLength = 2 + s1.length + 2 + s2.length;
        if (totalLength > 127) {
            throw new RuntimeException("Unsupported signature length: " + totalLength);
        }
        writer.put((byte)(totalLength & 0xFF));
        writer.put((byte)2);
        writer.put((byte)(s1.length & 0xFF));
        writer.putBytes(s1);
        writer.put((byte)2);
        writer.put((byte)(s2.length & 0xFF));
        writer.putBytes(s2);
        return writer.toBytes();
    }
}

