/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signature;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.EcTools;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Parameters;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Point;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class Signatures {
    private static final byte[] HEADER;
    private static final byte[] SIGNING_HEADER;

    public static Signature decodeSignatureParameters(ByteReader reader) {
        byte[][] bytes = Signatures.decodeSignatureParameterBytes(reader);
        if (bytes == null) {
            return null;
        }
        bytes[0] = Signatures.makePositive(bytes[0]);
        bytes[1] = Signatures.makePositive(bytes[1]);
        return new Signature(new BigInteger(bytes[0]), new BigInteger(bytes[1]));
    }

    public static byte[][] decodeSignatureParameterBytes(ByteReader reader) {
        try {
            if ((reader.get() & 0xFF) != 48) {
                return null;
            }
            int length = reader.get() & 0xFF;
            if ((reader.get() & 0xFF) != 2) {
                return null;
            }
            int length1 = reader.get() & 0xFF;
            byte[] bytes1 = reader.getBytes(length1);
            if ((reader.get() & 0xFF) != 2) {
                return null;
            }
            int length2 = reader.get() & 0xFF;
            byte[] bytes2 = reader.getBytes(length2);
            if (2 + length1 + 2 + length2 != length) {
                return null;
            }
            byte[][] result = new byte[][]{bytes1, bytes2};
            return result;
        }
        catch (ByteReader.InsufficientBytesException e) {
            return null;
        }
    }

    private static byte[] makePositive(byte[] bytes) {
        if (bytes[0] < 0) {
            byte[] temp = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, temp, 1, bytes.length);
            return temp;
        }
        return bytes;
    }

    static boolean verifySignatureLowS(byte[] message, Signature signature, Point Q) {
        BigInteger n = Parameters.n;
        BigInteger e = Signatures.calculateE(n, message);
        BigInteger r = signature.r;
        BigInteger s = signature.s;
        if (r.compareTo(BigInteger.ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(BigInteger.ONE) < 0 || s.compareTo(Parameters.MAX_SIG_S) > 0) {
            return false;
        }
        return Signatures.checkSignature(Q, n, e, r, s);
    }

    static boolean verifySignature(byte[] message, Signature signature, Point Q) {
        BigInteger n = Parameters.n;
        BigInteger e = Signatures.calculateE(n, message);
        BigInteger r = signature.r;
        BigInteger s = signature.s;
        if (r.compareTo(BigInteger.ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(BigInteger.ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        return Signatures.checkSignature(Q, n, e, r, s);
    }

    private static boolean checkSignature(Point Q, BigInteger n, BigInteger e, BigInteger r, BigInteger s) {
        BigInteger c = s.modInverse(n);
        BigInteger u1 = e.multiply(c).mod(n);
        BigInteger u2 = r.multiply(c).mod(n);
        Point G = Parameters.G;
        Point point = EcTools.sumOfTwoMultiplies(G, u1, Q, u2);
        BigInteger v = point.getX().toBigInteger().mod(n);
        return v.equals(r);
    }

    private static BigInteger calculateE(BigInteger n, byte[] message) {
        if (n.bitLength() > message.length * 8) {
            return new BigInteger(1, message);
        }
        int messageBitLength = message.length * 8;
        BigInteger trunc = new BigInteger(1, message);
        if (messageBitLength - n.bitLength() > 0) {
            trunc = trunc.shiftRight(messageBitLength - n.bitLength());
        }
        return trunc;
    }

    @VisibleForTesting
    static byte[] formatMessageForSigning(String message) {
        byte[] messageBytes;
        try {
            messageBytes = message.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ByteWriter writer = new ByteWriter(messageBytes.length + SIGNING_HEADER.length + 1);
        writer.putBytes(SIGNING_HEADER);
        writer.putCompactInt(message.length());
        writer.putBytes(messageBytes);
        return writer.toBytes();
    }

    private static byte[] standardSigningHeader() {
        ByteArrayOutputStream bos1 = new ByteArrayOutputStream();
        bos1.write(HEADER.length);
        try {
            bos1.write(HEADER);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos1.toByteArray();
    }

    static {
        try {
            HEADER = "Bitcoin Signed Message:\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        SIGNING_HEADER = Signatures.standardSigningHeader();
    }
}

