/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.PublicKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signature;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.Signatures;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.WrongSignatureException;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Curve;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.EcTools;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Parameters;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Point;
import com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto.Base64;
import com.github.chouheiwa.wallet.socket.bitlib.model.Address;
import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;

public class SignedMessage
implements Serializable {
    private static final long serialVersionUID = 1188125594280603453L;
    private final Signature signature;
    private final PublicKey publicKey;
    private final int recId;

    private SignedMessage(Signature signature, PublicKey publicKey, int recId) {
        this.signature = signature;
        this.publicKey = publicKey;
        this.recId = recId;
    }

    public static PublicKey recoverFromSignature(String message, String signatureBase64) throws WrongSignatureException {
        byte[] signatureEncoded = Base64.decode(signatureBase64);
        Signature sig = SignedMessage.decodeSignature(signatureEncoded);
        return SignedMessage.recoverFromSignature((String)message, (byte[])signatureEncoded, (Signature)sig).publicKey;
    }

    public static SignedMessage validate(Address address2, String message, String signatureBase64) throws WrongSignatureException {
        byte[] signatureEncoded = Base64.decode(signatureBase64);
        if (signatureEncoded == null) {
            throw new WrongSignatureException(String.format("given signature is not valid base64 %s", signatureBase64));
        }
        Signature sig = SignedMessage.decodeSignature(signatureEncoded);
        RecoveryInfo info = SignedMessage.recoverFromSignature(message, signatureEncoded, sig);
        SignedMessage.validateAddressMatches(address2, info.publicKey);
        return new SignedMessage(sig, info.publicKey, info.recId);
    }

    public static void validateAddressMatches(Address address2, PublicKey key) throws WrongSignatureException {
        Address recoveredAddress = key.toAddress(address2.getNetwork());
        if (!address2.equals(recoveredAddress)) {
            throw new WrongSignatureException(String.format("given Address did not match \nexpected %s\n but got %s", address2, recoveredAddress));
        }
    }

    private static RecoveryInfo recoverFromSignature(String message, byte[] signatureEncoded, Signature sig) throws WrongSignatureException {
        int recId;
        PublicKey ret;
        int header = signatureEncoded[0] & 0xFF;
        if (header < 27 || header > 34) {
            throw new WrongSignatureException("Header byte out of range: " + header);
        }
        byte[] messageBytes = Signatures.formatMessageForSigning(message);
        Sha256Hash messageHash = HashUtils.doubleSha256(messageBytes);
        boolean compressed = false;
        if (header >= 31) {
            compressed = true;
            header -= 4;
        }
        if ((ret = SignedMessage.recoverFromSignature(recId = header - 27, sig, messageHash, compressed)) == null) {
            throw new WrongSignatureException("Could not recover public key from signature");
        }
        return new RecoveryInfo(ret, recId);
    }

    private static Signature decodeSignature(byte[] signatureEncoded) throws WrongSignatureException {
        if (signatureEncoded.length < 65) {
            throw new WrongSignatureException("Signature truncated, expected 65 bytes and got " + signatureEncoded.length);
        }
        BigInteger r = new BigInteger(1, BitUtils.copyOfRange(signatureEncoded, 1, 33));
        BigInteger s = new BigInteger(1, BitUtils.copyOfRange(signatureEncoded, 33, 65));
        return new Signature(r, s);
    }

    public static SignedMessage from(Signature signature, PublicKey publicKey, int recId) {
        return new SignedMessage(signature, publicKey, recId);
    }

    public static PublicKey recoverFromSignature(int recId, Signature sig, Sha256Hash message, boolean compressed) {
        Preconditions.checkArgument((recId >= 0 ? 1 : 0) != 0, (Object)"recId must be positive");
        Preconditions.checkArgument((sig.r.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (Object)"r must be positive");
        Preconditions.checkArgument((sig.s.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (Object)"s must be positive");
        Preconditions.checkNotNull((Object)message);
        BigInteger n = Parameters.n;
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = sig.r.add(i.multiply(n));
        Curve curve = Parameters.curve;
        BigInteger prime = curve.getQ();
        if (x.compareTo(prime) >= 0) {
            return null;
        }
        Point R = EcTools.decompressKey(x, (recId & 1) == 1);
        if (!R.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, message.getBytes());
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = sig.r.modInverse(n);
        BigInteger srInv = rInv.multiply(sig.s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        Point q = EcTools.sumOfTwoMultiplies(Parameters.G, eInvrInv, R, srInv);
        if (compressed) {
            q = new Point(curve, q.getX(), q.getY(), true);
        }
        return new PublicKey(q.getEncoded());
    }

    public byte[] bitcoinEncodingOfSignature() {
        if (this.recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        int headerByte = this.recId + 27 + (this.getPublicKey().isCompressed() ? 4 : 0);
        byte[] sigData = new byte[65];
        sigData[0] = (byte)headerByte;
        System.arraycopy(EcTools.integerToBytes(this.signature.r, 32), 0, sigData, 1, 32);
        System.arraycopy(EcTools.integerToBytes(this.signature.s, 32), 0, sigData, 33, 32);
        return sigData;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getBase64Signature() {
        return Base64.encodeToString(this.bitcoinEncodingOfSignature(), false);
    }

    public byte[] getDerEncodedSignature() {
        byte[] rBytes = this.signature.r.toByteArray();
        byte[] sBytes = this.signature.s.toByteArray();
        ByteWriter rsValues = new ByteWriter(rBytes.length + sBytes.length + 2 + 2);
        rsValues.put((byte)2);
        rsValues.put((byte)rBytes.length);
        rsValues.putBytes(rBytes);
        rsValues.put((byte)2);
        rsValues.put((byte)sBytes.length);
        rsValues.putBytes(sBytes);
        ByteWriter byteWriter = new ByteWriter(2 + rsValues.length());
        byteWriter.put((byte)48);
        Preconditions.checkState((rsValues.length() <= 255 ? 1 : 0) != 0, (Object)"total length should be smaller than 256");
        byteWriter.put((byte)rsValues.length());
        byteWriter.putBytes(rsValues.toBytes());
        return byteWriter.toBytes();
    }

    public static class RecoveryInfo {
        PublicKey publicKey;
        int recId;

        private RecoveryInfo(PublicKey publicKey, int recId) {
            this.publicKey = publicKey;
            this.recId = recId;
        }
    }
}

