/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.bitcoinj.Base58;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.HmacPRNG;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.InMemoryPrivateKey;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.RandomSource;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import java.security.NoSuchAlgorithmException;

public class SpinnerPrivateUri {
    public final InMemoryPrivateKey key;
    public final NetworkParameters network;

    private SpinnerPrivateUri(InMemoryPrivateKey key, NetworkParameters network) {
        this.key = key;
        this.network = network;
    }

    public static SpinnerPrivateUri fromSpinnerUri(String uri) {
        NetworkParameters params;
        if (!uri.startsWith("bsb:")) {
            throw new IllegalArgumentException("not a bsb: uri");
        }
        String[] elements = uri.substring(4).split("\\?");
        if (elements.length < 2) {
            throw new IllegalArgumentException("string does not specify key and net");
        }
        String seed = elements[0];
        if (elements[1].equals("net=0")) {
            params = NetworkParameters.productionNetwork;
        } else if (elements[1].equals("net=1")) {
            params = NetworkParameters.testNetwork;
        } else {
            throw new IllegalArgumentException("network not specified");
        }
        try {
            final HmacPRNG prng = new HmacPRNG(Base58.decode(seed));
            RandomSource randomSource = new RandomSource(){

                @Override
                public void nextBytes(byte[] bytes) {
                    prng.nextBytes(bytes);
                }
            };
            new InMemoryPrivateKey(randomSource);
            InMemoryPrivateKey key = new InMemoryPrivateKey(randomSource);
            return new SpinnerPrivateUri(key, params);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException();
        }
    }
}

