/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto.ec;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.FieldElement;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Point;
import java.io.Serializable;
import java.math.BigInteger;

public class Curve
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FieldElement _a;
    private FieldElement _b;
    private BigInteger _q;
    private Point _infinity;

    public Curve(BigInteger q, BigInteger a, BigInteger b) {
        this._q = q;
        this._a = this.fromBigInteger(a);
        this._b = this.fromBigInteger(b);
        this._infinity = new Point(this, null, null);
    }

    public FieldElement getA() {
        return this._a;
    }

    public FieldElement getB() {
        return this._b;
    }

    public BigInteger getQ() {
        return this._q;
    }

    public Point getInfinity() {
        return this._infinity;
    }

    public int getFieldSize() {
        return this._q.bitLength();
    }

    public FieldElement fromBigInteger(BigInteger x) {
        return new FieldElement(this._q, x);
    }

    public Point createPoint(BigInteger x, BigInteger y, boolean withCompression) {
        return new Point(this, this.fromBigInteger(x), this.fromBigInteger(y), withCompression);
    }

    public Point decodePoint(byte[] encodedPoint) {
        Point p = null;
        switch (encodedPoint[0]) {
            case 0: {
                p = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                int bit0;
                int ytilde = encodedPoint[0] & 1;
                byte[] i = new byte[encodedPoint.length - 1];
                System.arraycopy(encodedPoint, 1, i, 0, i.length);
                FieldElement x = new FieldElement(this._q, new BigInteger(1, i));
                FieldElement alpha = x.multiply(x.square().add(this._a)).add(this._b);
                FieldElement beta = alpha.sqrt();
                if (beta == null) {
                    throw new RuntimeException("Invalid compression");
                }
                int n = bit0 = beta.toBigInteger().testBit(0) ? 1 : 0;
                if (bit0 == ytilde) {
                    p = new Point(this, x, beta, true);
                    break;
                }
                p = new Point(this, x, new FieldElement(this._q, this._q.subtract(beta.toBigInteger())), true);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                byte[] xEnc = new byte[(encodedPoint.length - 1) / 2];
                byte[] yEnc = new byte[(encodedPoint.length - 1) / 2];
                System.arraycopy(encodedPoint, 1, xEnc, 0, xEnc.length);
                System.arraycopy(encodedPoint, xEnc.length + 1, yEnc, 0, yEnc.length);
                p = new Point(this, new FieldElement(this._q, new BigInteger(1, xEnc)), new FieldElement(this._q, new BigInteger(1, yEnc)));
                break;
            }
            default: {
                throw new RuntimeException("Invalid encoding 0x" + Integer.toString(encodedPoint[0], 16));
            }
        }
        return p;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Curve)) {
            return false;
        }
        Curve other = (Curve)obj;
        return this._q.equals(other._q) && this._a.equals(other._a) && this._b.equals(other._b);
    }

    public int hashCode() {
        return this._a.hashCode() ^ this._b.hashCode() ^ this._q.hashCode();
    }
}

