/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.crypto.ec;

import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Parameters;
import com.github.chouheiwa.wallet.socket.bitlib.crypto.ec.Point;
import java.math.BigInteger;

public class EcTools {
    public static int getByteLength(int fieldSize) {
        return (fieldSize + 7) / 8;
    }

    public static byte[] integerToBytes(BigInteger s, int length) {
        byte[] bytes = s.toByteArray();
        if (length < bytes.length) {
            byte[] tmp = new byte[length];
            System.arraycopy(bytes, bytes.length - tmp.length, tmp, 0, tmp.length);
            return tmp;
        }
        if (length > bytes.length) {
            byte[] tmp = new byte[length];
            System.arraycopy(bytes, 0, tmp, tmp.length - bytes.length, bytes.length);
            return tmp;
        }
        return bytes;
    }

    public static Point multiply(Point p, BigInteger k) {
        BigInteger e = k;
        BigInteger h = e.multiply(BigInteger.valueOf(3L));
        Point neg = p.negate();
        Point R = p;
        for (int i = h.bitLength() - 2; i > 0; --i) {
            boolean eBit;
            R = R.twice();
            boolean hBit = h.testBit(i);
            if (hBit == (eBit = e.testBit(i))) continue;
            R = R.add(hBit ? p : neg);
        }
        return R;
    }

    public static Point sumOfTwoMultiplies(Point P, BigInteger k, Point Q, BigInteger l) {
        int m = Math.max(k.bitLength(), l.bitLength());
        Point Z = P.add(Q);
        Point R = P.getCurve().getInfinity();
        for (int i = m - 1; i >= 0; --i) {
            R = R.twice();
            if (k.testBit(i)) {
                if (l.testBit(i)) {
                    R = R.add(Z);
                    continue;
                }
                R = R.add(P);
                continue;
            }
            if (!l.testBit(i)) continue;
            R = R.add(Q);
        }
        return R;
    }

    public static Point decompressKey(BigInteger x, boolean firstBit) {
        int size = 1 + EcTools.getByteLength(Parameters.curve.getFieldSize());
        byte[] dest = EcTools.integerToBytes(x, size);
        dest[0] = (byte)(firstBit ? 3 : 2);
        return Parameters.curve.decodePoint(dest);
    }
}

