/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto.PBKDF;
import com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto.SCryptProgress;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SCrypt {
    public static byte[] scrypt(byte[] passwd, byte[] salt, int N, int r, int p, int dkLen, SCryptProgress progressTracker) throws GeneralSecurityException, InterruptedException {
        int i;
        if (N == 0 || (N & N - 1) != 0) {
            throw new IllegalArgumentException("N must be > 0 and a power of 2");
        }
        if (N > 0xFFFFFF / r) {
            throw new IllegalArgumentException("Parameter N is too large");
        }
        if (r > 0xFFFFFF / p) {
            throw new IllegalArgumentException("Parameter r is too large");
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(passwd, "HmacSHA256"));
        byte[] DK = new byte[dkLen];
        byte[] B = new byte[128 * r * p];
        byte[] XY = new byte[256 * r];
        byte[][] V = new byte[N][];
        for (i = 0; i < N; ++i) {
            V[i] = new byte[128 * r];
        }
        PBKDF.pbkdf2(mac, salt, 1, B, p * 128 * r);
        for (i = 0; i < p; ++i) {
            SCrypt.smix(B, i * 128 * r, r, N, V, XY, progressTracker);
            if (progressTracker == null) continue;
            progressTracker.setProgressP(i + 1);
        }
        PBKDF.pbkdf2(mac, B, 1, DK, dkLen);
        return DK;
    }

    private static void smix(byte[] B, int Bi, int r, int N, byte[][] V, byte[] XY, SCryptProgress progressTracker) throws InterruptedException {
        int i;
        int Xi = 0;
        int Yi = 128 * r;
        System.arraycopy(B, Bi, XY, Xi, 128 * r);
        for (i = 0; i < N; ++i) {
            System.arraycopy(XY, Xi, V[i], 0, 128 * r);
            SCrypt.blockmix_salsa8(XY, Xi, Yi, r);
            if (progressTracker == null) continue;
            progressTracker.setProgressN1(i);
        }
        for (i = 0; i < N; ++i) {
            int j = SCrypt.integerify(XY, Xi, r) & N - 1;
            SCrypt.blockxor(V[j], 0, XY, Xi, 128 * r);
            SCrypt.blockmix_salsa8(XY, Xi, Yi, r);
            if (progressTracker == null) continue;
            progressTracker.setProgressN2(i);
        }
        System.arraycopy(XY, Xi, B, Bi, 128 * r);
    }

    private static void blockmix_salsa8(byte[] BY, int Bi, int Yi, int r) {
        int i;
        byte[] X = new byte[64];
        System.arraycopy(BY, Bi + (2 * r - 1) * 64, X, 0, 64);
        for (i = 0; i < 2 * r; ++i) {
            SCrypt.blockxor(BY, i * 64, X, 0, 64);
            SCrypt.salsa20_8(X);
            System.arraycopy(X, 0, BY, Yi + i * 64, 64);
        }
        for (i = 0; i < r; ++i) {
            System.arraycopy(BY, Yi + i * 2 * 64, BY, Bi + i * 64, 64);
        }
        for (i = 0; i < r; ++i) {
            System.arraycopy(BY, Yi + (i * 2 + 1) * 64, BY, Bi + (i + r) * 64, 64);
        }
    }

    public static int R(int a, int b) {
        return a << b | a >>> 32 - b;
    }

    private static void salsa20_8(byte[] B) {
        int i;
        int[] B32 = new int[16];
        int[] x = new int[16];
        for (i = 0; i < 16; ++i) {
            B32[i] = (B[i * 4 + 0] & 0xFF) << 0;
            int n = i;
            B32[n] = B32[n] | (B[i * 4 + 1] & 0xFF) << 8;
            int n2 = i;
            B32[n2] = B32[n2] | (B[i * 4 + 2] & 0xFF) << 16;
            int n3 = i;
            B32[n3] = B32[n3] | (B[i * 4 + 3] & 0xFF) << 24;
        }
        System.arraycopy(B32, 0, x, 0, 16);
        for (i = 8; i > 0; i -= 2) {
            x[4] = x[4] ^ SCrypt.R(x[0] + x[12], 7);
            x[8] = x[8] ^ SCrypt.R(x[4] + x[0], 9);
            x[12] = x[12] ^ SCrypt.R(x[8] + x[4], 13);
            x[0] = x[0] ^ SCrypt.R(x[12] + x[8], 18);
            x[9] = x[9] ^ SCrypt.R(x[5] + x[1], 7);
            x[13] = x[13] ^ SCrypt.R(x[9] + x[5], 9);
            x[1] = x[1] ^ SCrypt.R(x[13] + x[9], 13);
            x[5] = x[5] ^ SCrypt.R(x[1] + x[13], 18);
            x[14] = x[14] ^ SCrypt.R(x[10] + x[6], 7);
            x[2] = x[2] ^ SCrypt.R(x[14] + x[10], 9);
            x[6] = x[6] ^ SCrypt.R(x[2] + x[14], 13);
            x[10] = x[10] ^ SCrypt.R(x[6] + x[2], 18);
            x[3] = x[3] ^ SCrypt.R(x[15] + x[11], 7);
            x[7] = x[7] ^ SCrypt.R(x[3] + x[15], 9);
            x[11] = x[11] ^ SCrypt.R(x[7] + x[3], 13);
            x[15] = x[15] ^ SCrypt.R(x[11] + x[7], 18);
            x[1] = x[1] ^ SCrypt.R(x[0] + x[3], 7);
            x[2] = x[2] ^ SCrypt.R(x[1] + x[0], 9);
            x[3] = x[3] ^ SCrypt.R(x[2] + x[1], 13);
            x[0] = x[0] ^ SCrypt.R(x[3] + x[2], 18);
            x[6] = x[6] ^ SCrypt.R(x[5] + x[4], 7);
            x[7] = x[7] ^ SCrypt.R(x[6] + x[5], 9);
            x[4] = x[4] ^ SCrypt.R(x[7] + x[6], 13);
            x[5] = x[5] ^ SCrypt.R(x[4] + x[7], 18);
            x[11] = x[11] ^ SCrypt.R(x[10] + x[9], 7);
            x[8] = x[8] ^ SCrypt.R(x[11] + x[10], 9);
            x[9] = x[9] ^ SCrypt.R(x[8] + x[11], 13);
            x[10] = x[10] ^ SCrypt.R(x[9] + x[8], 18);
            x[12] = x[12] ^ SCrypt.R(x[15] + x[14], 7);
            x[13] = x[13] ^ SCrypt.R(x[12] + x[15], 9);
            x[14] = x[14] ^ SCrypt.R(x[13] + x[12], 13);
            x[15] = x[15] ^ SCrypt.R(x[14] + x[13], 18);
        }
        for (i = 0; i < 16; ++i) {
            B32[i] = x[i] + B32[i];
        }
        for (i = 0; i < 16; ++i) {
            B[i * 4 + 0] = (byte)(B32[i] >> 0 & 0xFF);
            B[i * 4 + 1] = (byte)(B32[i] >> 8 & 0xFF);
            B[i * 4 + 2] = (byte)(B32[i] >> 16 & 0xFF);
            B[i * 4 + 3] = (byte)(B32[i] >> 24 & 0xFF);
        }
    }

    private static void blockxor(byte[] S, int Si, byte[] D, int Di, int len) {
        for (int i = 0; i < len; ++i) {
            int n = Di + i;
            D[n] = (byte)(D[n] ^ S[Si + i]);
        }
    }

    private static int integerify(byte[] B, int Bi, int r) {
        int n = (B[(Bi += (2 * r - 1) * 64) + 0] & 0xFF) << 0;
        n |= (B[Bi + 1] & 0xFF) << 8;
        n |= (B[Bi + 2] & 0xFF) << 16;
        return n |= (B[Bi + 3] & 0xFF) << 24;
    }
}

