/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto;

import com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto.Base64;
import com.github.chouheiwa.wallet.socket.bitlib.lambdaworks.crypto.SCrypt;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;

public class SCryptUtil {
    public static String scrypt(String passwd, int N, int r, int p) throws InterruptedException {
        try {
            byte[] salt = new byte[16];
            SecureRandom.getInstance("SHA1PRNG").nextBytes(salt);
            byte[] derived = SCrypt.scrypt(passwd.getBytes("UTF-8"), salt, N, r, p, 32, null);
            String params = Integer.toString(SCryptUtil.log2(N) << 16 | r << 8 | p, 16);
            StringBuilder sb = new StringBuilder((salt.length + derived.length) * 2);
            sb.append("$s0$").append(params).append('$');
            sb.append(Base64.encodeToChar(salt, false)).append('$');
            sb.append(Base64.encodeToChar(derived, false));
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM doesn't support UTF-8?");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("JVM doesn't support SHA1PRNG or HMAC_SHA256?");
        }
    }

    public static boolean check(String passwd, String hashed) throws InterruptedException {
        try {
            String[] parts = hashed.split("\\$");
            if (parts.length != 5 || !parts[1].equals("s0")) {
                throw new IllegalArgumentException("Invalid hashed value");
            }
            int params = Integer.parseInt(parts[2], 16);
            byte[] salt = Base64.decodeFast(parts[3].toCharArray());
            byte[] derived0 = Base64.decodeFast(parts[4].toCharArray());
            int N = (int)Math.pow(2.0, params >> 16 & 0xFF);
            int r = params >> 8 & 0xF;
            int p = params & 0xF;
            byte[] derived1 = SCrypt.scrypt(passwd.getBytes("UTF-8"), salt, N, r, p, 32, null);
            if (derived0.length != derived1.length) {
                return false;
            }
            int result = 0;
            for (int i = 0; i < derived0.length; ++i) {
                result |= derived0[i] ^ derived1[i];
            }
            return result == 0;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM doesn't support UTF-8?");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("JVM doesn't support SHA1PRNG or HMAC_SHA256?");
        }
    }

    private static int log2(int n) {
        int log = 0;
        if ((n & 0xFFFF0000) != 0) {
            n >>>= 16;
            log = 16;
        }
        if (n >= 256) {
            n >>>= 8;
            log += 8;
        }
        if (n >= 16) {
            n >>>= 4;
            log += 4;
        }
        if (n >= 4) {
            n >>>= 2;
            log += 2;
        }
        return log + (n >>> 1);
    }
}

