/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.bitcoinj.Base58;
import com.github.chouheiwa.wallet.socket.bitlib.model.NetworkParameters;
import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;

public class Address
implements Serializable,
Comparable<Address> {
    private static final long serialVersionUID = 1L;
    public static final int NUM_ADDRESS_BYTES = 21;
    public static final Function<? super String, Address> FROM_STRING = new Function<String, Address>(){

        @Override
        public Address apply(String input) {
            return Address.fromString(input);
        }
    };
    private byte[] _bytes;
    private String _address;

    public static Collection<Address> fromStrings(Collection<String> addresses, NetworkParameters network) {
        LinkedList<Address> list = new LinkedList<Address>();
        for (String address2 : addresses) {
            Address a = Address.fromString(address2, network);
            if (a == null) {
                return null;
            }
            list.add(a);
        }
        return list;
    }

    public static Address[] fromStrings(String[] addressStrings) {
        Address[] addresses = new Address[addressStrings.length];
        for (int i = 0; i < addressStrings.length; ++i) {
            addresses[i] = Address.fromString(addressStrings[i]);
        }
        return addresses;
    }

    public static String[] toStrings(Address[] addresses) {
        String[] addressStrings = new String[addresses.length];
        for (int i = 0; i < addressStrings.length; ++i) {
            addressStrings[i] = addresses[i].toString();
        }
        return addressStrings;
    }

    public static Address fromString(String address2, NetworkParameters network) {
        Address addr = Address.fromString(address2);
        if (addr == null) {
            return null;
        }
        if (!addr.isValidAddress(network)) {
            return null;
        }
        return addr;
    }

    public static Address fromString(String address2) {
        if (address2 == null) {
            return null;
        }
        if (address2.length() == 0) {
            return null;
        }
        byte[] bytes = Base58.decodeChecked(address2);
        if (bytes == null || bytes.length != 21) {
            return null;
        }
        return new Address(bytes);
    }

    public static Address fromP2SHBytes(byte[] bytes, NetworkParameters network) {
        if (bytes.length != 20) {
            return null;
        }
        byte[] all = new byte[21];
        all[0] = (byte)(network.getMultisigAddressHeader() & 0xFF);
        System.arraycopy(bytes, 0, all, 1, 20);
        return new Address(all);
    }

    public static Address fromStandardBytes(byte[] bytes, NetworkParameters network) {
        if (bytes.length != 20) {
            return null;
        }
        byte[] all = new byte[21];
        all[0] = (byte)(network.getStandardAddressHeader() & 0xFF);
        System.arraycopy(bytes, 0, all, 1, 20);
        return new Address(all);
    }

    public Address(byte[] bytes) {
        this._bytes = bytes;
        this._address = null;
    }

    public Address(byte[] bytes, String stringAddress) {
        this._bytes = bytes;
        this._address = stringAddress;
    }

    public boolean isValidAddress(NetworkParameters network) {
        byte version = this.getVersion();
        if (this.getAllAddressBytes().length != 21) {
            return false;
        }
        return (byte)(network.getStandardAddressHeader() & 0xFF) == version || (byte)(network.getMultisigAddressHeader() & 0xFF) == version;
    }

    public boolean isMultisig(NetworkParameters network) {
        return this.getVersion() == (byte)(network.getMultisigAddressHeader() & 0xFF);
    }

    public byte getVersion() {
        return this._bytes[0];
    }

    public byte[] getAllAddressBytes() {
        return this._bytes;
    }

    public byte[] getTypeSpecificBytes() {
        byte[] result = new byte[20];
        System.arraycopy(this._bytes, 1, result, 0, 20);
        return result;
    }

    public String toString() {
        if (this._address == null) {
            byte[] addressBytes = new byte[25];
            addressBytes[0] = this._bytes[0];
            System.arraycopy(this._bytes, 0, addressBytes, 0, 21);
            Sha256Hash checkSum = HashUtils.doubleSha256(addressBytes, 0, 21);
            System.arraycopy(checkSum.getBytes(), 0, addressBytes, 21, 4);
            this._address = Base58.encode(addressBytes);
        }
        return this._address;
    }

    public String getShortAddress() {
        return this.getShortAddress(6);
    }

    public String getShortAddress(int showChars) {
        String addressString = this.toString();
        return addressString.substring(0, showChars) + "..." + addressString.substring(addressString.length() - showChars);
    }

    public int hashCode() {
        return this._bytes[16] & 0xFF | (this._bytes[17] & 0xFF) << 8 | (this._bytes[18] & 0xFF) << 16 | (this._bytes[19] & 0xFF) << 24;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        return BitUtils.areEqual(this._bytes, ((Address)obj)._bytes);
    }

    public static Address getNullAddress(NetworkParameters network) {
        byte[] bytes = new byte[21];
        bytes[0] = (byte)(network.getStandardAddressHeader() & 0xFF);
        return new Address(bytes);
    }

    @Override
    public int compareTo(Address other) {
        for (int i = 0; i < 21; ++i) {
            byte a = this._bytes[i];
            byte b = other._bytes[i];
            if (a < b) {
                return -1;
            }
            if (a <= b) continue;
            return 1;
        }
        return 0;
    }

    public String toMultiLineString() {
        StringBuilder sb = new StringBuilder();
        String address2 = this.toString();
        sb.append(address2.substring(0, 12)).append("\r\n");
        sb.append(address2.substring(12, 24)).append("\r\n");
        sb.append(address2.substring(24));
        return sb.toString();
    }

    public String toDoubleLineString() {
        StringBuilder sb = new StringBuilder();
        String address2 = this.toString();
        int splitIndex = address2.length() / 2;
        sb.append(address2.substring(0, splitIndex)).append("\r\n");
        sb.append(address2.substring(splitIndex));
        return sb.toString();
    }

    public NetworkParameters getNetwork() {
        if (this.matchesNetwork(NetworkParameters.productionNetwork, this.getVersion())) {
            return NetworkParameters.productionNetwork;
        }
        if (this.matchesNetwork(NetworkParameters.testNetwork, this.getVersion())) {
            return NetworkParameters.testNetwork;
        }
        throw new IllegalStateException("unknown network");
    }

    private boolean matchesNetwork(NetworkParameters network, byte version) {
        return (byte)(network.getStandardAddressHeader() & 0xFF) == version || (byte)(network.getMultisigAddressHeader() & 0xFF) == version;
    }
}

