/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.model.Transaction;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteWriter;
import com.github.chouheiwa.wallet.socket.bitlib.util.HashUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.Sha256Hash;

public class Block {
    public static final int MAX_BLOCK_SIZE = 1000000;
    public int version;
    public Sha256Hash prevBlockHash;
    public Sha256Hash merkleRoot;
    public int time;
    public int difficultyTarget;
    public int nonce;
    public Transaction[] transactions;
    private Sha256Hash _hash;

    public static Block fromBlockStore(ByteReader reader) throws BlockParsingException {
        try {
            int version = reader.getIntLE();
            Sha256Hash prevBlockHash = reader.getSha256Hash().reverse();
            Sha256Hash merkleRoot = reader.getSha256Hash().reverse();
            int time = reader.getIntLE();
            int difficultyTarget = reader.getIntLE();
            int nonce = reader.getIntLE();
            int numTransactions = (int)reader.getCompactInt();
            Transaction[] transactions = new Transaction[numTransactions];
            for (int i = 0; i < numTransactions; ++i) {
                try {
                    transactions[i] = Transaction.fromByteReader(reader);
                    continue;
                }
                catch (Transaction.TransactionParsingException e) {
                    throw new BlockParsingException("Unable to parse transaction at index " + i + ": " + e.getMessage());
                }
            }
            return new Block(version, prevBlockHash, merkleRoot, time, difficultyTarget, nonce, transactions);
        }
        catch (ByteReader.InsufficientBytesException e) {
            throw new BlockParsingException(e.getMessage());
        }
    }

    public Block(int version, Sha256Hash prevBlockHash, Sha256Hash merkleRoot, int time, int difficultyTargetm, int nonce, Transaction[] transactions) {
        this.version = version;
        this.prevBlockHash = prevBlockHash;
        this.merkleRoot = merkleRoot;
        this.time = time;
        this.difficultyTarget = difficultyTargetm;
        this.nonce = nonce;
        this.transactions = transactions;
    }

    public void toByteWriter(ByteWriter writer) {
        this.headerToByteWriter(writer);
        this.transactionsToByteWriter(writer);
    }

    public void headerToByteWriter(ByteWriter writer) {
        writer.putIntLE(this.version);
        writer.putSha256Hash(this.prevBlockHash, true);
        writer.putSha256Hash(this.merkleRoot, true);
        writer.putIntLE(this.time);
        writer.putIntLE(this.difficultyTarget);
        writer.putIntLE(this.nonce);
    }

    public void transactionsToByteWriter(ByteWriter writer) {
        writer.putCompactInt(this.transactions.length);
        for (Transaction t : this.transactions) {
            t.toByteWriter(writer);
        }
    }

    public Sha256Hash getHash() {
        if (this._hash == null) {
            ByteWriter writer = new ByteWriter(2000);
            this.headerToByteWriter(writer);
            this._hash = HashUtils.doubleSha256(writer.toBytes()).reverse();
        }
        return this._hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Hash: ").append(this.getHash().toString());
        sb.append(" PrevHash: ").append(this.prevBlockHash.toString());
        sb.append(" #Tx: ").append(this.transactions.length);
        return sb.toString();
    }

    public int hashCode() {
        return this.getHash().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Block)) {
            return false;
        }
        return this.getHash().equals(((Block)other).getHash());
    }

    public static class BlockParsingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BlockParsingException(String message) {
            super(message);
        }

        public BlockParsingException(String message, Exception e) {
            super(message, e);
        }
    }
}

