/*
 * Decompiled with CFR 0.152.
 */
package com.github.chouheiwa.wallet.socket.bitlib.model;

import com.github.chouheiwa.wallet.socket.bitlib.util.BitUtils;
import com.github.chouheiwa.wallet.socket.bitlib.util.ByteReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CompactInt {
    public static long fromByteBuffer(ByteBuffer buf) {
        long value;
        if (buf.remaining() < 1) {
            return -1L;
        }
        long first = 0xFFL & (long)buf.get();
        if (first < 253L) {
            value = 0xFFL & first;
        } else if (first == 253L) {
            if (buf.remaining() < 2) {
                return -1L;
            }
            buf.order(ByteOrder.LITTLE_ENDIAN);
            value = 0xFFFFL & (long)buf.getShort();
        } else if (first == 254L) {
            if (buf.remaining() < 4) {
                return -1L;
            }
            buf.order(ByteOrder.LITTLE_ENDIAN);
            value = 0xFFFFFFFFFFFFFFFFL & (long)buf.getInt();
        } else {
            if (buf.remaining() < 8) {
                return -1L;
            }
            buf.order(ByteOrder.LITTLE_ENDIAN);
            value = buf.getLong();
        }
        return value;
    }

    public static long fromByteReader(ByteReader reader) throws ByteReader.InsufficientBytesException {
        long first = 0xFFL & (long)reader.get();
        long value = first < 253L ? 0xFFL & first : (first == 253L ? 0xFFFFL & (long)reader.getShortLE() : (first == 254L ? 0xFFFFFFFFFFFFFFFFL & (long)reader.getIntLE() : reader.getLongLE()));
        return value;
    }

    public static void toByteBuffer(long value, ByteBuffer buf) {
        buf.put(CompactInt.toBytes(value));
    }

    public static byte[] toBytes(long value) {
        if (CompactInt.isLessThan(value, 253L)) {
            return new byte[]{(byte)value};
        }
        if (CompactInt.isLessThan(value, 65536L)) {
            return new byte[]{-3, (byte)value, (byte)(value >> 8)};
        }
        if (CompactInt.isLessThan(value, 0xFFFFFFFFL)) {
            byte[] bytes = new byte[5];
            bytes[0] = -2;
            BitUtils.uint32ToByteArrayLE(value, bytes, 1);
            return bytes;
        }
        byte[] bytes = new byte[9];
        bytes[0] = -1;
        BitUtils.uint32ToByteArrayLE(value, bytes, 1);
        BitUtils.uint32ToByteArrayLE(value >>> 32, bytes, 5);
        return bytes;
    }

    private static boolean isLessThan(long n1, long n2) {
        return n1 < n2 ^ n1 < 0L != n2 < 0L;
    }
}

